/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.List;
import org.jfree.data.KeyedObjects2D;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.statistics.MeanAndStandardDeviation;
import org.jfree.data.statistics.StatisticalCategoryDataset;
import org.jfree.util.PublicCloneable;

public class DefaultStatisticalCategoryDataset
extends AbstractDataset
implements RangeInfo,
StatisticalCategoryDataset,
PublicCloneable {
    private KeyedObjects2D data = new KeyedObjects2D();
    private double minimumRangeValue = Double.NaN;
    private int minimumRangeValueRow = -1;
    private int minimumRangeValueColumn = -1;
    private double minimumRangeValueIncStdDev;
    private int minimumRangeValueIncStdDevRow = -1;
    private int minimumRangeValueIncStdDevColumn = -1;
    private double maximumRangeValue = Double.NaN;
    private int maximumRangeValueRow = -1;
    private int maximumRangeValueColumn = -1;
    private double maximumRangeValueIncStdDev;
    private int maximumRangeValueIncStdDevRow = -1;
    private int maximumRangeValueIncStdDevColumn = -1;

    public DefaultStatisticalCategoryDataset() {
        this.minimumRangeValueIncStdDev = Double.NaN;
        this.maximumRangeValueIncStdDev = Double.NaN;
    }

    @Override
    public Number getMeanValue(int n2, int n3) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(n2, n3);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getMean();
        }
        return number;
    }

    @Override
    public Number getValue(int n2, int n3) {
        return this.getMeanValue(n2, n3);
    }

    @Override
    public Number getValue(Comparable comparable, Comparable comparable2) {
        return this.getMeanValue(comparable, comparable2);
    }

    @Override
    public Number getMeanValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(comparable, comparable2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getMean();
        }
        return number;
    }

    @Override
    public Number getStdDevValue(int n2, int n3) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(n2, n3);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getStandardDeviation();
        }
        return number;
    }

    @Override
    public Number getStdDevValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(comparable, comparable2);
        if (meanAndStandardDeviation != null) {
            number = meanAndStandardDeviation.getStandardDeviation();
        }
        return number;
    }

    @Override
    public int getColumnIndex(Comparable comparable) {
        return this.data.getColumnIndex(comparable);
    }

    @Override
    public Comparable getColumnKey(int n2) {
        return this.data.getColumnKey(n2);
    }

    @Override
    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    @Override
    public int getRowIndex(Comparable comparable) {
        return this.data.getRowIndex(comparable);
    }

    @Override
    public Comparable getRowKey(int n2) {
        return this.data.getRowKey(n2);
    }

    @Override
    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    @Override
    public int getRowCount() {
        return this.data.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    public void add(double d2, double d3, Comparable comparable, Comparable comparable2) {
        this.add(new Double(d2), new Double(d3), comparable, comparable2);
    }

    public void add(Number number, Number number2, Comparable comparable, Comparable comparable2) {
        MeanAndStandardDeviation meanAndStandardDeviation = new MeanAndStandardDeviation(number, number2);
        this.data.addObject(meanAndStandardDeviation, comparable, comparable2);
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        if (number != null) {
            d2 = number.doubleValue();
        }
        if (number2 != null) {
            d3 = number2.doubleValue();
        }
        int n2 = this.data.getColumnIndex(comparable2);
        int n3 = this.data.getRowIndex(comparable);
        if (n2 == this.maximumRangeValueRow && n3 == this.maximumRangeValueColumn || n2 == this.maximumRangeValueIncStdDevRow && n3 == this.maximumRangeValueIncStdDevColumn || n2 == this.minimumRangeValueRow && n3 == this.minimumRangeValueColumn || n2 == this.minimumRangeValueIncStdDevRow && n3 == this.minimumRangeValueIncStdDevColumn) {
            this.updateBounds();
        } else {
            if (!Double.isNaN(d2) && (Double.isNaN(this.maximumRangeValue) || d2 > this.maximumRangeValue)) {
                this.maximumRangeValue = d2;
                this.maximumRangeValueRow = n2;
                this.maximumRangeValueColumn = n3;
            }
            if (!Double.isNaN(d2 + d3) && (Double.isNaN(this.maximumRangeValueIncStdDev) || d2 + d3 > this.maximumRangeValueIncStdDev)) {
                this.maximumRangeValueIncStdDev = d2 + d3;
                this.maximumRangeValueIncStdDevRow = n2;
                this.maximumRangeValueIncStdDevColumn = n3;
            }
            if (!Double.isNaN(d2) && (Double.isNaN(this.minimumRangeValue) || d2 < this.minimumRangeValue)) {
                this.minimumRangeValue = d2;
                this.minimumRangeValueRow = n2;
                this.minimumRangeValueColumn = n3;
            }
            if (!Double.isNaN(d2 - d3) && (Double.isNaN(this.minimumRangeValueIncStdDev) || d2 - d3 < this.minimumRangeValueIncStdDev)) {
                this.minimumRangeValueIncStdDev = d2 - d3;
                this.minimumRangeValueIncStdDevRow = n2;
                this.minimumRangeValueIncStdDevColumn = n3;
            }
        }
        this.fireDatasetChanged();
    }

    public void remove(Comparable comparable, Comparable comparable2) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        this.data.removeObject(comparable, comparable2);
        if (n2 == this.maximumRangeValueRow && n3 == this.maximumRangeValueColumn || n2 == this.maximumRangeValueIncStdDevRow && n3 == this.maximumRangeValueIncStdDevColumn || n2 == this.minimumRangeValueRow && n3 == this.minimumRangeValueColumn || n2 == this.minimumRangeValueIncStdDevRow && n3 == this.minimumRangeValueIncStdDevColumn) {
            this.updateBounds();
        }
        this.fireDatasetChanged();
    }

    public void removeRow(int n2) {
        this.data.removeRow(n2);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeRow(Comparable comparable) {
        this.data.removeRow(comparable);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeColumn(int n2) {
        this.data.removeColumn(n2);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeColumn(Comparable comparable) {
        this.data.removeColumn(comparable);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void clear() {
        this.data.clear();
        this.updateBounds();
        this.fireDatasetChanged();
    }

    private void updateBounds() {
        this.maximumRangeValue = Double.NaN;
        this.maximumRangeValueRow = -1;
        this.maximumRangeValueColumn = -1;
        this.minimumRangeValue = Double.NaN;
        this.minimumRangeValueRow = -1;
        this.minimumRangeValueColumn = -1;
        this.maximumRangeValueIncStdDev = Double.NaN;
        this.maximumRangeValueIncStdDevRow = -1;
        this.maximumRangeValueIncStdDevColumn = -1;
        this.minimumRangeValueIncStdDev = Double.NaN;
        this.minimumRangeValueIncStdDevRow = -1;
        this.minimumRangeValueIncStdDevColumn = -1;
        int n2 = this.data.getRowCount();
        int n3 = this.data.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                MeanAndStandardDeviation meanAndStandardDeviation = (MeanAndStandardDeviation)this.data.getObject(i2, i3);
                if (meanAndStandardDeviation == null) continue;
                double d2 = meanAndStandardDeviation.getMeanValue();
                double d3 = meanAndStandardDeviation.getStandardDeviationValue();
                if (Double.isNaN(d2)) continue;
                if (Double.isNaN(this.maximumRangeValue)) {
                    this.maximumRangeValue = d2;
                    this.maximumRangeValueRow = i2;
                    this.maximumRangeValueColumn = i3;
                } else if (d2 > this.maximumRangeValue) {
                    this.maximumRangeValue = d2;
                    this.maximumRangeValueRow = i2;
                    this.maximumRangeValueColumn = i3;
                }
                if (Double.isNaN(this.minimumRangeValue)) {
                    this.minimumRangeValue = d2;
                    this.minimumRangeValueRow = i2;
                    this.minimumRangeValueColumn = i3;
                } else if (d2 < this.minimumRangeValue) {
                    this.minimumRangeValue = d2;
                    this.minimumRangeValueRow = i2;
                    this.minimumRangeValueColumn = i3;
                }
                if (Double.isNaN(d3)) continue;
                if (Double.isNaN(this.maximumRangeValueIncStdDev)) {
                    this.maximumRangeValueIncStdDev = d2 + d3;
                    this.maximumRangeValueIncStdDevRow = i2;
                    this.maximumRangeValueIncStdDevColumn = i3;
                } else if (d2 + d3 > this.maximumRangeValueIncStdDev) {
                    this.maximumRangeValueIncStdDev = d2 + d3;
                    this.maximumRangeValueIncStdDevRow = i2;
                    this.maximumRangeValueIncStdDevColumn = i3;
                }
                if (Double.isNaN(this.minimumRangeValueIncStdDev)) {
                    this.minimumRangeValueIncStdDev = d2 - d3;
                    this.minimumRangeValueIncStdDevRow = i2;
                    this.minimumRangeValueIncStdDevColumn = i3;
                    continue;
                }
                if (!(d2 - d3 < this.minimumRangeValueIncStdDev)) continue;
                this.minimumRangeValueIncStdDev = d2 - d3;
                this.minimumRangeValueIncStdDevRow = i2;
                this.minimumRangeValueIncStdDevColumn = i3;
            }
        }
    }

    @Override
    public double getRangeLowerBound(boolean bl2) {
        if (bl2 && !Double.isNaN(this.minimumRangeValueIncStdDev)) {
            return this.minimumRangeValueIncStdDev;
        }
        return this.minimumRangeValue;
    }

    @Override
    public double getRangeUpperBound(boolean bl2) {
        if (bl2 && !Double.isNaN(this.maximumRangeValueIncStdDev)) {
            return this.maximumRangeValueIncStdDev;
        }
        return this.maximumRangeValue;
    }

    @Override
    public Range getRangeBounds(boolean bl2) {
        double d2 = this.getRangeLowerBound(bl2);
        double d3 = this.getRangeUpperBound(bl2);
        if (Double.isNaN(d2) && Double.isNaN(d3)) {
            return null;
        }
        return new Range(d2, d3);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultStatisticalCategoryDataset)) {
            return false;
        }
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = (DefaultStatisticalCategoryDataset)object;
        return this.data.equals(defaultStatisticalCategoryDataset.data);
    }

    @Override
    public Object clone() {
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = (DefaultStatisticalCategoryDataset)super.clone();
        defaultStatisticalCategoryDataset.data = (KeyedObjects2D)this.data.clone();
        return defaultStatisticalCategoryDataset;
    }
}

