/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.KeyedObjects2D;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.statistics.MultiValueCategoryDataset;
import org.jfree.util.PublicCloneable;

public class DefaultMultiValueCategoryDataset
extends AbstractDataset
implements RangeInfo,
MultiValueCategoryDataset,
PublicCloneable {
    protected KeyedObjects2D data = new KeyedObjects2D();
    private Number minimumRangeValue = null;
    private Number maximumRangeValue = null;
    private Range rangeBounds = new Range(0.0, 0.0);

    public void add(List list, Comparable comparable, Comparable comparable2) {
        double d2;
        ParamChecks.nullNotPermitted(list, "values");
        ParamChecks.nullNotPermitted(comparable, "rowKey");
        ParamChecks.nullNotPermitted(comparable2, "columnKey");
        ArrayList<Number> arrayList = new ArrayList<Number>(list.size());
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Number number;
            Object e2 = listIterator.next();
            if (!(e2 instanceof Number) || Double.isNaN(d2 = (number = (Number)e2).doubleValue())) continue;
            arrayList.add(number);
        }
        Collections.sort(arrayList);
        this.data.addObject(arrayList, comparable, comparable2);
        if (arrayList.size() > 0) {
            double d3 = Double.NEGATIVE_INFINITY;
            d2 = Double.POSITIVE_INFINITY;
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                Number number = (Number)arrayList.get(i2);
                double d4 = number.doubleValue();
                d2 = Math.min(d2, d4);
                d3 = Math.max(d3, d4);
            }
            if (this.maximumRangeValue == null) {
                this.maximumRangeValue = new Double(d3);
            } else if (d3 > this.maximumRangeValue.doubleValue()) {
                this.maximumRangeValue = new Double(d3);
            }
            if (this.minimumRangeValue == null) {
                this.minimumRangeValue = new Double(d2);
            } else if (d2 < this.minimumRangeValue.doubleValue()) {
                this.minimumRangeValue = new Double(d2);
            }
            this.rangeBounds = new Range(this.minimumRangeValue.doubleValue(), this.maximumRangeValue.doubleValue());
        }
        this.fireDatasetChanged();
    }

    @Override
    public List getValues(int n2, int n3) {
        List list = (List)this.data.getObject(n2, n3);
        if (list != null) {
            return Collections.unmodifiableList(list);
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getValues(Comparable comparable, Comparable comparable2) {
        return Collections.unmodifiableList((List)this.data.getObject(comparable, comparable2));
    }

    @Override
    public Number getValue(Comparable comparable, Comparable comparable2) {
        List list = (List)this.data.getObject(comparable, comparable2);
        double d2 = 0.0;
        int n2 = 0;
        if (list != null && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Number number = (Number)list.get(i2);
                d2 += number.doubleValue();
                ++n2;
            }
            if (n2 > 0) {
                d2 /= (double)n2;
            }
        }
        if (n2 == 0) {
            return null;
        }
        return new Double(d2);
    }

    @Override
    public Number getValue(int n2, int n3) {
        List list = (List)this.data.getObject(n2, n3);
        double d2 = 0.0;
        int n4 = 0;
        if (list != null && list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                Number number = (Number)list.get(i2);
                d2 += number.doubleValue();
                ++n4;
            }
            if (n4 > 0) {
                d2 /= (double)n4;
            }
        }
        if (n4 == 0) {
            return null;
        }
        return new Double(d2);
    }

    @Override
    public int getColumnIndex(Comparable comparable) {
        return this.data.getColumnIndex(comparable);
    }

    @Override
    public Comparable getColumnKey(int n2) {
        return this.data.getColumnKey(n2);
    }

    @Override
    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    @Override
    public int getRowIndex(Comparable comparable) {
        return this.data.getRowIndex(comparable);
    }

    @Override
    public Comparable getRowKey(int n2) {
        return this.data.getRowKey(n2);
    }

    @Override
    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    @Override
    public int getRowCount() {
        return this.data.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    @Override
    public double getRangeLowerBound(boolean bl2) {
        double d2 = Double.NaN;
        if (this.minimumRangeValue != null) {
            d2 = this.minimumRangeValue.doubleValue();
        }
        return d2;
    }

    @Override
    public double getRangeUpperBound(boolean bl2) {
        double d2 = Double.NaN;
        if (this.maximumRangeValue != null) {
            d2 = this.maximumRangeValue.doubleValue();
        }
        return d2;
    }

    @Override
    public Range getRangeBounds(boolean bl2) {
        return this.rangeBounds;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultMultiValueCategoryDataset)) {
            return false;
        }
        DefaultMultiValueCategoryDataset defaultMultiValueCategoryDataset = (DefaultMultiValueCategoryDataset)object;
        return this.data.equals(defaultMultiValueCategoryDataset.data);
    }

    @Override
    public Object clone() {
        DefaultMultiValueCategoryDataset defaultMultiValueCategoryDataset = (DefaultMultiValueCategoryDataset)super.clone();
        defaultMultiValueCategoryDataset.data = (KeyedObjects2D)this.data.clone();
        return defaultMultiValueCategoryDataset;
    }
}

