/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.util.ObjectUtilities;

public class DefaultBoxAndWhiskerXYDataset
extends AbstractXYDataset
implements RangeInfo,
BoxAndWhiskerXYDataset {
    private Comparable seriesKey;
    private List dates;
    private List items;
    private Number minimumRangeValue;
    private Number maximumRangeValue;
    private Range rangeBounds;
    private double outlierCoefficient = 1.5;
    private double faroutCoefficient = 2.0;

    public DefaultBoxAndWhiskerXYDataset(Comparable comparable) {
        this.seriesKey = comparable;
        this.dates = new ArrayList();
        this.items = new ArrayList();
        this.minimumRangeValue = null;
        this.maximumRangeValue = null;
        this.rangeBounds = null;
    }

    @Override
    public double getOutlierCoefficient() {
        return this.outlierCoefficient;
    }

    public void setOutlierCoefficient(double d2) {
        this.outlierCoefficient = d2;
    }

    @Override
    public double getFaroutCoefficient() {
        return this.faroutCoefficient;
    }

    public void setFaroutCoefficient(double d2) {
        if (!(d2 > this.getOutlierCoefficient())) {
            throw new IllegalArgumentException("Farout value must be greater than the outlier value, which is currently set at: (" + this.getOutlierCoefficient() + ")");
        }
        this.faroutCoefficient = d2;
    }

    @Override
    public int getSeriesCount() {
        return 1;
    }

    @Override
    public int getItemCount(int n2) {
        return this.dates.size();
    }

    public void add(Date date, BoxAndWhiskerItem boxAndWhiskerItem) {
        this.dates.add(date);
        this.items.add(boxAndWhiskerItem);
        if (this.minimumRangeValue == null) {
            this.minimumRangeValue = boxAndWhiskerItem.getMinRegularValue();
        } else if (boxAndWhiskerItem.getMinRegularValue().doubleValue() < this.minimumRangeValue.doubleValue()) {
            this.minimumRangeValue = boxAndWhiskerItem.getMinRegularValue();
        }
        if (this.maximumRangeValue == null) {
            this.maximumRangeValue = boxAndWhiskerItem.getMaxRegularValue();
        } else if (boxAndWhiskerItem.getMaxRegularValue().doubleValue() > this.maximumRangeValue.doubleValue()) {
            this.maximumRangeValue = boxAndWhiskerItem.getMaxRegularValue();
        }
        this.rangeBounds = new Range(this.minimumRangeValue.doubleValue(), this.maximumRangeValue.doubleValue());
        this.fireDatasetChanged();
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        return this.seriesKey;
    }

    public BoxAndWhiskerItem getItem(int n2, int n3) {
        return (BoxAndWhiskerItem)this.items.get(n3);
    }

    @Override
    public Number getX(int n2, int n3) {
        return new Long(((Date)this.dates.get(n3)).getTime());
    }

    public Date getXDate(int n2, int n3) {
        return (Date)this.dates.get(n3);
    }

    @Override
    public Number getY(int n2, int n3) {
        return this.getMeanValue(n2, n3);
    }

    @Override
    public Number getMeanValue(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMean();
        }
        return number;
    }

    @Override
    public Number getMedianValue(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMedian();
        }
        return number;
    }

    @Override
    public Number getQ1Value(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ1();
        }
        return number;
    }

    @Override
    public Number getQ3Value(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ3();
        }
        return number;
    }

    @Override
    public Number getMinRegularValue(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinRegularValue();
        }
        return number;
    }

    @Override
    public Number getMaxRegularValue(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxRegularValue();
        }
        return number;
    }

    @Override
    public Number getMinOutlier(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinOutlier();
        }
        return number;
    }

    @Override
    public Number getMaxOutlier(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxOutlier();
        }
        return number;
    }

    @Override
    public List getOutliers(int n2, int n3) {
        List list = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.items.get(n3);
        if (boxAndWhiskerItem != null) {
            list = boxAndWhiskerItem.getOutliers();
        }
        return list;
    }

    @Override
    public double getRangeLowerBound(boolean bl2) {
        double d2 = Double.NaN;
        if (this.minimumRangeValue != null) {
            d2 = this.minimumRangeValue.doubleValue();
        }
        return d2;
    }

    @Override
    public double getRangeUpperBound(boolean bl2) {
        double d2 = Double.NaN;
        if (this.maximumRangeValue != null) {
            d2 = this.maximumRangeValue.doubleValue();
        }
        return d2;
    }

    @Override
    public Range getRangeBounds(boolean bl2) {
        return this.rangeBounds;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultBoxAndWhiskerXYDataset)) {
            return false;
        }
        DefaultBoxAndWhiskerXYDataset defaultBoxAndWhiskerXYDataset = (DefaultBoxAndWhiskerXYDataset)object;
        if (!ObjectUtilities.equal(this.seriesKey, defaultBoxAndWhiskerXYDataset.seriesKey)) {
            return false;
        }
        if (!this.dates.equals(defaultBoxAndWhiskerXYDataset.dates)) {
            return false;
        }
        return this.items.equals(defaultBoxAndWhiskerXYDataset.items);
    }

    @Override
    public Object clone() {
        DefaultBoxAndWhiskerXYDataset defaultBoxAndWhiskerXYDataset = (DefaultBoxAndWhiskerXYDataset)super.clone();
        defaultBoxAndWhiskerXYDataset.dates = new ArrayList(this.dates);
        defaultBoxAndWhiskerXYDataset.items = new ArrayList(this.items);
        return defaultBoxAndWhiskerXYDataset;
    }
}

