/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.util.List;
import org.jfree.data.KeyedObjects2D;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.statistics.BoxAndWhiskerCalculator;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerItem;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class DefaultBoxAndWhiskerCategoryDataset
extends AbstractDataset
implements RangeInfo,
BoxAndWhiskerCategoryDataset,
PublicCloneable {
    protected KeyedObjects2D data = new KeyedObjects2D();
    private double minimumRangeValue = Double.NaN;
    private int minimumRangeValueRow = -1;
    private int minimumRangeValueColumn = -1;
    private double maximumRangeValue = Double.NaN;
    private int maximumRangeValueRow = -1;
    private int maximumRangeValueColumn = -1;

    public void add(List list, Comparable comparable, Comparable comparable2) {
        BoxAndWhiskerItem boxAndWhiskerItem = BoxAndWhiskerCalculator.calculateBoxAndWhiskerStatistics(list);
        this.add(boxAndWhiskerItem, comparable, comparable2);
    }

    public void add(BoxAndWhiskerItem boxAndWhiskerItem, Comparable comparable, Comparable comparable2) {
        this.data.addObject(boxAndWhiskerItem, comparable, comparable2);
        int n2 = this.data.getRowIndex(comparable);
        int n3 = this.data.getColumnIndex(comparable2);
        if (this.maximumRangeValueRow == n2 && this.maximumRangeValueColumn == n3 || this.minimumRangeValueRow == n2 && this.minimumRangeValueColumn == n3) {
            this.updateBounds();
        } else {
            double d2 = Double.NaN;
            if (boxAndWhiskerItem.getMinOutlier() != null) {
                d2 = boxAndWhiskerItem.getMinOutlier().doubleValue();
            }
            double d3 = Double.NaN;
            if (boxAndWhiskerItem.getMaxOutlier() != null) {
                d3 = boxAndWhiskerItem.getMaxOutlier().doubleValue();
            }
            if (Double.isNaN(this.maximumRangeValue)) {
                this.maximumRangeValue = d3;
                this.maximumRangeValueRow = n2;
                this.maximumRangeValueColumn = n3;
            } else if (d3 > this.maximumRangeValue) {
                this.maximumRangeValue = d3;
                this.maximumRangeValueRow = n2;
                this.maximumRangeValueColumn = n3;
            }
            if (Double.isNaN(this.minimumRangeValue)) {
                this.minimumRangeValue = d2;
                this.minimumRangeValueRow = n2;
                this.minimumRangeValueColumn = n3;
            } else if (d2 < this.minimumRangeValue) {
                this.minimumRangeValue = d2;
                this.minimumRangeValueRow = n2;
                this.minimumRangeValueColumn = n3;
            }
        }
        this.fireDatasetChanged();
    }

    public void remove(Comparable comparable, Comparable comparable2) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        this.data.removeObject(comparable, comparable2);
        if (this.maximumRangeValueRow == n2 && this.maximumRangeValueColumn == n3 || this.minimumRangeValueRow == n2 && this.minimumRangeValueColumn == n3) {
            this.updateBounds();
        }
        this.fireDatasetChanged();
    }

    public void removeRow(int n2) {
        this.data.removeRow(n2);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeRow(Comparable comparable) {
        this.data.removeRow(comparable);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeColumn(int n2) {
        this.data.removeColumn(n2);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void removeColumn(Comparable comparable) {
        this.data.removeColumn(comparable);
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public void clear() {
        this.data.clear();
        this.updateBounds();
        this.fireDatasetChanged();
    }

    public BoxAndWhiskerItem getItem(int n2, int n3) {
        return (BoxAndWhiskerItem)this.data.getObject(n2, n3);
    }

    @Override
    public Number getValue(int n2, int n3) {
        return this.getMedianValue(n2, n3);
    }

    @Override
    public Number getValue(Comparable comparable, Comparable comparable2) {
        return this.getMedianValue(comparable, comparable2);
    }

    @Override
    public Number getMeanValue(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n2, n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMean();
        }
        return number;
    }

    @Override
    public Number getMeanValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMean();
        }
        return number;
    }

    @Override
    public Number getMedianValue(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n2, n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMedian();
        }
        return number;
    }

    @Override
    public Number getMedianValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMedian();
        }
        return number;
    }

    @Override
    public Number getQ1Value(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n2, n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ1();
        }
        return number;
    }

    @Override
    public Number getQ1Value(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ1();
        }
        return number;
    }

    @Override
    public Number getQ3Value(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n2, n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ3();
        }
        return number;
    }

    @Override
    public Number getQ3Value(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getQ3();
        }
        return number;
    }

    @Override
    public int getColumnIndex(Comparable comparable) {
        return this.data.getColumnIndex(comparable);
    }

    @Override
    public Comparable getColumnKey(int n2) {
        return this.data.getColumnKey(n2);
    }

    @Override
    public List getColumnKeys() {
        return this.data.getColumnKeys();
    }

    @Override
    public int getRowIndex(Comparable comparable) {
        return this.data.getRowIndex(comparable);
    }

    @Override
    public Comparable getRowKey(int n2) {
        return this.data.getRowKey(n2);
    }

    @Override
    public List getRowKeys() {
        return this.data.getRowKeys();
    }

    @Override
    public int getRowCount() {
        return this.data.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.data.getColumnCount();
    }

    @Override
    public double getRangeLowerBound(boolean bl2) {
        return this.minimumRangeValue;
    }

    @Override
    public double getRangeUpperBound(boolean bl2) {
        return this.maximumRangeValue;
    }

    @Override
    public Range getRangeBounds(boolean bl2) {
        return new Range(this.minimumRangeValue, this.maximumRangeValue);
    }

    @Override
    public Number getMinRegularValue(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n2, n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinRegularValue();
        }
        return number;
    }

    @Override
    public Number getMinRegularValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinRegularValue();
        }
        return number;
    }

    @Override
    public Number getMaxRegularValue(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n2, n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxRegularValue();
        }
        return number;
    }

    @Override
    public Number getMaxRegularValue(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxRegularValue();
        }
        return number;
    }

    @Override
    public Number getMinOutlier(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n2, n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinOutlier();
        }
        return number;
    }

    @Override
    public Number getMinOutlier(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMinOutlier();
        }
        return number;
    }

    @Override
    public Number getMaxOutlier(int n2, int n3) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n2, n3);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxOutlier();
        }
        return number;
    }

    @Override
    public Number getMaxOutlier(Comparable comparable, Comparable comparable2) {
        Number number = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            number = boxAndWhiskerItem.getMaxOutlier();
        }
        return number;
    }

    @Override
    public List getOutliers(int n2, int n3) {
        List list = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(n2, n3);
        if (boxAndWhiskerItem != null) {
            list = boxAndWhiskerItem.getOutliers();
        }
        return list;
    }

    @Override
    public List getOutliers(Comparable comparable, Comparable comparable2) {
        List list = null;
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)this.data.getObject(comparable, comparable2);
        if (boxAndWhiskerItem != null) {
            list = boxAndWhiskerItem.getOutliers();
        }
        return list;
    }

    private void updateBounds() {
        this.minimumRangeValue = Double.NaN;
        this.minimumRangeValueRow = -1;
        this.minimumRangeValueColumn = -1;
        this.maximumRangeValue = Double.NaN;
        this.maximumRangeValueRow = -1;
        this.maximumRangeValueColumn = -1;
        int n2 = this.getRowCount();
        int n3 = this.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                double d2;
                Number number;
                double d3;
                BoxAndWhiskerItem boxAndWhiskerItem = this.getItem(i2, i3);
                if (boxAndWhiskerItem == null) continue;
                Number number2 = boxAndWhiskerItem.getMinOutlier();
                if (number2 != null && !Double.isNaN(d3 = number2.doubleValue()) && (d3 < this.minimumRangeValue || Double.isNaN(this.minimumRangeValue))) {
                    this.minimumRangeValue = d3;
                    this.minimumRangeValueRow = i2;
                    this.minimumRangeValueColumn = i3;
                }
                if ((number = boxAndWhiskerItem.getMaxOutlier()) == null || Double.isNaN(d2 = number.doubleValue()) || !(d2 > this.maximumRangeValue) && !Double.isNaN(this.maximumRangeValue)) continue;
                this.maximumRangeValue = d2;
                this.maximumRangeValueRow = i2;
                this.maximumRangeValueColumn = i3;
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof DefaultBoxAndWhiskerCategoryDataset) {
            DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = (DefaultBoxAndWhiskerCategoryDataset)object;
            return ObjectUtilities.equal(this.data, defaultBoxAndWhiskerCategoryDataset.data);
        }
        return false;
    }

    @Override
    public Object clone() {
        DefaultBoxAndWhiskerCategoryDataset defaultBoxAndWhiskerCategoryDataset = (DefaultBoxAndWhiskerCategoryDataset)super.clone();
        defaultBoxAndWhiskerCategoryDataset.data = (KeyedObjects2D)this.data.clone();
        return defaultBoxAndWhiskerCategoryDataset;
    }
}

