/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.statistics;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jfree.util.ObjectUtilities;

public class BoxAndWhiskerItem
implements Serializable {
    private static final long serialVersionUID = 7329649623148167423L;
    private Number mean;
    private Number median;
    private Number q1;
    private Number q3;
    private Number minRegularValue;
    private Number maxRegularValue;
    private Number minOutlier;
    private Number maxOutlier;
    private List outliers;

    public BoxAndWhiskerItem(Number number, Number number2, Number number3, Number number4, Number number5, Number number6, Number number7, Number number8, List list) {
        this.mean = number;
        this.median = number2;
        this.q1 = number3;
        this.q3 = number4;
        this.minRegularValue = number5;
        this.maxRegularValue = number6;
        this.minOutlier = number7;
        this.maxOutlier = number8;
        this.outliers = list;
    }

    public BoxAndWhiskerItem(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, List list) {
        this(new Double(d2), new Double(d3), new Double(d4), new Double(d5), new Double(d6), new Double(d7), new Double(d8), new Double(d9), list);
    }

    public Number getMean() {
        return this.mean;
    }

    public Number getMedian() {
        return this.median;
    }

    public Number getQ1() {
        return this.q1;
    }

    public Number getQ3() {
        return this.q3;
    }

    public Number getMinRegularValue() {
        return this.minRegularValue;
    }

    public Number getMaxRegularValue() {
        return this.maxRegularValue;
    }

    public Number getMinOutlier() {
        return this.minOutlier;
    }

    public Number getMaxOutlier() {
        return this.maxOutlier;
    }

    public List getOutliers() {
        if (this.outliers == null) {
            return null;
        }
        return Collections.unmodifiableList(this.outliers);
    }

    public String toString() {
        return super.toString() + "[mean=" + this.mean + ",median=" + this.median + ",q1=" + this.q1 + ",q3=" + this.q3 + "]";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BoxAndWhiskerItem)) {
            return false;
        }
        BoxAndWhiskerItem boxAndWhiskerItem = (BoxAndWhiskerItem)object;
        if (!ObjectUtilities.equal(this.mean, boxAndWhiskerItem.mean)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.median, boxAndWhiskerItem.median)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.q1, boxAndWhiskerItem.q1)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.q3, boxAndWhiskerItem.q3)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.minRegularValue, boxAndWhiskerItem.minRegularValue)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.maxRegularValue, boxAndWhiskerItem.maxRegularValue)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.minOutlier, boxAndWhiskerItem.minOutlier)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.maxOutlier, boxAndWhiskerItem.maxOutlier)) {
            return false;
        }
        return ObjectUtilities.equal(this.outliers, boxAndWhiskerItem.outliers);
    }
}

