/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.Log;

public class JDBCXYDataset
extends AbstractXYDataset
implements RangeInfo,
TableXYDataset,
XYDataset {
    private transient Connection connection;
    private String[] columnNames = new String[0];
    private ArrayList rows = new ArrayList();
    private double maxValue = 0.0;
    private double minValue = 0.0;
    private boolean isTimeSeries = false;

    private JDBCXYDataset() {
    }

    public JDBCXYDataset(String string, String string2, String string3, String string4) {
        this();
        Class.forName(string2);
        this.connection = DriverManager.getConnection(string, string3, string4);
    }

    public JDBCXYDataset(Connection connection) {
        this();
        this.connection = connection;
    }

    public JDBCXYDataset(Connection connection, String string) {
        this(connection);
        this.executeQuery(string);
    }

    public boolean isTimeSeries() {
        return this.isTimeSeries;
    }

    public void setTimeSeries(boolean bl2) {
        this.isTimeSeries = bl2;
    }

    public void executeQuery(String string) {
        this.executeQuery(this.connection, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(Connection connection, String string) {
        if (connection == null) {
            throw new SQLException("There is no database to execute the query.");
        }
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            int n2;
            int n3;
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n4 = resultSetMetaData.getColumnCount();
            int n5 = 0;
            int[] nArray = new int[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                try {
                    n2 = resultSetMetaData.getColumnType(n3 + 1);
                    switch (n2) {
                        case -7: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 91: 
                        case 92: 
                        case 93: {
                            ++n5;
                            nArray[n3] = n2;
                            break;
                        }
                        default: {
                            Log.warn("Unable to load column " + n3 + " (" + n2 + "," + resultSetMetaData.getColumnClassName(n3 + 1) + ")");
                            nArray[n3] = 0;
                            break;
                        }
                    }
                    continue;
                }
                catch (SQLException sQLException) {
                    nArray[n3] = 0;
                    throw sQLException;
                }
            }
            if (n5 <= 1) {
                throw new SQLException("Not enough valid columns where generated by query.");
            }
            this.columnNames = new String[n5 - 1];
            n3 = 0;
            for (n2 = 1; n2 < n4; ++n2) {
                if (nArray[n2] == 0) continue;
                this.columnNames[n3] = resultSetMetaData.getColumnLabel(n2 + 1);
                ++n3;
            }
            if (this.rows != null) {
                for (n2 = 0; n2 < this.rows.size(); ++n2) {
                    ArrayList arrayList = (ArrayList)this.rows.get(n2);
                    arrayList.clear();
                }
                this.rows.clear();
            }
            switch (nArray[0]) {
                case 91: 
                case 92: 
                case 93: {
                    this.isTimeSeries = true;
                    break;
                }
                default: {
                    this.isTimeSeries = false;
                }
            }
            while (resultSet.next()) {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                block28: for (int i2 = 0; i2 < n4; ++i2) {
                    Object object = resultSet.getObject(i2 + 1);
                    switch (nArray[i2]) {
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: {
                            arrayList.add(object);
                            continue block28;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            arrayList.add(new Long(((Date)object).getTime()));
                            continue block28;
                        }
                        case 0: {
                            continue block28;
                        }
                        default: {
                            System.err.println("Unknown data");
                            nArray[i2] = 0;
                        }
                    }
                }
                this.rows.add(arrayList);
            }
            if (this.rows.isEmpty()) {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (nArray[i3] == 0) continue;
                    arrayList.add(new Integer(0));
                }
                this.rows.add(arrayList);
            }
            if (this.rows.size() < 1) {
                this.maxValue = 0.0;
                this.minValue = 0.0;
            } else {
                this.maxValue = Double.NEGATIVE_INFINITY;
                this.minValue = Double.POSITIVE_INFINITY;
                for (int i4 = 0; i4 < this.rows.size(); ++i4) {
                    ArrayList arrayList = (ArrayList)this.rows.get(i4);
                    for (int i5 = 1; i5 < n4; ++i5) {
                        Object e2 = arrayList.get(i5);
                        if (e2 == null) continue;
                        double d2 = ((Number)e2).doubleValue();
                        if (d2 < this.minValue) {
                            this.minValue = d2;
                        }
                        if (!(d2 > this.maxValue)) continue;
                        this.maxValue = d2;
                    }
                }
            }
            this.fireDatasetChanged();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public Number getX(int n2, int n3) {
        ArrayList arrayList = (ArrayList)this.rows.get(n3);
        return (Number)arrayList.get(0);
    }

    @Override
    public Number getY(int n2, int n3) {
        ArrayList arrayList = (ArrayList)this.rows.get(n3);
        return (Number)arrayList.get(n2 + 1);
    }

    @Override
    public int getItemCount(int n2) {
        return this.rows.size();
    }

    @Override
    public int getItemCount() {
        return this.getItemCount(0);
    }

    @Override
    public int getSeriesCount() {
        return this.columnNames.length;
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        if (n2 < this.columnNames.length && this.columnNames[n2] != null) {
            return this.columnNames[n2];
        }
        return "";
    }

    public int getLegendItemCount() {
        return this.getSeriesCount();
    }

    public String[] getLegendItemLabels() {
        return this.columnNames;
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
    }

    @Override
    public double getRangeLowerBound(boolean bl2) {
        return this.minValue;
    }

    @Override
    public double getRangeUpperBound(boolean bl2) {
        return this.maxValue;
    }

    @Override
    public Range getRangeBounds(boolean bl2) {
        return new Range(this.minValue, this.maxValue);
    }
}

