/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.general.HeatMapDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public abstract class HeatMapUtilities {
    public static XYDataset extractRowFromHeatMapDataset(HeatMapDataset heatMapDataset, int n2, Comparable comparable) {
        XYSeries xYSeries = new XYSeries(comparable);
        int n3 = heatMapDataset.getXSampleCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            xYSeries.add(heatMapDataset.getXValue(i2), heatMapDataset.getZValue(i2, n2));
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }

    public static XYDataset extractColumnFromHeatMapDataset(HeatMapDataset heatMapDataset, int n2, Comparable comparable) {
        XYSeries xYSeries = new XYSeries(comparable);
        int n3 = heatMapDataset.getYSampleCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            xYSeries.add(heatMapDataset.getYValue(i2), heatMapDataset.getZValue(n2, i2));
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }

    public static BufferedImage createHeatMapImage(HeatMapDataset heatMapDataset, PaintScale paintScale) {
        ParamChecks.nullNotPermitted(heatMapDataset, "dataset");
        ParamChecks.nullNotPermitted(paintScale, "paintScale");
        int n2 = heatMapDataset.getXSampleCount();
        int n3 = heatMapDataset.getYSampleCount();
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                double d2 = heatMapDataset.getZValue(i2, i3);
                Paint paint = paintScale.getPaint(d2);
                graphics2D.setPaint(paint);
                graphics2D.fillRect(i2, n3 - i3 - 1, 1, 1);
            }
        }
        return bufferedImage;
    }
}

