/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.util.PublicCloneable;
import org.jfree.util.SortOrder;

public class DefaultPieDataset
extends AbstractDataset
implements Serializable,
Cloneable,
PieDataset,
PublicCloneable {
    private static final long serialVersionUID = 2904745139106540618L;
    private DefaultKeyedValues data;

    public DefaultPieDataset() {
        this.data = new DefaultKeyedValues();
    }

    public DefaultPieDataset(KeyedValues keyedValues) {
        ParamChecks.nullNotPermitted(keyedValues, "data");
        this.data = new DefaultKeyedValues();
        for (int i2 = 0; i2 < keyedValues.getItemCount(); ++i2) {
            this.data.addValue(keyedValues.getKey(i2), keyedValues.getValue(i2));
        }
    }

    @Override
    public int getItemCount() {
        return this.data.getItemCount();
    }

    @Override
    public List getKeys() {
        return Collections.unmodifiableList(this.data.getKeys());
    }

    @Override
    public Comparable getKey(int n2) {
        return this.data.getKey(n2);
    }

    @Override
    public int getIndex(Comparable comparable) {
        return this.data.getIndex(comparable);
    }

    @Override
    public Number getValue(int n2) {
        Number number = null;
        if (this.getItemCount() > n2) {
            number = this.data.getValue(n2);
        }
        return number;
    }

    @Override
    public Number getValue(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        return this.data.getValue(comparable);
    }

    public void setValue(Comparable comparable, Number number) {
        this.data.setValue(comparable, number);
        this.fireDatasetChanged();
    }

    public void setValue(Comparable comparable, double d2) {
        this.setValue(comparable, new Double(d2));
    }

    public void insertValue(int n2, Comparable comparable, double d2) {
        this.insertValue(n2, comparable, new Double(d2));
    }

    public void insertValue(int n2, Comparable comparable, Number number) {
        this.data.insertValue(n2, comparable, number);
        this.fireDatasetChanged();
    }

    public void remove(Comparable comparable) {
        this.data.removeValue(comparable);
        this.fireDatasetChanged();
    }

    public void clear() {
        if (this.getItemCount() > 0) {
            this.data.clear();
            this.fireDatasetChanged();
        }
    }

    public void sortByKeys(SortOrder sortOrder) {
        this.data.sortByKeys(sortOrder);
        this.fireDatasetChanged();
    }

    public void sortByValues(SortOrder sortOrder) {
        this.data.sortByValues(sortOrder);
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PieDataset)) {
            return false;
        }
        PieDataset pieDataset = (PieDataset)object;
        int n2 = this.getItemCount();
        if (pieDataset.getItemCount() != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i2);
            if (!comparable2.equals(comparable = pieDataset.getKey(i2))) {
                return false;
            }
            Number number = this.getValue(i2);
            Number number2 = pieDataset.getValue(i2);
            if (!(number == null ? number2 != null : !number.equals(number2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public Object clone() {
        DefaultPieDataset defaultPieDataset = (DefaultPieDataset)super.clone();
        defaultPieDataset.data = (DefaultKeyedValues)this.data.clone();
        return defaultPieDataset;
    }
}

