/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.io.Serializable;
import org.jfree.data.DataUtilities;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.HeatMapDataset;
import org.jfree.util.PublicCloneable;

public class DefaultHeatMapDataset
extends AbstractDataset
implements Serializable,
Cloneable,
HeatMapDataset,
PublicCloneable {
    private int xSamples;
    private int ySamples;
    private double minX;
    private double maxX;
    private double minY;
    private double maxY;
    private double[][] zValues;

    public DefaultHeatMapDataset(int n2, int n3, double d2, double d3, double d4, double d5) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Requires 'xSamples' > 0");
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Requires 'ySamples' > 0");
        }
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("'minX' cannot be INF or NaN.");
        }
        if (Double.isInfinite(d3) || Double.isNaN(d3)) {
            throw new IllegalArgumentException("'maxX' cannot be INF or NaN.");
        }
        if (Double.isInfinite(d4) || Double.isNaN(d4)) {
            throw new IllegalArgumentException("'minY' cannot be INF or NaN.");
        }
        if (Double.isInfinite(d5) || Double.isNaN(d5)) {
            throw new IllegalArgumentException("'maxY' cannot be INF or NaN.");
        }
        this.xSamples = n2;
        this.ySamples = n3;
        this.minX = d2;
        this.maxX = d3;
        this.minY = d4;
        this.maxY = d5;
        this.zValues = new double[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.zValues[i2] = new double[n3];
        }
    }

    @Override
    public int getXSampleCount() {
        return this.xSamples;
    }

    @Override
    public int getYSampleCount() {
        return this.ySamples;
    }

    @Override
    public double getMinimumXValue() {
        return this.minX;
    }

    @Override
    public double getMaximumXValue() {
        return this.maxX;
    }

    @Override
    public double getMinimumYValue() {
        return this.minY;
    }

    @Override
    public double getMaximumYValue() {
        return this.maxY;
    }

    @Override
    public double getXValue(int n2) {
        double d2 = this.minX + (this.maxX - this.minX) * ((double)n2 / (double)this.xSamples);
        return d2;
    }

    @Override
    public double getYValue(int n2) {
        double d2 = this.minY + (this.maxY - this.minY) * ((double)n2 / (double)this.ySamples);
        return d2;
    }

    @Override
    public double getZValue(int n2, int n3) {
        return this.zValues[n2][n3];
    }

    @Override
    public Number getZ(int n2, int n3) {
        return new Double(this.getZValue(n2, n3));
    }

    public void setZValue(int n2, int n3, double d2) {
        this.setZValue(n2, n3, d2, true);
    }

    public void setZValue(int n2, int n3, double d2, boolean bl2) {
        this.zValues[n2][n3] = d2;
        if (bl2) {
            this.fireDatasetChanged();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultHeatMapDataset)) {
            return false;
        }
        DefaultHeatMapDataset defaultHeatMapDataset = (DefaultHeatMapDataset)object;
        if (this.xSamples != defaultHeatMapDataset.xSamples) {
            return false;
        }
        if (this.ySamples != defaultHeatMapDataset.ySamples) {
            return false;
        }
        if (this.minX != defaultHeatMapDataset.minX) {
            return false;
        }
        if (this.maxX != defaultHeatMapDataset.maxX) {
            return false;
        }
        if (this.minY != defaultHeatMapDataset.minY) {
            return false;
        }
        if (this.maxY != defaultHeatMapDataset.maxY) {
            return false;
        }
        return DataUtilities.equal(this.zValues, defaultHeatMapDataset.zValues);
    }

    @Override
    public Object clone() {
        DefaultHeatMapDataset defaultHeatMapDataset = (DefaultHeatMapDataset)super.clone();
        defaultHeatMapDataset.zValues = DataUtilities.clone(this.zValues);
        return defaultHeatMapDataset;
    }
}

