/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DomainInfo;
import org.jfree.data.DomainOrder;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.KeyedValues;
import org.jfree.data.Range;
import org.jfree.data.RangeInfo;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryRangeInfo;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.function.Function2D;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.statistics.BoxAndWhiskerCategoryDataset;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import org.jfree.data.statistics.MultiValueCategoryDataset;
import org.jfree.data.statistics.StatisticalCategoryDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYDomainInfo;
import org.jfree.data.xy.XYRangeInfo;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.data.xy.XYZDataset;
import org.jfree.util.ArrayUtilities;

public final class DatasetUtilities {
    private DatasetUtilities() {
    }

    public static double calculatePieDatasetTotal(PieDataset pieDataset) {
        ParamChecks.nullNotPermitted(pieDataset, "dataset");
        List list = pieDataset.getKeys();
        double d2 = 0.0;
        for (Comparable comparable : list) {
            if (comparable == null) continue;
            Number number = pieDataset.getValue(comparable);
            double d3 = 0.0;
            if (number != null) {
                d3 = number.doubleValue();
            }
            if (!(d3 > 0.0)) continue;
            d2 += d3;
        }
        return d2;
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset categoryDataset, Comparable comparable) {
        int n2 = categoryDataset.getRowIndex(comparable);
        return DatasetUtilities.createPieDatasetForRow(categoryDataset, n2);
    }

    public static PieDataset createPieDatasetForRow(CategoryDataset categoryDataset, int n2) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n3 = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            Comparable comparable = categoryDataset.getColumnKey(i2);
            defaultPieDataset.setValue(comparable, categoryDataset.getValue(n2, i2));
        }
        return defaultPieDataset;
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset categoryDataset, Comparable comparable) {
        int n2 = categoryDataset.getColumnIndex(comparable);
        return DatasetUtilities.createPieDatasetForColumn(categoryDataset, n2);
    }

    public static PieDataset createPieDatasetForColumn(CategoryDataset categoryDataset, int n2) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        int n3 = categoryDataset.getRowCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            Comparable comparable = categoryDataset.getRowKey(i2);
            defaultPieDataset.setValue(comparable, categoryDataset.getValue(i2, n2));
        }
        return defaultPieDataset;
    }

    public static PieDataset createConsolidatedPieDataset(PieDataset pieDataset, Comparable comparable, double d2) {
        return DatasetUtilities.createConsolidatedPieDataset(pieDataset, comparable, d2, 2);
    }

    public static PieDataset createConsolidatedPieDataset(PieDataset pieDataset, Comparable comparable, double d2, int n2) {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        double d3 = DatasetUtilities.calculatePieDatasetTotal(pieDataset);
        List list = pieDataset.getKeys();
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        for (Comparable comparable2 : list) {
            double d4;
            Number number = pieDataset.getValue(comparable2);
            if (number == null || !((d4 = number.doubleValue()) / d3 < d2)) continue;
            arrayList.add(comparable2);
        }
        Iterator iterator = list.iterator();
        double d5 = 0.0;
        while (iterator.hasNext()) {
            Comparable comparable3 = (Comparable)iterator.next();
            Number number = pieDataset.getValue(comparable3);
            if (number == null) continue;
            if (arrayList.contains(comparable3) && arrayList.size() >= n2) {
                d5 += number.doubleValue();
                continue;
            }
            defaultPieDataset.setValue(comparable3, number);
        }
        if (arrayList.size() >= n2) {
            defaultPieDataset.setValue(comparable, d5);
        }
        return defaultPieDataset;
    }

    public static CategoryDataset createCategoryDataset(String string, String string2, double[][] dArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            String string3 = string + (i2 + 1);
            for (int i3 = 0; i3 < dArray[i2].length; ++i3) {
                String string4 = string2 + (i3 + 1);
                defaultCategoryDataset.addValue(new Double(dArray[i2][i3]), (Comparable)((Object)string3), (Comparable)((Object)string4));
            }
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(String string, String string2, Number[][] numberArray) {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i2 = 0; i2 < numberArray.length; ++i2) {
            String string3 = string + (i2 + 1);
            for (int i3 = 0; i3 < numberArray[i2].length; ++i3) {
                String string4 = string2 + (i3 + 1);
                defaultCategoryDataset.addValue(numberArray[i2][i3], (Comparable)((Object)string3), (Comparable)((Object)string4));
            }
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(Comparable[] comparableArray, Comparable[] comparableArray2, double[][] dArray) {
        ParamChecks.nullNotPermitted(comparableArray, "rowKeys");
        ParamChecks.nullNotPermitted(comparableArray2, "columnKeys");
        if (ArrayUtilities.hasDuplicateItems(comparableArray)) {
            throw new IllegalArgumentException("Duplicate items in 'rowKeys'.");
        }
        if (ArrayUtilities.hasDuplicateItems(comparableArray2)) {
            throw new IllegalArgumentException("Duplicate items in 'columnKeys'.");
        }
        if (comparableArray.length != dArray.length) {
            throw new IllegalArgumentException("The number of row keys does not match the number of rows in the data array.");
        }
        int n2 = 0;
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            n2 = Math.max(n2, dArray[i2].length);
        }
        if (comparableArray2.length != n2) {
            throw new IllegalArgumentException("The number of column keys does not match the number of columns in the data array.");
        }
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i3 = 0; i3 < dArray.length; ++i3) {
            Comparable comparable = comparableArray[i3];
            for (int i4 = 0; i4 < dArray[i3].length; ++i4) {
                Comparable comparable2 = comparableArray2[i4];
                defaultCategoryDataset.addValue(new Double(dArray[i3][i4]), comparable, comparable2);
            }
        }
        return defaultCategoryDataset;
    }

    public static CategoryDataset createCategoryDataset(Comparable comparable, KeyedValues keyedValues) {
        ParamChecks.nullNotPermitted(comparable, "rowKey");
        ParamChecks.nullNotPermitted(keyedValues, "rowData");
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        for (int i2 = 0; i2 < keyedValues.getItemCount(); ++i2) {
            defaultCategoryDataset.addValue(keyedValues.getValue(i2), comparable, keyedValues.getKey(i2));
        }
        return defaultCategoryDataset;
    }

    public static XYDataset sampleFunction2D(Function2D function2D, double d2, double d3, int n2, Comparable comparable) {
        XYSeries xYSeries = DatasetUtilities.sampleFunction2DToSeries(function2D, d2, d3, n2, comparable);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }

    public static XYSeries sampleFunction2DToSeries(Function2D function2D, double d2, double d3, int n2, Comparable comparable) {
        ParamChecks.nullNotPermitted(function2D, "f");
        ParamChecks.nullNotPermitted(comparable, "seriesKey");
        if (d2 >= d3) {
            throw new IllegalArgumentException("Requires 'start' < 'end'.");
        }
        if (n2 < 2) {
            throw new IllegalArgumentException("Requires 'samples' > 1");
        }
        XYSeries xYSeries = new XYSeries(comparable);
        double d4 = (d3 - d2) / (double)(n2 - 1);
        for (int i2 = 0; i2 < n2; ++i2) {
            double d5 = d2 + d4 * (double)i2;
            xYSeries.add(d5, function2D.getValue(d5));
        }
        return xYSeries;
    }

    public static boolean isEmptyOrNull(PieDataset pieDataset) {
        if (pieDataset == null) {
            return true;
        }
        int n2 = pieDataset.getItemCount();
        if (n2 == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            double d2;
            Number number = pieDataset.getValue(i2);
            if (number == null || !((d2 = number.doubleValue()) > 0.0)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyOrNull(CategoryDataset categoryDataset) {
        if (categoryDataset == null) {
            return true;
        }
        int n2 = categoryDataset.getRowCount();
        int n3 = categoryDataset.getColumnCount();
        if (n2 == 0 || n3 == 0) {
            return true;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                if (categoryDataset.getValue(i2, i3) == null) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isEmptyOrNull(XYDataset xYDataset) {
        if (xYDataset != null) {
            for (int i2 = 0; i2 < xYDataset.getSeriesCount(); ++i2) {
                if (xYDataset.getItemCount(i2) <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public static Range findDomainBounds(XYDataset xYDataset) {
        return DatasetUtilities.findDomainBounds(xYDataset, true);
    }

    public static Range findDomainBounds(XYDataset xYDataset, boolean bl2) {
        Range range;
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            range = domainInfo.getDomainBounds(bl2);
        } else {
            range = DatasetUtilities.iterateDomainBounds(xYDataset, bl2);
        }
        return range;
    }

    public static Range findDomainBounds(XYDataset xYDataset, List list, boolean bl2) {
        Range range;
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof XYDomainInfo) {
            XYDomainInfo xYDomainInfo = (XYDomainInfo)((Object)xYDataset);
            range = xYDomainInfo.getDomainBounds(list, bl2);
        } else {
            range = DatasetUtilities.iterateToFindDomainBounds(xYDataset, list, bl2);
        }
        return range;
    }

    public static Range iterateDomainBounds(XYDataset xYDataset) {
        return DatasetUtilities.iterateDomainBounds(xYDataset, true);
    }

    public static Range iterateDomainBounds(XYDataset xYDataset, boolean bl2) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n2 = xYDataset.getSeriesCount();
        if (bl2 && xYDataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = xYDataset.getItemCount(i2);
                for (int i3 = 0; i3 < n3; ++i3) {
                    double d4 = intervalXYDataset.getXValue(i2, i3);
                    double d5 = intervalXYDataset.getStartXValue(i2, i3);
                    double d6 = intervalXYDataset.getEndXValue(i2, i3);
                    if (!Double.isNaN(d4)) {
                        d2 = Math.min(d2, d4);
                        d3 = Math.max(d3, d4);
                    }
                    if (!Double.isNaN(d5)) {
                        d2 = Math.min(d2, d5);
                        d3 = Math.max(d3, d5);
                    }
                    if (Double.isNaN(d6)) continue;
                    d2 = Math.min(d2, d6);
                    d3 = Math.max(d3, d6);
                }
            }
        } else {
            for (int i4 = 0; i4 < n2; ++i4) {
                int n4 = xYDataset.getItemCount(i4);
                for (int i5 = 0; i5 < n4; ++i5) {
                    double d7;
                    double d8 = d7 = xYDataset.getXValue(i4, i5);
                    if (Double.isNaN(d7)) continue;
                    d2 = Math.min(d2, d7);
                    d3 = Math.max(d3, d8);
                }
            }
        }
        if (d2 > d3) {
            return null;
        }
        return new Range(d2, d3);
    }

    public static Range findRangeBounds(CategoryDataset categoryDataset) {
        return DatasetUtilities.findRangeBounds(categoryDataset, true);
    }

    public static Range findRangeBounds(CategoryDataset categoryDataset, boolean bl2) {
        Range range;
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            range = rangeInfo.getRangeBounds(bl2);
        } else {
            range = DatasetUtilities.iterateRangeBounds(categoryDataset, bl2);
        }
        return range;
    }

    public static Range findRangeBounds(CategoryDataset categoryDataset, List list, boolean bl2) {
        Range range;
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        if (categoryDataset instanceof CategoryRangeInfo) {
            CategoryRangeInfo categoryRangeInfo = (CategoryRangeInfo)((Object)categoryDataset);
            range = categoryRangeInfo.getRangeBounds(list, bl2);
        } else {
            range = DatasetUtilities.iterateToFindRangeBounds(categoryDataset, list, bl2);
        }
        return range;
    }

    public static Range findRangeBounds(XYDataset xYDataset) {
        return DatasetUtilities.findRangeBounds(xYDataset, true);
    }

    public static Range findRangeBounds(XYDataset xYDataset, boolean bl2) {
        Range range;
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            range = rangeInfo.getRangeBounds(bl2);
        } else {
            range = DatasetUtilities.iterateRangeBounds(xYDataset, bl2);
        }
        return range;
    }

    public static Range findRangeBounds(XYDataset xYDataset, List list, Range range, boolean bl2) {
        Range range2;
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof XYRangeInfo) {
            XYRangeInfo xYRangeInfo = (XYRangeInfo)((Object)xYDataset);
            range2 = xYRangeInfo.getRangeBounds(list, range, bl2);
        } else {
            range2 = DatasetUtilities.iterateToFindRangeBounds(xYDataset, list, range, bl2);
        }
        return range2;
    }

    public static Range iterateCategoryRangeBounds(CategoryDataset categoryDataset, boolean bl2) {
        return DatasetUtilities.iterateRangeBounds(categoryDataset, bl2);
    }

    public static Range iterateRangeBounds(CategoryDataset categoryDataset) {
        return DatasetUtilities.iterateRangeBounds(categoryDataset, true);
    }

    public static Range iterateRangeBounds(CategoryDataset categoryDataset, boolean bl2) {
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n2 = categoryDataset.getRowCount();
        int n3 = categoryDataset.getColumnCount();
        if (bl2 && categoryDataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i3 = 0; i3 < n3; ++i3) {
                    Number number;
                    Number number2;
                    double d4;
                    Number number3 = intervalCategoryDataset.getValue(i2, i3);
                    if (number3 != null && !Double.isNaN(d4 = number3.doubleValue())) {
                        d2 = Math.min(d4, d2);
                        d3 = Math.max(d4, d3);
                    }
                    if ((number2 = intervalCategoryDataset.getStartValue(i2, i3)) != null && !Double.isNaN(d4 = number2.doubleValue())) {
                        d2 = Math.min(d4, d2);
                        d3 = Math.max(d4, d3);
                    }
                    if ((number = intervalCategoryDataset.getEndValue(i2, i3)) == null || Double.isNaN(d4 = number.doubleValue())) continue;
                    d2 = Math.min(d4, d2);
                    d3 = Math.max(d4, d3);
                }
            }
        } else {
            for (int i4 = 0; i4 < n2; ++i4) {
                for (int i5 = 0; i5 < n3; ++i5) {
                    double d5;
                    Number number = categoryDataset.getValue(i4, i5);
                    if (number == null || Double.isNaN(d5 = number.doubleValue())) continue;
                    d2 = Math.min(d2, d5);
                    d3 = Math.max(d3, d5);
                }
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d2, d3);
    }

    public static Range iterateToFindRangeBounds(CategoryDataset categoryDataset, List list, boolean bl2) {
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        ParamChecks.nullNotPermitted(list, "visibleSeriesKeys");
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n2 = categoryDataset.getColumnCount();
        if (bl2 && categoryDataset instanceof BoxAndWhiskerCategoryDataset) {
            BoxAndWhiskerCategoryDataset boxAndWhiskerCategoryDataset = (BoxAndWhiskerCategoryDataset)categoryDataset;
            for (Comparable comparable : list) {
                int n3 = categoryDataset.getRowIndex(comparable);
                int n4 = categoryDataset.getColumnCount();
                for (int i2 = 0; i2 < n4; ++i2) {
                    Number number;
                    Number number2 = boxAndWhiskerCategoryDataset.getMinRegularValue(n3, i2);
                    if (number2 == null) {
                        number2 = boxAndWhiskerCategoryDataset.getValue(n3, i2);
                    }
                    if ((number = boxAndWhiskerCategoryDataset.getMaxRegularValue(n3, i2)) == null) {
                        number = boxAndWhiskerCategoryDataset.getValue(n3, i2);
                    }
                    if (number2 != null) {
                        d2 = Math.min(d2, number2.doubleValue());
                    }
                    if (number == null) continue;
                    d3 = Math.max(d3, number.doubleValue());
                }
            }
        } else if (bl2 && categoryDataset instanceof IntervalCategoryDataset) {
            IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
            for (Comparable comparable : list) {
                int n5 = categoryDataset.getRowIndex(comparable);
                for (int i3 = 0; i3 < n2; ++i3) {
                    Number number = intervalCategoryDataset.getStartValue(n5, i3);
                    Number number3 = intervalCategoryDataset.getEndValue(n5, i3);
                    if (number != null && !Double.isNaN(number.doubleValue())) {
                        d2 = Math.min(d2, number.doubleValue());
                    }
                    if (number3 == null || Double.isNaN(number3.doubleValue())) continue;
                    d3 = Math.max(d3, number3.doubleValue());
                }
            }
        } else if (bl2 && categoryDataset instanceof MultiValueCategoryDataset) {
            MultiValueCategoryDataset multiValueCategoryDataset = (MultiValueCategoryDataset)categoryDataset;
            for (Comparable comparable : list) {
                int n6 = categoryDataset.getRowIndex(comparable);
                for (int i4 = 0; i4 < n2; ++i4) {
                    List list2 = multiValueCategoryDataset.getValues(n6, i4);
                    for (Object e2 : list2) {
                        double d4;
                        if (!(e2 instanceof Number) || Double.isNaN(d4 = ((Number)e2).doubleValue())) continue;
                        d2 = Math.min(d2, d4);
                        d3 = Math.max(d3, d4);
                    }
                }
            }
        } else if (bl2 && categoryDataset instanceof StatisticalCategoryDataset) {
            StatisticalCategoryDataset statisticalCategoryDataset = (StatisticalCategoryDataset)categoryDataset;
            for (Comparable comparable : list) {
                int n7 = categoryDataset.getRowIndex(comparable);
                for (int i5 = 0; i5 < n2; ++i5) {
                    double d5;
                    Number number = statisticalCategoryDataset.getMeanValue(n7, i5);
                    if (number == null) continue;
                    double d6 = 0.0;
                    Number number4 = statisticalCategoryDataset.getStdDevValue(n7, i5);
                    if (number4 != null && Double.isNaN(d6 = number4.doubleValue())) {
                        d6 = 0.0;
                    }
                    if (Double.isNaN(d5 = number.doubleValue())) continue;
                    d2 = Math.min(d2, d5 - d6);
                    d3 = Math.max(d3, d5 + d6);
                }
            }
        } else {
            for (Comparable comparable : list) {
                int n8 = categoryDataset.getRowIndex(comparable);
                for (int i6 = 0; i6 < n2; ++i6) {
                    double d7;
                    Number number = categoryDataset.getValue(n8, i6);
                    if (number == null || Double.isNaN(d7 = number.doubleValue())) continue;
                    d2 = Math.min(d2, d7);
                    d3 = Math.max(d3, d7);
                }
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d2, d3);
    }

    public static Range iterateXYRangeBounds(XYDataset xYDataset) {
        return DatasetUtilities.iterateRangeBounds(xYDataset);
    }

    public static Range iterateRangeBounds(XYDataset xYDataset) {
        return DatasetUtilities.iterateRangeBounds(xYDataset, true);
    }

    public static Range iterateRangeBounds(XYDataset xYDataset, boolean bl2) {
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n2 = xYDataset.getSeriesCount();
        if (bl2 && xYDataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = xYDataset.getItemCount(i2);
                for (int i3 = 0; i3 < n3; ++i3) {
                    double d4 = intervalXYDataset.getYValue(i2, i3);
                    double d5 = intervalXYDataset.getStartYValue(i2, i3);
                    double d6 = intervalXYDataset.getEndYValue(i2, i3);
                    if (!Double.isNaN(d4)) {
                        d2 = Math.min(d2, d4);
                        d3 = Math.max(d3, d4);
                    }
                    if (!Double.isNaN(d5)) {
                        d2 = Math.min(d2, d5);
                        d3 = Math.max(d3, d5);
                    }
                    if (Double.isNaN(d6)) continue;
                    d2 = Math.min(d2, d6);
                    d3 = Math.max(d3, d6);
                }
            }
        } else if (bl2 && xYDataset instanceof OHLCDataset) {
            OHLCDataset oHLCDataset = (OHLCDataset)xYDataset;
            for (int i4 = 0; i4 < n2; ++i4) {
                int n4 = xYDataset.getItemCount(i4);
                for (int i5 = 0; i5 < n4; ++i5) {
                    double d7 = oHLCDataset.getLowValue(i4, i5);
                    double d8 = oHLCDataset.getHighValue(i4, i5);
                    if (!Double.isNaN(d7)) {
                        d2 = Math.min(d2, d7);
                    }
                    if (Double.isNaN(d8)) continue;
                    d3 = Math.max(d3, d8);
                }
            }
        } else {
            for (int i6 = 0; i6 < n2; ++i6) {
                int n5 = xYDataset.getItemCount(i6);
                for (int i7 = 0; i7 < n5; ++i7) {
                    double d9 = xYDataset.getYValue(i6, i7);
                    if (Double.isNaN(d9)) continue;
                    d2 = Math.min(d2, d9);
                    d3 = Math.max(d3, d9);
                }
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d2, d3);
    }

    public static Range findZBounds(XYZDataset xYZDataset) {
        return DatasetUtilities.findZBounds(xYZDataset, true);
    }

    public static Range findZBounds(XYZDataset xYZDataset, boolean bl2) {
        ParamChecks.nullNotPermitted(xYZDataset, "dataset");
        Range range = DatasetUtilities.iterateZBounds(xYZDataset, bl2);
        return range;
    }

    public static Range findZBounds(XYZDataset xYZDataset, List list, Range range, boolean bl2) {
        ParamChecks.nullNotPermitted(xYZDataset, "dataset");
        Range range2 = DatasetUtilities.iterateToFindZBounds(xYZDataset, list, range, bl2);
        return range2;
    }

    public static Range iterateZBounds(XYZDataset xYZDataset) {
        return DatasetUtilities.iterateZBounds(xYZDataset, true);
    }

    public static Range iterateZBounds(XYZDataset xYZDataset, boolean bl2) {
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        int n2 = xYZDataset.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = xYZDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n3; ++i3) {
                double d4 = xYZDataset.getZValue(i2, i3);
                if (Double.isNaN(d4)) continue;
                d2 = Math.min(d2, d4);
                d3 = Math.max(d3, d4);
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d2, d3);
    }

    public static Range iterateToFindDomainBounds(XYDataset xYDataset, List list, boolean bl2) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        ParamChecks.nullNotPermitted(list, "visibleSeriesKeys");
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        if (bl2 && xYDataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            for (Comparable comparable : list) {
                int n2 = xYDataset.indexOf(comparable);
                int n3 = xYDataset.getItemCount(n2);
                for (int i2 = 0; i2 < n3; ++i2) {
                    double d4 = intervalXYDataset.getStartXValue(n2, i2);
                    double d5 = intervalXYDataset.getEndXValue(n2, i2);
                    if (!Double.isNaN(d4)) {
                        d2 = Math.min(d2, d4);
                    }
                    if (Double.isNaN(d5)) continue;
                    d3 = Math.max(d3, d5);
                }
            }
        } else {
            for (Comparable comparable : list) {
                int n4 = xYDataset.indexOf(comparable);
                int n5 = xYDataset.getItemCount(n4);
                for (int i3 = 0; i3 < n5; ++i3) {
                    double d6 = xYDataset.getXValue(n4, i3);
                    if (Double.isNaN(d6)) continue;
                    d2 = Math.min(d2, d6);
                    d3 = Math.max(d3, d6);
                }
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d2, d3);
    }

    public static Range iterateToFindRangeBounds(XYDataset xYDataset, List list, Range range, boolean bl2) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        ParamChecks.nullNotPermitted(list, "visibleSeriesKeys");
        ParamChecks.nullNotPermitted(range, "xRange");
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        if (bl2 && xYDataset instanceof OHLCDataset) {
            OHLCDataset oHLCDataset = (OHLCDataset)xYDataset;
            for (Comparable comparable : list) {
                int n2 = xYDataset.indexOf(comparable);
                int n3 = xYDataset.getItemCount(n2);
                for (int i2 = 0; i2 < n3; ++i2) {
                    double d4 = oHLCDataset.getXValue(n2, i2);
                    if (!range.contains(d4)) continue;
                    double d5 = oHLCDataset.getLowValue(n2, i2);
                    double d6 = oHLCDataset.getHighValue(n2, i2);
                    if (!Double.isNaN(d5)) {
                        d2 = Math.min(d2, d5);
                    }
                    if (Double.isNaN(d6)) continue;
                    d3 = Math.max(d3, d6);
                }
            }
        } else if (bl2 && xYDataset instanceof BoxAndWhiskerXYDataset) {
            BoxAndWhiskerXYDataset boxAndWhiskerXYDataset = (BoxAndWhiskerXYDataset)xYDataset;
            for (Comparable comparable : list) {
                int n4 = xYDataset.indexOf(comparable);
                int n5 = xYDataset.getItemCount(n4);
                for (int i3 = 0; i3 < n5; ++i3) {
                    double d7 = boxAndWhiskerXYDataset.getXValue(n4, i3);
                    if (!range.contains(d7)) continue;
                    Number number = boxAndWhiskerXYDataset.getMinRegularValue(n4, i3);
                    Number number2 = boxAndWhiskerXYDataset.getMaxRegularValue(n4, i3);
                    if (number != null) {
                        d2 = Math.min(d2, number.doubleValue());
                    }
                    if (number2 == null) continue;
                    d3 = Math.max(d3, number2.doubleValue());
                }
            }
        } else if (bl2 && xYDataset instanceof IntervalXYDataset) {
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            for (Comparable comparable : list) {
                int n6 = xYDataset.indexOf(comparable);
                int n7 = xYDataset.getItemCount(n6);
                for (int i4 = 0; i4 < n7; ++i4) {
                    double d8 = intervalXYDataset.getXValue(n6, i4);
                    if (!range.contains(d8)) continue;
                    double d9 = intervalXYDataset.getStartYValue(n6, i4);
                    double d10 = intervalXYDataset.getEndYValue(n6, i4);
                    if (!Double.isNaN(d9)) {
                        d2 = Math.min(d2, d9);
                    }
                    if (Double.isNaN(d10)) continue;
                    d3 = Math.max(d3, d10);
                }
            }
        } else {
            for (Comparable comparable : list) {
                int n8 = xYDataset.indexOf(comparable);
                int n9 = xYDataset.getItemCount(n8);
                for (int i5 = 0; i5 < n9; ++i5) {
                    double d11 = xYDataset.getXValue(n8, i5);
                    double d12 = xYDataset.getYValue(n8, i5);
                    if (!range.contains(d11) || Double.isNaN(d12)) continue;
                    d2 = Math.min(d2, d12);
                    d3 = Math.max(d3, d12);
                }
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d2, d3);
    }

    public static Range iterateToFindZBounds(XYZDataset xYZDataset, List list, Range range, boolean bl2) {
        ParamChecks.nullNotPermitted(xYZDataset, "dataset");
        ParamChecks.nullNotPermitted(list, "visibleSeriesKeys");
        ParamChecks.nullNotPermitted(range, "xRange");
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        for (Comparable comparable : list) {
            int n2 = xYZDataset.indexOf(comparable);
            int n3 = xYZDataset.getItemCount(n2);
            for (int i2 = 0; i2 < n3; ++i2) {
                double d4 = xYZDataset.getXValue(n2, i2);
                double d5 = xYZDataset.getZValue(n2, i2);
                if (!range.contains(d4) || Double.isNaN(d5)) continue;
                d2 = Math.min(d2, d5);
                d3 = Math.max(d3, d5);
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(d2, d3);
    }

    public static Number findMinimumDomainValue(XYDataset xYDataset) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            return new Double(domainInfo.getDomainLowerBound(true));
        }
        double d2 = Double.POSITIVE_INFINITY;
        int n2 = xYDataset.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = xYDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n3; ++i3) {
                double d3;
                if (xYDataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d3 = intervalXYDataset.getStartXValue(i2, i3);
                } else {
                    d3 = xYDataset.getXValue(i2, i3);
                }
                if (Double.isNaN(d3)) continue;
                d2 = Math.min(d2, d3);
            }
        }
        Double d4 = d2 == Double.POSITIVE_INFINITY ? null : new Double(d2);
        return d4;
    }

    public static Number findMaximumDomainValue(XYDataset xYDataset) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)((Object)xYDataset);
            return new Double(domainInfo.getDomainUpperBound(true));
        }
        double d2 = Double.NEGATIVE_INFINITY;
        int n2 = xYDataset.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = xYDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n3; ++i3) {
                double d3;
                if (xYDataset instanceof IntervalXYDataset) {
                    IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
                    d3 = intervalXYDataset.getEndXValue(i2, i3);
                } else {
                    d3 = xYDataset.getXValue(i2, i3);
                }
                if (Double.isNaN(d3)) continue;
                d2 = Math.max(d2, d3);
            }
        }
        Double d4 = d2 == Double.NEGATIVE_INFINITY ? null : new Double(d2);
        return d4;
    }

    public static Number findMinimumRangeValue(CategoryDataset categoryDataset) {
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            return new Double(rangeInfo.getRangeLowerBound(true));
        }
        double d2 = Double.POSITIVE_INFINITY;
        int n2 = categoryDataset.getRowCount();
        int n3 = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                Number number;
                if (categoryDataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
                    number = intervalCategoryDataset.getStartValue(i2, i3);
                } else {
                    number = categoryDataset.getValue(i2, i3);
                }
                if (number == null) continue;
                d2 = Math.min(d2, number.doubleValue());
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Double(d2);
    }

    public static Number findMinimumRangeValue(XYDataset xYDataset) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            return new Double(rangeInfo.getRangeLowerBound(true));
        }
        double d2 = Double.POSITIVE_INFINITY;
        int n2 = xYDataset.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = xYDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n3; ++i3) {
                double d3;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d3 = xYDataset2.getStartYValue(i2, i3);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d3 = xYDataset2.getLowValue(i2, i3);
                } else {
                    d3 = xYDataset.getYValue(i2, i3);
                }
                if (Double.isNaN(d3)) continue;
                d2 = Math.min(d2, d3);
            }
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Double(d2);
    }

    public static Number findMaximumRangeValue(CategoryDataset categoryDataset) {
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        if (categoryDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)categoryDataset);
            return new Double(rangeInfo.getRangeUpperBound(true));
        }
        double d2 = Double.NEGATIVE_INFINITY;
        int n2 = categoryDataset.getRowCount();
        int n3 = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                Number number;
                if (categoryDataset instanceof IntervalCategoryDataset) {
                    IntervalCategoryDataset intervalCategoryDataset = (IntervalCategoryDataset)categoryDataset;
                    number = intervalCategoryDataset.getEndValue(i2, i3);
                } else {
                    number = categoryDataset.getValue(i2, i3);
                }
                if (number == null) continue;
                d2 = Math.max(d2, number.doubleValue());
            }
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return new Double(d2);
    }

    public static Number findMaximumRangeValue(XYDataset xYDataset) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        if (xYDataset instanceof RangeInfo) {
            RangeInfo rangeInfo = (RangeInfo)((Object)xYDataset);
            return new Double(rangeInfo.getRangeUpperBound(true));
        }
        double d2 = Double.NEGATIVE_INFINITY;
        int n2 = xYDataset.getSeriesCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = xYDataset.getItemCount(i2);
            for (int i3 = 0; i3 < n3; ++i3) {
                double d3;
                XYDataset xYDataset2;
                if (xYDataset instanceof IntervalXYDataset) {
                    xYDataset2 = (IntervalXYDataset)xYDataset;
                    d3 = xYDataset2.getEndYValue(i2, i3);
                } else if (xYDataset instanceof OHLCDataset) {
                    xYDataset2 = (OHLCDataset)xYDataset;
                    d3 = xYDataset2.getHighValue(i2, i3);
                } else {
                    d3 = xYDataset.getYValue(i2, i3);
                }
                if (Double.isNaN(d3)) continue;
                d2 = Math.max(d2, d3);
            }
        }
        if (d2 == Double.NEGATIVE_INFINITY) {
            return null;
        }
        return new Double(d2);
    }

    public static Range findStackedRangeBounds(CategoryDataset categoryDataset) {
        return DatasetUtilities.findStackedRangeBounds(categoryDataset, 0.0);
    }

    public static Range findStackedRangeBounds(CategoryDataset categoryDataset, double d2) {
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        Range range = null;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        int n2 = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d5 = d2;
            double d6 = d2;
            int n3 = categoryDataset.getRowCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                Number number = categoryDataset.getValue(i3, i2);
                if (number == null) continue;
                double d7 = number.doubleValue();
                if (d7 > 0.0) {
                    d5 += d7;
                }
                if (!(d7 < 0.0)) continue;
                d6 += d7;
            }
            d3 = Math.min(d3, d6);
            d4 = Math.max(d4, d5);
        }
        if (d3 <= d4) {
            range = new Range(d3, d4);
        }
        return range;
    }

    public static Range findStackedRangeBounds(CategoryDataset categoryDataset, KeyToGroupMap keyToGroupMap) {
        int n2;
        int n3;
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        boolean bl2 = false;
        Range range = null;
        int[] nArray = new int[categoryDataset.getRowCount()];
        for (n3 = 0; n3 < categoryDataset.getRowCount(); ++n3) {
            nArray[n3] = keyToGroupMap.getGroupIndex(keyToGroupMap.getGroup(categoryDataset.getRowKey(n3)));
        }
        n3 = keyToGroupMap.getGroupCount();
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        int n4 = categoryDataset.getColumnCount();
        for (n2 = 0; n2 < n4; ++n2) {
            int n5;
            double[] dArray3 = new double[n3];
            double[] dArray4 = new double[n3];
            int n6 = categoryDataset.getRowCount();
            for (n5 = 0; n5 < n6; ++n5) {
                Number number = categoryDataset.getValue(n5, n2);
                if (number == null) continue;
                bl2 = true;
                double d2 = number.doubleValue();
                if (d2 > 0.0) {
                    dArray3[nArray[n5]] = dArray3[nArray[n5]] + d2;
                }
                if (!(d2 < 0.0)) continue;
                dArray4[nArray[n5]] = dArray4[nArray[n5]] + d2;
            }
            for (n5 = 0; n5 < n3; ++n5) {
                dArray[n5] = Math.min(dArray[n5], dArray4[n5]);
                dArray2[n5] = Math.max(dArray2[n5], dArray3[n5]);
            }
        }
        if (bl2) {
            for (n2 = 0; n2 < n3; ++n2) {
                range = Range.combine(range, new Range(dArray[n2], dArray2[n2]));
            }
        }
        return range;
    }

    public static Number findMinimumStackedRangeValue(CategoryDataset categoryDataset) {
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        Double d2 = null;
        boolean bl2 = false;
        double d3 = 0.0;
        int n2 = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = 0.0;
            int n3 = categoryDataset.getRowCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                Number number = categoryDataset.getValue(i3, i2);
                if (number == null) continue;
                bl2 = true;
                double d5 = number.doubleValue();
                if (!(d5 < 0.0)) continue;
                d4 += d5;
            }
            d3 = Math.min(d3, d4);
        }
        if (bl2) {
            d2 = new Double(d3);
        }
        return d2;
    }

    public static Number findMaximumStackedRangeValue(CategoryDataset categoryDataset) {
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        Double d2 = null;
        boolean bl2 = false;
        double d3 = 0.0;
        int n2 = categoryDataset.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            double d4 = 0.0;
            int n3 = categoryDataset.getRowCount();
            for (int i3 = 0; i3 < n3; ++i3) {
                Number number = categoryDataset.getValue(i3, i2);
                if (number == null) continue;
                bl2 = true;
                double d5 = number.doubleValue();
                if (!(d5 > 0.0)) continue;
                d4 += d5;
            }
            d3 = Math.max(d3, d4);
        }
        if (bl2) {
            d2 = new Double(d3);
        }
        return d2;
    }

    public static Range findStackedRangeBounds(TableXYDataset tableXYDataset) {
        return DatasetUtilities.findStackedRangeBounds(tableXYDataset, 0.0);
    }

    public static Range findStackedRangeBounds(TableXYDataset tableXYDataset, double d2) {
        ParamChecks.nullNotPermitted(tableXYDataset, "dataset");
        double d3 = d2;
        double d4 = d2;
        for (int i2 = 0; i2 < tableXYDataset.getItemCount(); ++i2) {
            double d5 = d2;
            double d6 = d2;
            int n2 = tableXYDataset.getSeriesCount();
            for (int i3 = 0; i3 < n2; ++i3) {
                double d7 = tableXYDataset.getYValue(i3, i2);
                if (Double.isNaN(d7)) continue;
                if (d7 > 0.0) {
                    d5 += d7;
                    continue;
                }
                d6 += d7;
            }
            if (d5 > d4) {
                d4 = d5;
            }
            if (!(d6 < d3)) continue;
            d3 = d6;
        }
        if (d3 <= d4) {
            return new Range(d3, d4);
        }
        return null;
    }

    public static double calculateStackTotal(TableXYDataset tableXYDataset, int n2) {
        double d2 = 0.0;
        int n3 = tableXYDataset.getSeriesCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            double d3 = tableXYDataset.getYValue(i2, n2);
            if (Double.isNaN(d3)) continue;
            d2 += d3;
        }
        return d2;
    }

    public static Range findCumulativeRangeBounds(CategoryDataset categoryDataset) {
        ParamChecks.nullNotPermitted(categoryDataset, "dataset");
        boolean bl2 = true;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i2 = 0; i2 < categoryDataset.getRowCount(); ++i2) {
            double d4 = 0.0;
            for (int i3 = 0; i3 <= categoryDataset.getColumnCount() - 1; ++i3) {
                Number number = categoryDataset.getValue(i2, i3);
                if (number == null) continue;
                bl2 = false;
                double d5 = number.doubleValue();
                if (Double.isNaN(d5)) continue;
                d2 = Math.min(d2, d4 += d5);
                d3 = Math.max(d3, d4);
            }
        }
        if (!bl2) {
            return new Range(d2, d3);
        }
        return null;
    }

    public static double findYValue(XYDataset xYDataset, int n2, double d2) {
        int[] nArray = DatasetUtilities.findItemIndicesForX(xYDataset, n2, d2);
        if (nArray[0] == -1) {
            return Double.NaN;
        }
        if (nArray[0] == nArray[1]) {
            return xYDataset.getYValue(n2, nArray[0]);
        }
        double d3 = xYDataset.getXValue(n2, nArray[0]);
        double d4 = xYDataset.getXValue(n2, nArray[1]);
        double d5 = xYDataset.getYValue(n2, nArray[0]);
        double d6 = xYDataset.getYValue(n2, nArray[1]);
        return d5 + (d6 - d5) * (d2 - d3) / (d4 - d3);
    }

    public static int[] findItemIndicesForX(XYDataset xYDataset, int n2, double d2) {
        ParamChecks.nullNotPermitted(xYDataset, "dataset");
        int n3 = xYDataset.getItemCount(n2);
        if (n3 == 0) {
            return new int[]{-1, -1};
        }
        if (n3 == 1) {
            if (d2 == xYDataset.getXValue(n2, 0)) {
                return new int[]{0, 0};
            }
            return new int[]{-1, -1};
        }
        if (xYDataset.getDomainOrder() == DomainOrder.ASCENDING) {
            int n4 = 0;
            int n5 = n3 - 1;
            double d3 = xYDataset.getXValue(n2, n4);
            if (d3 > d2) {
                return new int[]{-1, -1};
            }
            if (d3 == d2) {
                return new int[]{0, 0};
            }
            double d4 = xYDataset.getXValue(n2, n5);
            if (d4 < d2) {
                return new int[]{-1, -1};
            }
            if (d4 == d2) {
                return new int[]{n5, n5};
            }
            int n6 = (n4 + n5) / 2;
            while (n5 - n4 > 1) {
                double d5 = xYDataset.getXValue(n2, n6);
                if (d2 == d5) {
                    return new int[]{n6, n6};
                }
                if (d5 < d2) {
                    n4 = n6;
                } else {
                    n5 = n6;
                }
                n6 = (n4 + n5) / 2;
            }
            return new int[]{n4, n5};
        }
        if (xYDataset.getDomainOrder() == DomainOrder.DESCENDING) {
            int n7 = 0;
            int n8 = n3 - 1;
            double d6 = xYDataset.getXValue(n2, n8);
            if (d6 > d2) {
                return new int[]{-1, -1};
            }
            double d7 = xYDataset.getXValue(n2, n7);
            if (d7 < d2) {
                return new int[]{-1, -1};
            }
            int n9 = (n8 + n7) / 2;
            while (n7 - n8 > 1) {
                double d8 = xYDataset.getXValue(n2, n9);
                if (d2 == d8) {
                    return new int[]{n9, n9};
                }
                if (d8 < d2) {
                    n8 = n9;
                } else {
                    n7 = n9;
                }
                n9 = (n8 + n7) / 2;
            }
            return new int[]{n8, n7};
        }
        double d9 = xYDataset.getXValue(n2, 0);
        if (d2 == d9) {
            return new int[]{0, 0};
        }
        for (int i2 = 1; i2 < n3; ++i2) {
            double d10 = xYDataset.getXValue(n2, i2);
            if (d2 == d10) {
                return new int[]{i2, i2};
            }
            if (!(d2 > d9 && d2 < d10) && (!(d2 < d9) || !(d2 > d10))) continue;
            return new int[]{i2 - 1, i2};
        }
        return new int[]{-1, -1};
    }
}

