/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.util.ArrayList;
import java.util.List;
import org.jfree.data.general.CombinationDataset;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.SeriesDataset;
import org.jfree.data.general.SubSeriesDataset;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;

public class CombinedDataset
extends AbstractIntervalXYDataset
implements CombinationDataset,
IntervalXYDataset,
OHLCDataset,
XYDataset {
    private List datasetInfo = new ArrayList();

    public CombinedDataset() {
    }

    public CombinedDataset(SeriesDataset[] seriesDatasetArray) {
        this.add(seriesDatasetArray);
    }

    public void add(SeriesDataset seriesDataset) {
        this.fastAdd(seriesDataset);
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, this);
        this.notifyListeners(datasetChangeEvent);
    }

    public void add(SeriesDataset[] seriesDatasetArray) {
        for (int i2 = 0; i2 < seriesDatasetArray.length; ++i2) {
            this.fastAdd(seriesDatasetArray[i2]);
        }
        DatasetChangeEvent datasetChangeEvent = new DatasetChangeEvent(this, this);
        this.notifyListeners(datasetChangeEvent);
    }

    public void add(SeriesDataset seriesDataset, int n2) {
        this.add(new SubSeriesDataset(seriesDataset, n2));
    }

    private void fastAdd(SeriesDataset seriesDataset) {
        for (int i2 = 0; i2 < seriesDataset.getSeriesCount(); ++i2) {
            this.datasetInfo.add(new DatasetInfo(seriesDataset, i2));
        }
    }

    @Override
    public int getSeriesCount() {
        return this.datasetInfo.size();
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        return datasetInfo.data.getSeriesKey(datasetInfo.series);
    }

    @Override
    public Number getX(int n2, int n3) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        return ((XYDataset)datasetInfo.data).getX(datasetInfo.series, n3);
    }

    @Override
    public Number getY(int n2, int n3) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        return ((XYDataset)datasetInfo.data).getY(datasetInfo.series, n3);
    }

    @Override
    public int getItemCount(int n2) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        return ((XYDataset)datasetInfo.data).getItemCount(datasetInfo.series);
    }

    @Override
    public Number getHigh(int n2, int n3) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        return ((OHLCDataset)datasetInfo.data).getHigh(datasetInfo.series, n3);
    }

    @Override
    public double getHighValue(int n2, int n3) {
        double d2 = Double.NaN;
        Number number = this.getHigh(n2, n3);
        if (number != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    @Override
    public Number getLow(int n2, int n3) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        return ((OHLCDataset)datasetInfo.data).getLow(datasetInfo.series, n3);
    }

    @Override
    public double getLowValue(int n2, int n3) {
        double d2 = Double.NaN;
        Number number = this.getLow(n2, n3);
        if (number != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    @Override
    public Number getOpen(int n2, int n3) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        return ((OHLCDataset)datasetInfo.data).getOpen(datasetInfo.series, n3);
    }

    @Override
    public double getOpenValue(int n2, int n3) {
        double d2 = Double.NaN;
        Number number = this.getOpen(n2, n3);
        if (number != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    @Override
    public Number getClose(int n2, int n3) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        return ((OHLCDataset)datasetInfo.data).getClose(datasetInfo.series, n3);
    }

    @Override
    public double getCloseValue(int n2, int n3) {
        double d2 = Double.NaN;
        Number number = this.getClose(n2, n3);
        if (number != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    @Override
    public Number getVolume(int n2, int n3) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        return ((OHLCDataset)datasetInfo.data).getVolume(datasetInfo.series, n3);
    }

    @Override
    public double getVolumeValue(int n2, int n3) {
        double d2 = Double.NaN;
        Number number = this.getVolume(n2, n3);
        if (number != null) {
            d2 = number.doubleValue();
        }
        return d2;
    }

    @Override
    public Number getStartX(int n2, int n3) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getStartX(datasetInfo.series, n3);
        }
        return this.getX(n2, n3);
    }

    @Override
    public Number getEndX(int n2, int n3) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getEndX(datasetInfo.series, n3);
        }
        return this.getX(n2, n3);
    }

    @Override
    public Number getStartY(int n2, int n3) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getStartY(datasetInfo.series, n3);
        }
        return this.getY(n2, n3);
    }

    @Override
    public Number getEndY(int n2, int n3) {
        DatasetInfo datasetInfo = this.getDatasetInfo(n2);
        if (datasetInfo.data instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)datasetInfo.data).getEndY(datasetInfo.series, n3);
        }
        return this.getY(n2, n3);
    }

    @Override
    public SeriesDataset getParent() {
        SeriesDataset seriesDataset = null;
        for (int i2 = 0; i2 < this.datasetInfo.size(); ++i2) {
            SeriesDataset seriesDataset2 = this.getDatasetInfo(i2).data;
            if (seriesDataset2 instanceof CombinationDataset) {
                SeriesDataset seriesDataset3 = ((CombinationDataset)((Object)seriesDataset2)).getParent();
                if (seriesDataset == null) {
                    seriesDataset = seriesDataset3;
                    continue;
                }
                if (seriesDataset == seriesDataset3) continue;
                return null;
            }
            return null;
        }
        return seriesDataset;
    }

    @Override
    public int[] getMap() {
        int[] nArray = null;
        for (int i2 = 0; i2 < this.datasetInfo.size(); ++i2) {
            int[] nArray2;
            SeriesDataset seriesDataset = this.getDatasetInfo(i2).data;
            if (seriesDataset instanceof CombinationDataset) {
                nArray2 = ((CombinationDataset)((Object)seriesDataset)).getMap();
                if (nArray2 == null) {
                    return null;
                }
            } else {
                return null;
            }
            nArray = this.joinMap(nArray, nArray2);
        }
        return nArray;
    }

    public int getChildPosition(Dataset dataset) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.datasetInfo.size(); ++i2) {
            SeriesDataset seriesDataset = this.getDatasetInfo(i2).data;
            if (seriesDataset instanceof CombinedDataset) {
                int n3 = ((CombinedDataset)seriesDataset).getChildPosition(dataset);
                if (n3 >= 0) {
                    return n2 + n3;
                }
                ++n2;
                continue;
            }
            if (dataset == seriesDataset) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    private DatasetInfo getDatasetInfo(int n2) {
        return (DatasetInfo)this.datasetInfo.get(n2);
    }

    private int[] joinMap(int[] nArray, int[] nArray2) {
        if (nArray == null) {
            return nArray2;
        }
        if (nArray2 == null) {
            return nArray;
        }
        int[] nArray3 = new int[nArray.length + nArray2.length];
        System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
        System.arraycopy(nArray2, 0, nArray3, nArray.length, nArray2.length);
        return nArray3;
    }

    private class DatasetInfo {
        private SeriesDataset data;
        private int series;

        DatasetInfo(SeriesDataset seriesDataset, int n2) {
            this.data = seriesDataset;
            this.series = n2;
        }
    }
}

