/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;

public abstract class AbstractDataset
implements ObjectInputValidation,
Serializable,
Cloneable,
Dataset {
    private static final long serialVersionUID = 1918768939869230744L;
    private DatasetGroup group = new DatasetGroup();
    private transient EventListenerList listenerList = new EventListenerList();
    private boolean notify = true;

    protected AbstractDataset() {
    }

    @Override
    public DatasetGroup getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(DatasetGroup datasetGroup) {
        ParamChecks.nullNotPermitted(datasetGroup, "group");
        this.group = datasetGroup;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean bl2) {
        this.notify = bl2;
        if (bl2) {
            this.fireDatasetChanged();
        }
    }

    @Override
    public void addChangeListener(DatasetChangeListener datasetChangeListener) {
        this.listenerList.add(DatasetChangeListener.class, datasetChangeListener);
    }

    @Override
    public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
        this.listenerList.remove(DatasetChangeListener.class, datasetChangeListener);
    }

    public boolean hasListener(EventListener eventListener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(eventListener);
    }

    protected void fireDatasetChanged() {
        if (this.notify) {
            this.notifyListeners(new DatasetChangeEvent(this, this));
        }
    }

    protected void notifyListeners(DatasetChangeEvent datasetChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != DatasetChangeListener.class) continue;
            ((DatasetChangeListener)objectArray[i2 + 1]).datasetChanged(datasetChangeEvent);
        }
    }

    public Object clone() {
        AbstractDataset abstractDataset = (AbstractDataset)super.clone();
        abstractDataset.listenerList = new EventListenerList();
        return abstractDataset;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
        objectInputStream.registerValidation(this, 10);
    }

    @Override
    public void validateObject() {
        this.fireDatasetChanged();
    }
}

