/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt;

import java.util.Date;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.IntervalXYDataset;

public class XYTaskDataset
extends AbstractXYDataset
implements DatasetChangeListener,
IntervalXYDataset {
    private TaskSeriesCollection underlying;
    private double seriesWidth;
    private boolean transposed;

    public XYTaskDataset(TaskSeriesCollection taskSeriesCollection) {
        ParamChecks.nullNotPermitted(taskSeriesCollection, "tasks");
        this.underlying = taskSeriesCollection;
        this.seriesWidth = 0.8;
        this.underlying.addChangeListener(this);
    }

    public TaskSeriesCollection getTasks() {
        return this.underlying;
    }

    public double getSeriesWidth() {
        return this.seriesWidth;
    }

    public void setSeriesWidth(double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("Requires 'w' > 0.0.");
        }
        this.seriesWidth = d2;
        this.fireDatasetChanged();
    }

    public boolean isTransposed() {
        return this.transposed;
    }

    public void setTransposed(boolean bl2) {
        this.transposed = bl2;
        this.fireDatasetChanged();
    }

    @Override
    public int getSeriesCount() {
        return this.underlying.getSeriesCount();
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        return this.underlying.getSeriesKey(n2);
    }

    @Override
    public int getItemCount(int n2) {
        return this.underlying.getSeries(n2).getItemCount();
    }

    @Override
    public double getXValue(int n2, int n3) {
        if (!this.transposed) {
            return this.getSeriesValue(n2);
        }
        return this.getItemValue(n2, n3);
    }

    @Override
    public double getStartXValue(int n2, int n3) {
        if (!this.transposed) {
            return this.getSeriesStartValue(n2);
        }
        return this.getItemStartValue(n2, n3);
    }

    @Override
    public double getEndXValue(int n2, int n3) {
        if (!this.transposed) {
            return this.getSeriesEndValue(n2);
        }
        return this.getItemEndValue(n2, n3);
    }

    @Override
    public Number getX(int n2, int n3) {
        return new Double(this.getXValue(n2, n3));
    }

    @Override
    public Number getStartX(int n2, int n3) {
        return new Double(this.getStartXValue(n2, n3));
    }

    @Override
    public Number getEndX(int n2, int n3) {
        return new Double(this.getEndXValue(n2, n3));
    }

    @Override
    public double getYValue(int n2, int n3) {
        if (!this.transposed) {
            return this.getItemValue(n2, n3);
        }
        return this.getSeriesValue(n2);
    }

    @Override
    public double getStartYValue(int n2, int n3) {
        if (!this.transposed) {
            return this.getItemStartValue(n2, n3);
        }
        return this.getSeriesStartValue(n2);
    }

    @Override
    public double getEndYValue(int n2, int n3) {
        if (!this.transposed) {
            return this.getItemEndValue(n2, n3);
        }
        return this.getSeriesEndValue(n2);
    }

    @Override
    public Number getY(int n2, int n3) {
        return new Double(this.getYValue(n2, n3));
    }

    @Override
    public Number getStartY(int n2, int n3) {
        return new Double(this.getStartYValue(n2, n3));
    }

    @Override
    public Number getEndY(int n2, int n3) {
        return new Double(this.getEndYValue(n2, n3));
    }

    private double getSeriesValue(int n2) {
        return n2;
    }

    private double getSeriesStartValue(int n2) {
        return (double)n2 - this.seriesWidth / 2.0;
    }

    private double getSeriesEndValue(int n2) {
        return (double)n2 + this.seriesWidth / 2.0;
    }

    private double getItemValue(int n2, int n3) {
        TaskSeries taskSeries = this.underlying.getSeries(n2);
        Task task = taskSeries.get(n3);
        TimePeriod timePeriod = task.getDuration();
        Date date = timePeriod.getStart();
        Date date2 = timePeriod.getEnd();
        return (double)(date.getTime() + date2.getTime()) / 2.0;
    }

    private double getItemStartValue(int n2, int n3) {
        TaskSeries taskSeries = this.underlying.getSeries(n2);
        Task task = taskSeries.get(n3);
        TimePeriod timePeriod = task.getDuration();
        Date date = timePeriod.getStart();
        return date.getTime();
    }

    private double getItemEndValue(int n2, int n3) {
        TaskSeries taskSeries = this.underlying.getSeries(n2);
        Task task = taskSeries.get(n3);
        TimePeriod timePeriod = task.getDuration();
        Date date = timePeriod.getEnd();
        return date.getTime();
    }

    @Override
    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYTaskDataset)) {
            return false;
        }
        XYTaskDataset xYTaskDataset = (XYTaskDataset)object;
        if (this.seriesWidth != xYTaskDataset.seriesWidth) {
            return false;
        }
        if (this.transposed != xYTaskDataset.transposed) {
            return false;
        }
        return this.underlying.equals(xYTaskDataset.underlying);
    }

    @Override
    public Object clone() {
        XYTaskDataset xYTaskDataset = (XYTaskDataset)super.clone();
        xYTaskDataset.underlying = (TaskSeriesCollection)this.underlying.clone();
        return xYTaskDataset;
    }
}

