/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.time.TimePeriod;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class TaskSeriesCollection
extends AbstractSeriesDataset
implements Serializable,
Cloneable,
GanttCategoryDataset,
PublicCloneable {
    private static final long serialVersionUID = -2065799050738449903L;
    private List keys = new ArrayList();
    private List data = new ArrayList();

    public TaskSeries getSeries(Comparable comparable) {
        if (comparable == null) {
            throw new NullPointerException("Null 'key' argument.");
        }
        TaskSeries taskSeries = null;
        int n2 = this.getRowIndex(comparable);
        if (n2 >= 0) {
            taskSeries = this.getSeries(n2);
        }
        return taskSeries;
    }

    public TaskSeries getSeries(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("Series index out of bounds");
        }
        return (TaskSeries)this.data.get(n2);
    }

    @Override
    public int getSeriesCount() {
        return this.getRowCount();
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        TaskSeries taskSeries = (TaskSeries)this.data.get(n2);
        return taskSeries.getKey();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    @Override
    public List getRowKeys() {
        return this.data;
    }

    @Override
    public int getColumnCount() {
        return this.keys.size();
    }

    @Override
    public List getColumnKeys() {
        return this.keys;
    }

    @Override
    public Comparable getColumnKey(int n2) {
        return (Comparable)this.keys.get(n2);
    }

    @Override
    public int getColumnIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "columnKey");
        return this.keys.indexOf(comparable);
    }

    @Override
    public int getRowIndex(Comparable comparable) {
        int n2 = -1;
        int n3 = this.data.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            TaskSeries taskSeries = (TaskSeries)this.data.get(i2);
            if (!taskSeries.getKey().equals(comparable)) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    @Override
    public Comparable getRowKey(int n2) {
        TaskSeries taskSeries = (TaskSeries)this.data.get(n2);
        return taskSeries.getKey();
    }

    public void add(TaskSeries taskSeries) {
        ParamChecks.nullNotPermitted(taskSeries, "series");
        this.data.add(taskSeries);
        taskSeries.addChangeListener(this);
        for (Task task : taskSeries.getTasks()) {
            String string = task.getDescription();
            int n2 = this.keys.indexOf(string);
            if (n2 >= 0) continue;
            this.keys.add(string);
        }
        this.fireDatasetChanged();
    }

    public void remove(TaskSeries taskSeries) {
        ParamChecks.nullNotPermitted(taskSeries, "series");
        if (this.data.contains(taskSeries)) {
            taskSeries.removeChangeListener(this);
            this.data.remove(taskSeries);
            this.fireDatasetChanged();
        }
    }

    public void remove(int n2) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("TaskSeriesCollection.remove(): index outside valid range.");
        }
        TaskSeries taskSeries = (TaskSeries)this.data.get(n2);
        taskSeries.removeChangeListener(this);
        this.data.remove(n2);
        this.fireDatasetChanged();
    }

    public void removeAll() {
        for (TaskSeries taskSeries : this.data) {
            taskSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    @Override
    public Number getValue(Comparable comparable, Comparable comparable2) {
        return this.getStartValue(comparable, comparable2);
    }

    @Override
    public Number getValue(int n2, int n3) {
        return this.getStartValue(n2, n3);
    }

    @Override
    public Number getStartValue(Comparable comparable, Comparable comparable2) {
        TimePeriod timePeriod;
        Long l2 = null;
        int n2 = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n2);
        Task task = taskSeries.get(comparable2.toString());
        if (task != null && (timePeriod = task.getDuration()) != null) {
            l2 = new Long(timePeriod.getStart().getTime());
        }
        return l2;
    }

    @Override
    public Number getStartValue(int n2, int n3) {
        Comparable comparable = this.getRowKey(n2);
        Comparable comparable2 = this.getColumnKey(n3);
        return this.getStartValue(comparable, comparable2);
    }

    @Override
    public Number getEndValue(Comparable comparable, Comparable comparable2) {
        TimePeriod timePeriod;
        Long l2 = null;
        int n2 = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n2);
        Task task = taskSeries.get(comparable2.toString());
        if (task != null && (timePeriod = task.getDuration()) != null) {
            l2 = new Long(timePeriod.getEnd().getTime());
        }
        return l2;
    }

    @Override
    public Number getEndValue(int n2, int n3) {
        Comparable comparable = this.getRowKey(n2);
        Comparable comparable2 = this.getColumnKey(n3);
        return this.getEndValue(comparable, comparable2);
    }

    @Override
    public Number getPercentComplete(int n2, int n3) {
        Comparable comparable = this.getRowKey(n2);
        Comparable comparable2 = this.getColumnKey(n3);
        return this.getPercentComplete(comparable, comparable2);
    }

    @Override
    public Number getPercentComplete(Comparable comparable, Comparable comparable2) {
        Double d2 = null;
        int n2 = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n2);
        Task task = taskSeries.get(comparable2.toString());
        if (task != null) {
            d2 = task.getPercentComplete();
        }
        return d2;
    }

    @Override
    public int getSubIntervalCount(int n2, int n3) {
        Comparable comparable = this.getRowKey(n2);
        Comparable comparable2 = this.getColumnKey(n3);
        return this.getSubIntervalCount(comparable, comparable2);
    }

    @Override
    public int getSubIntervalCount(Comparable comparable, Comparable comparable2) {
        int n2 = 0;
        int n3 = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n3);
        Task task = taskSeries.get(comparable2.toString());
        if (task != null) {
            n2 = task.getSubtaskCount();
        }
        return n2;
    }

    @Override
    public Number getStartValue(int n2, int n3, int n4) {
        Comparable comparable = this.getRowKey(n2);
        Comparable comparable2 = this.getColumnKey(n3);
        return this.getStartValue(comparable, comparable2, n4);
    }

    @Override
    public Number getStartValue(Comparable comparable, Comparable comparable2, int n2) {
        Task task;
        Long l2 = null;
        int n3 = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n3);
        Task task2 = taskSeries.get(comparable2.toString());
        if (task2 != null && (task = task2.getSubtask(n2)) != null) {
            TimePeriod timePeriod = task.getDuration();
            l2 = new Long(timePeriod.getStart().getTime());
        }
        return l2;
    }

    @Override
    public Number getEndValue(int n2, int n3, int n4) {
        Comparable comparable = this.getRowKey(n2);
        Comparable comparable2 = this.getColumnKey(n3);
        return this.getEndValue(comparable, comparable2, n4);
    }

    @Override
    public Number getEndValue(Comparable comparable, Comparable comparable2, int n2) {
        Task task;
        Long l2 = null;
        int n3 = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n3);
        Task task2 = taskSeries.get(comparable2.toString());
        if (task2 != null && (task = task2.getSubtask(n2)) != null) {
            TimePeriod timePeriod = task.getDuration();
            l2 = new Long(timePeriod.getEnd().getTime());
        }
        return l2;
    }

    @Override
    public Number getPercentComplete(int n2, int n3, int n4) {
        Comparable comparable = this.getRowKey(n2);
        Comparable comparable2 = this.getColumnKey(n3);
        return this.getPercentComplete(comparable, comparable2, n4);
    }

    @Override
    public Number getPercentComplete(Comparable comparable, Comparable comparable2, int n2) {
        Task task;
        Double d2 = null;
        int n3 = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n3);
        Task task2 = taskSeries.get(comparable2.toString());
        if (task2 != null && (task = task2.getSubtask(n2)) != null) {
            d2 = task.getPercentComplete();
        }
        return d2;
    }

    @Override
    public void seriesChanged(SeriesChangeEvent seriesChangeEvent) {
        this.refreshKeys();
        this.fireDatasetChanged();
    }

    private void refreshKeys() {
        this.keys.clear();
        for (int i2 = 0; i2 < this.getSeriesCount(); ++i2) {
            TaskSeries taskSeries = (TaskSeries)this.data.get(i2);
            for (Task task : taskSeries.getTasks()) {
                String string = task.getDescription();
                int n2 = this.keys.indexOf(string);
                if (n2 >= 0) continue;
                this.keys.add(string);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TaskSeriesCollection)) {
            return false;
        }
        TaskSeriesCollection taskSeriesCollection = (TaskSeriesCollection)object;
        return ObjectUtilities.equal(this.data, taskSeriesCollection.data);
    }

    @Override
    public Object clone() {
        TaskSeriesCollection taskSeriesCollection = (TaskSeriesCollection)super.clone();
        taskSeriesCollection.data = (List)ObjectUtilities.deepClone(this.data);
        taskSeriesCollection.keys = new ArrayList(this.keys);
        return taskSeriesCollection;
    }
}

