/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.gantt.Task;
import org.jfree.data.general.Series;
import org.jfree.util.ObjectUtilities;

public class TaskSeries
extends Series {
    private List tasks = new ArrayList();

    public TaskSeries(String string) {
        super((Comparable)((Object)string));
    }

    public void add(Task task) {
        ParamChecks.nullNotPermitted(task, "task");
        this.tasks.add(task);
        this.fireSeriesChanged();
    }

    public void remove(Task task) {
        this.tasks.remove(task);
        this.fireSeriesChanged();
    }

    public void removeAll() {
        this.tasks.clear();
        this.fireSeriesChanged();
    }

    @Override
    public int getItemCount() {
        return this.tasks.size();
    }

    public Task get(int n2) {
        return (Task)this.tasks.get(n2);
    }

    public Task get(String string) {
        Task task = null;
        int n2 = this.tasks.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            Task task2 = (Task)this.tasks.get(i2);
            if (!task2.getDescription().equals(string)) continue;
            task = task2;
            break;
        }
        return task;
    }

    public List getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TaskSeries)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        TaskSeries taskSeries = (TaskSeries)object;
        return this.tasks.equals(taskSeries.tasks);
    }

    @Override
    public Object clone() {
        TaskSeries taskSeries = (TaskSeries)super.clone();
        taskSeries.tasks = (List)ObjectUtilities.deepClone(this.tasks);
        return taskSeries;
    }
}

