/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.util.PublicCloneable;

public class SlidingGanttCategoryDataset
extends AbstractDataset
implements GanttCategoryDataset {
    private GanttCategoryDataset underlying;
    private int firstCategoryIndex;
    private int maximumCategoryCount;

    public SlidingGanttCategoryDataset(GanttCategoryDataset ganttCategoryDataset, int n2, int n3) {
        this.underlying = ganttCategoryDataset;
        this.firstCategoryIndex = n2;
        this.maximumCategoryCount = n3;
    }

    public GanttCategoryDataset getUnderlyingDataset() {
        return this.underlying;
    }

    public int getFirstCategoryIndex() {
        return this.firstCategoryIndex;
    }

    public void setFirstCategoryIndex(int n2) {
        if (n2 < 0 || n2 >= this.underlying.getColumnCount()) {
            throw new IllegalArgumentException("Invalid index.");
        }
        this.firstCategoryIndex = n2;
        this.fireDatasetChanged();
    }

    public int getMaximumCategoryCount() {
        return this.maximumCategoryCount;
    }

    public void setMaximumCategoryCount(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Requires 'max' >= 0.");
        }
        this.maximumCategoryCount = n2;
        this.fireDatasetChanged();
    }

    private int lastCategoryIndex() {
        if (this.maximumCategoryCount == 0) {
            return -1;
        }
        return Math.min(this.firstCategoryIndex + this.maximumCategoryCount, this.underlying.getColumnCount()) - 1;
    }

    @Override
    public int getColumnIndex(Comparable comparable) {
        int n2 = this.underlying.getColumnIndex(comparable);
        if (n2 >= this.firstCategoryIndex && n2 <= this.lastCategoryIndex()) {
            return n2 - this.firstCategoryIndex;
        }
        return -1;
    }

    @Override
    public Comparable getColumnKey(int n2) {
        return this.underlying.getColumnKey(n2 + this.firstCategoryIndex);
    }

    @Override
    public List getColumnKeys() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        int n2 = this.lastCategoryIndex();
        for (int i2 = this.firstCategoryIndex; i2 < n2; ++i2) {
            arrayList.add(this.underlying.getColumnKey(i2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public int getRowIndex(Comparable comparable) {
        return this.underlying.getRowIndex(comparable);
    }

    @Override
    public Comparable getRowKey(int n2) {
        return this.underlying.getRowKey(n2);
    }

    @Override
    public List getRowKeys() {
        return this.underlying.getRowKeys();
    }

    @Override
    public Number getValue(Comparable comparable, Comparable comparable2) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        if (n3 != -1) {
            return this.underlying.getValue(n2, n3 + this.firstCategoryIndex);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    @Override
    public int getColumnCount() {
        int n2 = this.lastCategoryIndex();
        if (n2 == -1) {
            return 0;
        }
        return Math.max(n2 - this.firstCategoryIndex + 1, 0);
    }

    @Override
    public int getRowCount() {
        return this.underlying.getRowCount();
    }

    @Override
    public Number getValue(int n2, int n3) {
        return this.underlying.getValue(n2, n3 + this.firstCategoryIndex);
    }

    @Override
    public Number getPercentComplete(Comparable comparable, Comparable comparable2) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        if (n3 != -1) {
            return this.underlying.getPercentComplete(n2, n3 + this.firstCategoryIndex);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    @Override
    public Number getPercentComplete(Comparable comparable, Comparable comparable2, int n2) {
        int n3 = this.getRowIndex(comparable);
        int n4 = this.getColumnIndex(comparable2);
        if (n4 != -1) {
            return this.underlying.getPercentComplete(n3, n4 + this.firstCategoryIndex, n2);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    @Override
    public Number getEndValue(Comparable comparable, Comparable comparable2, int n2) {
        int n3 = this.getRowIndex(comparable);
        int n4 = this.getColumnIndex(comparable2);
        if (n4 != -1) {
            return this.underlying.getEndValue(n3, n4 + this.firstCategoryIndex, n2);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    @Override
    public Number getEndValue(int n2, int n3, int n4) {
        return this.underlying.getEndValue(n2, n3 + this.firstCategoryIndex, n4);
    }

    @Override
    public Number getPercentComplete(int n2, int n3) {
        return this.underlying.getPercentComplete(n2, n3 + this.firstCategoryIndex);
    }

    @Override
    public Number getPercentComplete(int n2, int n3, int n4) {
        return this.underlying.getPercentComplete(n2, n3 + this.firstCategoryIndex, n4);
    }

    @Override
    public Number getStartValue(Comparable comparable, Comparable comparable2, int n2) {
        int n3 = this.getRowIndex(comparable);
        int n4 = this.getColumnIndex(comparable2);
        if (n4 != -1) {
            return this.underlying.getStartValue(n3, n4 + this.firstCategoryIndex, n2);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    @Override
    public Number getStartValue(int n2, int n3, int n4) {
        return this.underlying.getStartValue(n2, n3 + this.firstCategoryIndex, n4);
    }

    @Override
    public int getSubIntervalCount(Comparable comparable, Comparable comparable2) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        if (n3 != -1) {
            return this.underlying.getSubIntervalCount(n2, n3 + this.firstCategoryIndex);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    @Override
    public int getSubIntervalCount(int n2, int n3) {
        return this.underlying.getSubIntervalCount(n2, n3 + this.firstCategoryIndex);
    }

    @Override
    public Number getStartValue(Comparable comparable, Comparable comparable2) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        if (n3 != -1) {
            return this.underlying.getStartValue(n2, n3 + this.firstCategoryIndex);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    @Override
    public Number getStartValue(int n2, int n3) {
        return this.underlying.getStartValue(n2, n3 + this.firstCategoryIndex);
    }

    @Override
    public Number getEndValue(Comparable comparable, Comparable comparable2) {
        int n2 = this.getRowIndex(comparable);
        int n3 = this.getColumnIndex(comparable2);
        if (n3 != -1) {
            return this.underlying.getEndValue(n2, n3 + this.firstCategoryIndex);
        }
        throw new UnknownKeyException("Unknown columnKey: " + comparable2);
    }

    @Override
    public Number getEndValue(int n2, int n3) {
        return this.underlying.getEndValue(n2, n3 + this.firstCategoryIndex);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SlidingGanttCategoryDataset)) {
            return false;
        }
        SlidingGanttCategoryDataset slidingGanttCategoryDataset = (SlidingGanttCategoryDataset)object;
        if (this.firstCategoryIndex != slidingGanttCategoryDataset.firstCategoryIndex) {
            return false;
        }
        if (this.maximumCategoryCount != slidingGanttCategoryDataset.maximumCategoryCount) {
            return false;
        }
        return this.underlying.equals(slidingGanttCategoryDataset.underlying);
    }

    @Override
    public Object clone() {
        SlidingGanttCategoryDataset slidingGanttCategoryDataset = (SlidingGanttCategoryDataset)super.clone();
        if (this.underlying instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)((Object)this.underlying);
            slidingGanttCategoryDataset.underlying = (GanttCategoryDataset)publicCloneable.clone();
        }
        return slidingGanttCategoryDataset;
    }
}

