/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.function;

import java.io.Serializable;
import java.util.Arrays;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.function.Function2D;

public class PolynomialFunction2D
implements Serializable,
Function2D {
    private double[] coefficients;

    public PolynomialFunction2D(double[] dArray) {
        ParamChecks.nullNotPermitted(dArray, "coefficients");
        this.coefficients = (double[])dArray.clone();
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    public int getOrder() {
        return this.coefficients.length - 1;
    }

    @Override
    public double getValue(double d2) {
        double d3 = 0.0;
        for (int i2 = 0; i2 < this.coefficients.length; ++i2) {
            d3 += this.coefficients[i2] * Math.pow(d2, i2);
        }
        return d3;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PolynomialFunction2D)) {
            return false;
        }
        PolynomialFunction2D polynomialFunction2D = (PolynomialFunction2D)object;
        return Arrays.equals(this.coefficients, polynomialFunction2D.coefficients);
    }

    public int hashCode() {
        return HashUtilities.hashCodeForDoubleArray(this.coefficients);
    }
}

