/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.function;

import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.data.function.Function2D;

public class NormalDistributionFunction2D
implements Serializable,
Function2D {
    private double mean;
    private double std;
    private double factor;
    private double denominator;

    public NormalDistributionFunction2D(double d2, double d3) {
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("Requires 'std' > 0.");
        }
        this.mean = d2;
        this.std = d3;
        this.factor = 1.0 / (d3 * Math.sqrt(Math.PI * 2));
        this.denominator = 2.0 * d3 * d3;
    }

    public double getMean() {
        return this.mean;
    }

    public double getStandardDeviation() {
        return this.std;
    }

    @Override
    public double getValue(double d2) {
        double d3 = d2 - this.mean;
        return this.factor * Math.exp(-d3 * d3 / this.denominator);
    }

    public boolean equals(Object object) {
        if (!(object instanceof NormalDistributionFunction2D)) {
            return false;
        }
        NormalDistributionFunction2D normalDistributionFunction2D = (NormalDistributionFunction2D)object;
        if (this.mean != normalDistributionFunction2D.mean) {
            return false;
        }
        return this.std == normalDistributionFunction2D.std;
    }

    public int hashCode() {
        int n2 = 29;
        n2 = HashUtilities.hashCode(n2, this.mean);
        n2 = HashUtilities.hashCode(n2, this.std);
        return n2;
    }
}

