/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.contour;

import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import org.jfree.data.Range;
import org.jfree.data.contour.ContourDataset;
import org.jfree.data.xy.AbstractXYZDataset;

public class DefaultContourDataset
extends AbstractXYZDataset
implements ContourDataset {
    protected Comparable seriesKey = null;
    protected Number[] xValues = null;
    protected Number[] yValues = null;
    protected Number[] zValues = null;
    protected int[] xIndex = null;
    boolean[] dateAxis = new boolean[3];

    public DefaultContourDataset() {
    }

    public DefaultContourDataset(Comparable comparable, Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        this.seriesKey = comparable;
        this.initialize(objectArray, objectArray2, objectArray3);
    }

    public void initialize(Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        int n2;
        this.xValues = new Double[objectArray.length];
        this.yValues = new Double[objectArray2.length];
        this.zValues = new Double[objectArray3.length];
        Vector<Integer> vector = new Vector<Integer>();
        double d2 = 1.123452E31;
        for (int i2 = 0; i2 < this.xValues.length; ++i2) {
            Number number;
            if (objectArray[i2] == null) continue;
            if (objectArray[i2] instanceof Number) {
                number = (Number)objectArray[i2];
            } else if (objectArray[i2] instanceof Date) {
                this.dateAxis[0] = true;
                Date date = (Date)objectArray[i2];
                number = new Long(date.getTime());
            } else {
                number = new Integer(0);
            }
            this.xValues[i2] = new Double(number.doubleValue());
            if (d2 == this.xValues[i2].doubleValue()) continue;
            vector.add(new Integer(i2));
            d2 = this.xValues[i2].doubleValue();
        }
        Object[] objectArray4 = vector.toArray();
        this.xIndex = new int[objectArray4.length];
        for (n2 = 0; n2 < objectArray4.length; ++n2) {
            this.xIndex[n2] = (Integer)objectArray4[n2];
        }
        for (n2 = 0; n2 < this.yValues.length; ++n2) {
            this.yValues[n2] = (Double)objectArray2[n2];
            if (objectArray3[n2] == null) continue;
            this.zValues[n2] = (Double)objectArray3[n2];
        }
    }

    public static Object[][] formObjectArray(double[][] dArray) {
        Object[][] objectArray = new Double[dArray.length][dArray[0].length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            for (int i3 = 0; i3 < objectArray[i2].length; ++i3) {
                objectArray[i2][i3] = new Double(dArray[i2][i3]);
            }
        }
        return objectArray;
    }

    public static Object[] formObjectArray(double[] dArray) {
        Object[] objectArray = new Double[dArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray[i2] = new Double(dArray[i2]);
        }
        return objectArray;
    }

    @Override
    public int getItemCount(int n2) {
        if (n2 > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.zValues.length;
    }

    @Override
    public double getMaxZValue() {
        double d2 = -1.0E20;
        for (int i2 = 0; i2 < this.zValues.length; ++i2) {
            if (this.zValues[i2] == null) continue;
            d2 = Math.max(d2, this.zValues[i2].doubleValue());
        }
        return d2;
    }

    @Override
    public double getMinZValue() {
        double d2 = 1.0E20;
        for (int i2 = 0; i2 < this.zValues.length; ++i2) {
            if (this.zValues[i2] == null) continue;
            d2 = Math.min(d2, this.zValues[i2].doubleValue());
        }
        return d2;
    }

    @Override
    public Range getZValueRange(Range range, Range range2) {
        double d2 = range.getLowerBound();
        double d3 = range2.getLowerBound();
        double d4 = range.getUpperBound();
        double d5 = range2.getUpperBound();
        double d6 = 1.0E20;
        double d7 = -1.0E20;
        for (int i2 = 0; i2 < this.zValues.length; ++i2) {
            if (!(this.xValues[i2].doubleValue() >= d2) || !(this.xValues[i2].doubleValue() <= d4) || !(this.yValues[i2].doubleValue() >= d3) || !(this.yValues[i2].doubleValue() <= d5) || this.zValues[i2] == null) continue;
            d6 = Math.min(d6, this.zValues[i2].doubleValue());
            d7 = Math.max(d7, this.zValues[i2].doubleValue());
        }
        return new Range(d6, d7);
    }

    public double getMinZValue(double d2, double d3, double d4, double d5) {
        double d6 = 1.0E20;
        for (int i2 = 0; i2 < this.zValues.length; ++i2) {
            if (this.zValues[i2] == null) continue;
            d6 = Math.min(d6, this.zValues[i2].doubleValue());
        }
        return d6;
    }

    @Override
    public int getSeriesCount() {
        return 1;
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        if (n2 > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.seriesKey;
    }

    @Override
    public int[] getXIndices() {
        return this.xIndex;
    }

    @Override
    public Number[] getXValues() {
        return this.xValues;
    }

    @Override
    public Number getX(int n2, int n3) {
        if (n2 > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.xValues[n3];
    }

    public Number getXValue(int n2) {
        return this.xValues[n2];
    }

    @Override
    public Number[] getYValues() {
        return this.yValues;
    }

    @Override
    public Number getY(int n2, int n3) {
        if (n2 > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.yValues[n3];
    }

    @Override
    public Number[] getZValues() {
        return this.zValues;
    }

    @Override
    public Number getZ(int n2, int n3) {
        if (n2 > 0) {
            throw new IllegalArgumentException("Only one series for contour");
        }
        return this.zValues[n3];
    }

    @Override
    public int[] indexX() {
        int[] nArray = new int[this.xValues.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = this.indexX(i2);
        }
        return nArray;
    }

    public int indexX(int n2) {
        int n3 = Arrays.binarySearch(this.xIndex, n2);
        if (n3 >= 0) {
            return n3;
        }
        return -1 * n3 - 2;
    }

    public int indexY(int n2) {
        return n2 / this.xValues.length;
    }

    public int indexZ(int n2, int n3) {
        return this.xValues.length * n3 + n2;
    }

    @Override
    public boolean isDateAxis(int n2) {
        if (n2 < 0 || n2 > 2) {
            return false;
        }
        return this.dateAxis[n2];
    }

    public void setSeriesKeys(Comparable[] comparableArray) {
        if (comparableArray.length > 1) {
            throw new IllegalArgumentException("Contours only support one series");
        }
        this.seriesKey = comparableArray[0];
        this.fireDatasetChanged();
    }
}

