/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.category;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ResourceBundleWrapper;
import org.jfree.data.DataUtilities;
import org.jfree.data.UnknownKeyException;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.general.AbstractSeriesDataset;

public class DefaultIntervalCategoryDataset
extends AbstractSeriesDataset
implements IntervalCategoryDataset {
    private Comparable[] seriesKeys;
    private Comparable[] categoryKeys;
    private Number[][] startData;
    private Number[][] endData;

    public DefaultIntervalCategoryDataset(double[][] dArray, double[][] dArray2) {
        this(DataUtilities.createNumberArray2D(dArray), DataUtilities.createNumberArray2D(dArray2));
    }

    public DefaultIntervalCategoryDataset(Number[][] numberArray, Number[][] numberArray2) {
        this(null, null, numberArray, numberArray2);
    }

    public DefaultIntervalCategoryDataset(String[] stringArray, Number[][] numberArray, Number[][] numberArray2) {
        this((Comparable[])stringArray, null, numberArray, numberArray2);
    }

    public DefaultIntervalCategoryDataset(Comparable[] comparableArray, Comparable[] comparableArray2, Number[][] numberArray, Number[][] numberArray2) {
        this.startData = numberArray;
        this.endData = numberArray2;
        if (numberArray != null && numberArray2 != null) {
            String string = "org.jfree.data.resources.DataPackageResources";
            ResourceBundle resourceBundle = ResourceBundleWrapper.getBundle(string);
            int n2 = numberArray.length;
            if (n2 != numberArray2.length) {
                String string2 = "DefaultIntervalCategoryDataset: the number of series in the start value dataset does not match the number of series in the end value dataset.";
                throw new IllegalArgumentException(string2);
            }
            if (n2 > 0) {
                if (comparableArray != null) {
                    if (comparableArray.length != n2) {
                        throw new IllegalArgumentException("The number of series keys does not match the number of series in the data.");
                    }
                    this.seriesKeys = comparableArray;
                } else {
                    String string3 = resourceBundle.getString("series.default-prefix") + " ";
                    this.seriesKeys = this.generateKeys(n2, string3);
                }
                int n3 = numberArray[0].length;
                if (n3 != numberArray2[0].length) {
                    String string4 = "DefaultIntervalCategoryDataset: the number of categories in the start value dataset does not match the number of categories in the end value dataset.";
                    throw new IllegalArgumentException(string4);
                }
                if (comparableArray2 != null) {
                    if (comparableArray2.length != n3) {
                        throw new IllegalArgumentException("The number of category keys does not match the number of categories in the data.");
                    }
                    this.categoryKeys = comparableArray2;
                } else {
                    String string5 = resourceBundle.getString("categories.default-prefix") + " ";
                    this.categoryKeys = this.generateKeys(n3, string5);
                }
            } else {
                this.seriesKeys = new Comparable[0];
                this.categoryKeys = new Comparable[0];
            }
        }
    }

    @Override
    public int getSeriesCount() {
        int n2 = 0;
        if (this.startData != null) {
            n2 = this.startData.length;
        }
        return n2;
    }

    public int getSeriesIndex(Comparable comparable) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.seriesKeys.length; ++i2) {
            if (!comparable.equals(this.seriesKeys[i2])) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    @Override
    public Comparable getSeriesKey(int n2) {
        if (n2 >= this.getSeriesCount() || n2 < 0) {
            throw new IllegalArgumentException("No such series : " + n2);
        }
        return this.seriesKeys[n2];
    }

    public void setSeriesKeys(Comparable[] comparableArray) {
        ParamChecks.nullNotPermitted(comparableArray, "seriesKeys");
        if (comparableArray.length != this.getSeriesCount()) {
            throw new IllegalArgumentException("The number of series keys does not match the data.");
        }
        this.seriesKeys = comparableArray;
        this.fireDatasetChanged();
    }

    public int getCategoryCount() {
        int n2 = 0;
        if (this.startData != null && this.getSeriesCount() > 0) {
            n2 = this.startData[0].length;
        }
        return n2;
    }

    @Override
    public List getColumnKeys() {
        if (this.categoryKeys == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.categoryKeys));
    }

    public void setCategoryKeys(Comparable[] comparableArray) {
        ParamChecks.nullNotPermitted(comparableArray, "categoryKeys");
        if (comparableArray.length != this.getCategoryCount()) {
            throw new IllegalArgumentException("The number of categories does not match the data.");
        }
        for (int i2 = 0; i2 < comparableArray.length; ++i2) {
            if (comparableArray[i2] != null) continue;
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setCategoryKeys(): null category not permitted.");
        }
        this.categoryKeys = comparableArray;
        this.fireDatasetChanged();
    }

    @Override
    public Number getValue(Comparable comparable, Comparable comparable2) {
        int n2 = this.getSeriesIndex(comparable);
        if (n2 < 0) {
            throw new UnknownKeyException("Unknown 'series' key.");
        }
        int n3 = this.getColumnIndex(comparable2);
        if (n3 < 0) {
            throw new UnknownKeyException("Unknown 'category' key.");
        }
        return this.getValue(n2, n3);
    }

    @Override
    public Number getValue(int n2, int n3) {
        return this.getEndValue(n2, n3);
    }

    @Override
    public Number getStartValue(Comparable comparable, Comparable comparable2) {
        int n2 = this.getSeriesIndex(comparable);
        if (n2 < 0) {
            throw new UnknownKeyException("Unknown 'series' key.");
        }
        int n3 = this.getColumnIndex(comparable2);
        if (n3 < 0) {
            throw new UnknownKeyException("Unknown 'category' key.");
        }
        return this.getStartValue(n2, n3);
    }

    @Override
    public Number getStartValue(int n2, int n3) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(): series index out of range.");
        }
        if (n3 < 0 || n3 >= this.getCategoryCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(): category index out of range.");
        }
        return this.startData[n2][n3];
    }

    @Override
    public Number getEndValue(Comparable comparable, Comparable comparable2) {
        int n2 = this.getSeriesIndex(comparable);
        if (n2 < 0) {
            throw new UnknownKeyException("Unknown 'series' key.");
        }
        int n3 = this.getColumnIndex(comparable2);
        if (n3 < 0) {
            throw new UnknownKeyException("Unknown 'category' key.");
        }
        return this.getEndValue(n2, n3);
    }

    @Override
    public Number getEndValue(int n2, int n3) {
        if (n2 < 0 || n2 >= this.getSeriesCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(): series index out of range.");
        }
        if (n3 < 0 || n3 >= this.getCategoryCount()) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.getValue(): category index out of range.");
        }
        return this.endData[n2][n3];
    }

    public void setStartValue(int n2, Comparable comparable, Number number) {
        if (n2 < 0 || n2 > this.getSeriesCount() - 1) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: series outside valid range.");
        }
        int n3 = this.getCategoryIndex(comparable);
        if (n3 < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: unrecognised category.");
        }
        this.startData[n2][n3] = number;
        this.fireDatasetChanged();
    }

    public void setEndValue(int n2, Comparable comparable, Number number) {
        if (n2 < 0 || n2 > this.getSeriesCount() - 1) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: series outside valid range.");
        }
        int n3 = this.getCategoryIndex(comparable);
        if (n3 < 0) {
            throw new IllegalArgumentException("DefaultIntervalCategoryDataset.setValue: unrecognised category.");
        }
        this.endData[n2][n3] = number;
        this.fireDatasetChanged();
    }

    public int getCategoryIndex(Comparable comparable) {
        int n2 = -1;
        for (int i2 = 0; i2 < this.categoryKeys.length; ++i2) {
            if (!comparable.equals(this.categoryKeys[i2])) continue;
            n2 = i2;
            break;
        }
        return n2;
    }

    private Comparable[] generateKeys(int n2, String string) {
        Comparable[] comparableArray = new Comparable[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string2 = string + (i2 + 1);
            comparableArray[i2] = string2;
        }
        return comparableArray;
    }

    @Override
    public Comparable getColumnKey(int n2) {
        return this.categoryKeys[n2];
    }

    @Override
    public int getColumnIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "columnKey");
        return this.getCategoryIndex(comparable);
    }

    @Override
    public int getRowIndex(Comparable comparable) {
        return this.getSeriesIndex(comparable);
    }

    @Override
    public List getRowKeys() {
        if (this.seriesKeys == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.seriesKeys));
    }

    @Override
    public Comparable getRowKey(int n2) {
        if (n2 >= this.getRowCount() || n2 < 0) {
            throw new IllegalArgumentException("The 'row' argument is out of bounds.");
        }
        return this.seriesKeys[n2];
    }

    @Override
    public int getColumnCount() {
        return this.categoryKeys.length;
    }

    @Override
    public int getRowCount() {
        return this.seriesKeys.length;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultIntervalCategoryDataset)) {
            return false;
        }
        DefaultIntervalCategoryDataset defaultIntervalCategoryDataset = (DefaultIntervalCategoryDataset)object;
        if (!Arrays.equals(this.seriesKeys, defaultIntervalCategoryDataset.seriesKeys)) {
            return false;
        }
        if (!Arrays.equals(this.categoryKeys, defaultIntervalCategoryDataset.categoryKeys)) {
            return false;
        }
        if (!DefaultIntervalCategoryDataset.equal(this.startData, defaultIntervalCategoryDataset.startData)) {
            return false;
        }
        return DefaultIntervalCategoryDataset.equal(this.endData, defaultIntervalCategoryDataset.endData);
    }

    @Override
    public Object clone() {
        DefaultIntervalCategoryDataset defaultIntervalCategoryDataset = (DefaultIntervalCategoryDataset)super.clone();
        defaultIntervalCategoryDataset.categoryKeys = (Comparable[])this.categoryKeys.clone();
        defaultIntervalCategoryDataset.seriesKeys = (Comparable[])this.seriesKeys.clone();
        defaultIntervalCategoryDataset.startData = DefaultIntervalCategoryDataset.clone(this.startData);
        defaultIntervalCategoryDataset.endData = DefaultIntervalCategoryDataset.clone(this.endData);
        return defaultIntervalCategoryDataset;
    }

    private static boolean equal(Number[][] numberArray, Number[][] numberArray2) {
        if (numberArray == null) {
            return numberArray2 == null;
        }
        if (numberArray2 == null) {
            return false;
        }
        if (numberArray.length != numberArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < numberArray.length; ++i2) {
            if (Arrays.equals(numberArray[i2], numberArray2[i2])) continue;
            return false;
        }
        return true;
    }

    private static Number[][] clone(Number[][] numberArray) {
        ParamChecks.nullNotPermitted(numberArray, "array");
        Number[][] numberArray2 = new Number[numberArray.length][];
        for (int i2 = 0; i2 < numberArray.length; ++i2) {
            Number[] numberArray3 = numberArray[i2];
            Number[] numberArray4 = new Number[numberArray3.length];
            System.arraycopy(numberArray3, 0, numberArray4, 0, numberArray3.length);
            numberArray2[i2] = numberArray4;
        }
        return numberArray2;
    }

    public List getSeries() {
        if (this.seriesKeys == null) {
            return new ArrayList();
        }
        return Collections.unmodifiableList(Arrays.asList(this.seriesKeys));
    }

    public List getCategories() {
        return this.getColumnKeys();
    }

    public int getItemCount() {
        return this.categoryKeys.length;
    }
}

