/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.category;

import java.util.Collections;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.PieDataset;
import org.jfree.util.TableOrder;

public class CategoryToPieDataset
extends AbstractDataset
implements DatasetChangeListener,
PieDataset {
    static final long serialVersionUID = 5516396319762189617L;
    private CategoryDataset source;
    private TableOrder extract;
    private int index;

    public CategoryToPieDataset(CategoryDataset categoryDataset, TableOrder tableOrder, int n2) {
        ParamChecks.nullNotPermitted(tableOrder, "extract");
        this.source = categoryDataset;
        if (this.source != null) {
            this.source.addChangeListener(this);
        }
        this.extract = tableOrder;
        this.index = n2;
    }

    public CategoryDataset getUnderlyingDataset() {
        return this.source;
    }

    public TableOrder getExtractType() {
        return this.extract;
    }

    public int getExtractIndex() {
        return this.index;
    }

    @Override
    public int getItemCount() {
        int n2 = 0;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                n2 = this.source.getColumnCount();
            } else if (this.extract == TableOrder.BY_COLUMN) {
                n2 = this.source.getRowCount();
            }
        }
        return n2;
    }

    @Override
    public Number getValue(int n2) {
        Number number = null;
        if (n2 < 0 || n2 >= this.getItemCount()) {
            throw new IndexOutOfBoundsException("The 'item' index is out of bounds.");
        }
        if (this.extract == TableOrder.BY_ROW) {
            number = this.source.getValue(this.index, n2);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            number = this.source.getValue(n2, this.index);
        }
        return number;
    }

    @Override
    public Comparable getKey(int n2) {
        Comparable comparable = null;
        if (n2 < 0 || n2 >= this.getItemCount()) {
            throw new IndexOutOfBoundsException("Invalid 'index': " + n2);
        }
        if (this.extract == TableOrder.BY_ROW) {
            comparable = this.source.getColumnKey(n2);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            comparable = this.source.getRowKey(n2);
        }
        return comparable;
    }

    @Override
    public int getIndex(Comparable comparable) {
        int n2 = -1;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                n2 = this.source.getColumnIndex(comparable);
            } else if (this.extract == TableOrder.BY_COLUMN) {
                n2 = this.source.getRowIndex(comparable);
            }
        }
        return n2;
    }

    @Override
    public List getKeys() {
        List list = Collections.EMPTY_LIST;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                list = this.source.getColumnKeys();
            } else if (this.extract == TableOrder.BY_COLUMN) {
                list = this.source.getRowKeys();
            }
        }
        return list;
    }

    @Override
    public Number getValue(Comparable comparable) {
        Number number = null;
        int n2 = this.getIndex(comparable);
        if (n2 != -1) {
            if (this.extract == TableOrder.BY_ROW) {
                number = this.source.getValue(this.index, n2);
            } else if (this.extract == TableOrder.BY_COLUMN) {
                number = this.source.getValue(n2, this.index);
            }
        }
        return number;
    }

    @Override
    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.fireDatasetChanged();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof PieDataset)) {
            return false;
        }
        PieDataset pieDataset = (PieDataset)object;
        int n2 = this.getItemCount();
        if (pieDataset.getItemCount() != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i2);
            if (!comparable2.equals(comparable = pieDataset.getKey(i2))) {
                return false;
            }
            Number number = this.getValue(i2);
            Number number2 = pieDataset.getValue(i2);
            if (!(number == null ? number2 != null : !number.equals(number2))) continue;
            return false;
        }
        return true;
    }
}

