/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import org.jfree.chart.util.ParamChecks;

public strictfp class Range
implements Serializable {
    private static final long serialVersionUID = -906333695431863380L;
    private double lower;
    private double upper;

    public Range(double d2, double d3) {
        if (d2 > d3) {
            String string = "Range(double, double): require lower (" + d2 + ") <= upper (" + d3 + ").";
            throw new IllegalArgumentException(string);
        }
        this.lower = d2;
        this.upper = d3;
    }

    public double getLowerBound() {
        return this.lower;
    }

    public double getUpperBound() {
        return this.upper;
    }

    public double getLength() {
        return this.upper - this.lower;
    }

    public double getCentralValue() {
        return this.lower / 2.0 + this.upper / 2.0;
    }

    public boolean contains(double d2) {
        return d2 >= this.lower && d2 <= this.upper;
    }

    public boolean intersects(double d2, double d3) {
        if (d2 <= this.lower) {
            return d3 > this.lower;
        }
        return d2 < this.upper && d3 >= d2;
    }

    public boolean intersects(Range range) {
        return this.intersects(range.getLowerBound(), range.getUpperBound());
    }

    public double constrain(double d2) {
        double d3 = d2;
        if (!this.contains(d2)) {
            if (d2 > this.upper) {
                d3 = this.upper;
            } else if (d2 < this.lower) {
                d3 = this.lower;
            }
        }
        return d3;
    }

    public static Range combine(Range range, Range range2) {
        if (range == null) {
            return range2;
        }
        if (range2 == null) {
            return range;
        }
        double d2 = Math.min(range.getLowerBound(), range2.getLowerBound());
        double d3 = Math.max(range.getUpperBound(), range2.getUpperBound());
        return new Range(d2, d3);
    }

    public static Range combineIgnoringNaN(Range range, Range range2) {
        if (range == null) {
            if (range2 != null && range2.isNaNRange()) {
                return null;
            }
            return range2;
        }
        if (range2 == null) {
            if (range.isNaNRange()) {
                return null;
            }
            return range;
        }
        double d2 = Range.min(range.getLowerBound(), range2.getLowerBound());
        double d3 = Range.max(range.getUpperBound(), range2.getUpperBound());
        if (Double.isNaN(d2) && Double.isNaN(d3)) {
            return null;
        }
        return new Range(d2, d3);
    }

    private static double min(double d2, double d3) {
        if (Double.isNaN(d2)) {
            return d3;
        }
        if (Double.isNaN(d3)) {
            return d2;
        }
        return Math.min(d2, d3);
    }

    private static double max(double d2, double d3) {
        if (Double.isNaN(d2)) {
            return d3;
        }
        if (Double.isNaN(d3)) {
            return d2;
        }
        return Math.max(d2, d3);
    }

    public static Range expandToInclude(Range range, double d2) {
        if (range == null) {
            return new Range(d2, d2);
        }
        if (d2 < range.getLowerBound()) {
            return new Range(d2, range.getUpperBound());
        }
        if (d2 > range.getUpperBound()) {
            return new Range(range.getLowerBound(), d2);
        }
        return range;
    }

    public static Range expand(Range range, double d2, double d3) {
        ParamChecks.nullNotPermitted(range, "range");
        double d4 = range.getLength();
        double d5 = range.getLowerBound() - d4 * d2;
        double d6 = range.getUpperBound() + d4 * d3;
        if (d5 > d6) {
            d6 = d5 = d5 / 2.0 + d6 / 2.0;
        }
        return new Range(d5, d6);
    }

    public static Range shift(Range range, double d2) {
        return Range.shift(range, d2, false);
    }

    public static Range shift(Range range, double d2, boolean bl2) {
        ParamChecks.nullNotPermitted(range, "base");
        if (bl2) {
            return new Range(range.getLowerBound() + d2, range.getUpperBound() + d2);
        }
        return new Range(Range.shiftWithNoZeroCrossing(range.getLowerBound(), d2), Range.shiftWithNoZeroCrossing(range.getUpperBound(), d2));
    }

    private static double shiftWithNoZeroCrossing(double d2, double d3) {
        if (d2 > 0.0) {
            return Math.max(d2 + d3, 0.0);
        }
        if (d2 < 0.0) {
            return Math.min(d2 + d3, 0.0);
        }
        return d2 + d3;
    }

    public static Range scale(Range range, double d2) {
        ParamChecks.nullNotPermitted(range, "base");
        if (d2 < 0.0) {
            throw new IllegalArgumentException("Negative 'factor' argument.");
        }
        return new Range(range.getLowerBound() * d2, range.getUpperBound() * d2);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Range)) {
            return false;
        }
        Range range = (Range)object;
        if (this.lower != range.lower) {
            return false;
        }
        return this.upper == range.upper;
    }

    public boolean isNaNRange() {
        return Double.isNaN(this.lower) && Double.isNaN(this.upper);
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.lower);
        int n2 = (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.upper);
        n2 = 29 * n2 + (int)(l2 ^ l2 >>> 32);
        return n2;
    }

    public String toString() {
        return "Range[" + this.lower + "," + this.upper + "]";
    }
}

