/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.KeyedObjects;
import org.jfree.data.UnknownKeyException;

public class KeyedObjects2D
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -1015873563138522374L;
    private List rowKeys = new ArrayList();
    private List columnKeys = new ArrayList();
    private List rows = new ArrayList();

    public int getRowCount() {
        return this.rowKeys.size();
    }

    public int getColumnCount() {
        return this.columnKeys.size();
    }

    public Object getObject(int n2, int n3) {
        int n4;
        Comparable comparable;
        Object object = null;
        KeyedObjects keyedObjects = (KeyedObjects)this.rows.get(n2);
        if (keyedObjects != null && (comparable = (Comparable)this.columnKeys.get(n3)) != null && (n4 = keyedObjects.getIndex(comparable)) >= 0) {
            object = keyedObjects.getObject(comparable);
        }
        return object;
    }

    public Comparable getRowKey(int n2) {
        return (Comparable)this.rowKeys.get(n2);
    }

    public int getRowIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        return this.rowKeys.indexOf(comparable);
    }

    public List getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    public Comparable getColumnKey(int n2) {
        return (Comparable)this.columnKeys.get(n2);
    }

    public int getColumnIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        return this.columnKeys.indexOf(comparable);
    }

    public List getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    public Object getObject(Comparable comparable, Comparable comparable2) {
        ParamChecks.nullNotPermitted(comparable, "rowKey");
        ParamChecks.nullNotPermitted(comparable2, "columnKey");
        int n2 = this.rowKeys.indexOf(comparable);
        if (n2 < 0) {
            throw new UnknownKeyException("Row key (" + comparable + ") not recognised.");
        }
        int n3 = this.columnKeys.indexOf(comparable2);
        if (n3 < 0) {
            throw new UnknownKeyException("Column key (" + comparable2 + ") not recognised.");
        }
        KeyedObjects keyedObjects = (KeyedObjects)this.rows.get(n2);
        int n4 = keyedObjects.getIndex(comparable2);
        if (n4 >= 0) {
            return keyedObjects.getObject(n4);
        }
        return null;
    }

    public void addObject(Object object, Comparable comparable, Comparable comparable2) {
        this.setObject(object, comparable, comparable2);
    }

    public void setObject(Object object, Comparable comparable, Comparable comparable2) {
        KeyedObjects keyedObjects;
        ParamChecks.nullNotPermitted(comparable, "rowKey");
        ParamChecks.nullNotPermitted(comparable2, "columnKey");
        int n2 = this.rowKeys.indexOf(comparable);
        if (n2 >= 0) {
            keyedObjects = (KeyedObjects)this.rows.get(n2);
        } else {
            this.rowKeys.add(comparable);
            keyedObjects = new KeyedObjects();
            this.rows.add(keyedObjects);
        }
        keyedObjects.setObject(comparable2, object);
        int n3 = this.columnKeys.indexOf(comparable2);
        if (n3 < 0) {
            this.columnKeys.add(comparable2);
        }
    }

    public void removeObject(Comparable comparable, Comparable comparable2) {
        int n2;
        int n3;
        int n4 = this.getRowIndex(comparable);
        if (n4 < 0) {
            throw new UnknownKeyException("Row key (" + comparable + ") not recognised.");
        }
        int n5 = this.getColumnIndex(comparable2);
        if (n5 < 0) {
            throw new UnknownKeyException("Column key (" + comparable2 + ") not recognised.");
        }
        this.setObject(null, comparable, comparable2);
        boolean bl2 = true;
        KeyedObjects keyedObjects = (KeyedObjects)this.rows.get(n4);
        int n6 = keyedObjects.getItemCount();
        for (n3 = 0; n3 < n6; ++n3) {
            if (keyedObjects.getObject(n3) == null) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            this.rowKeys.remove(n4);
            this.rows.remove(n4);
        }
        bl2 = true;
        n6 = this.rows.size();
        for (n3 = 0; n3 < n6; ++n3) {
            keyedObjects = (KeyedObjects)this.rows.get(n3);
            n2 = keyedObjects.getIndex(comparable2);
            if (n2 < 0 || keyedObjects.getObject(n2) == null) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            n6 = this.rows.size();
            for (n3 = 0; n3 < n6; ++n3) {
                keyedObjects = (KeyedObjects)this.rows.get(n3);
                n2 = keyedObjects.getIndex(comparable2);
                if (n2 < 0) continue;
                keyedObjects.removeValue(n2);
            }
            this.columnKeys.remove(comparable2);
        }
    }

    public void removeRow(int n2) {
        this.rowKeys.remove(n2);
        this.rows.remove(n2);
    }

    public void removeRow(Comparable comparable) {
        int n2 = this.getRowIndex(comparable);
        if (n2 < 0) {
            throw new UnknownKeyException("Row key (" + comparable + ") not recognised.");
        }
        this.removeRow(n2);
    }

    public void removeColumn(int n2) {
        Comparable comparable = this.getColumnKey(n2);
        this.removeColumn(comparable);
    }

    public void removeColumn(Comparable comparable) {
        int n2 = this.getColumnIndex(comparable);
        if (n2 < 0) {
            throw new UnknownKeyException("Column key (" + comparable + ") not recognised.");
        }
        for (KeyedObjects keyedObjects : this.rows) {
            int n3 = keyedObjects.getIndex(comparable);
            if (n3 < 0) continue;
            keyedObjects.removeValue(n3);
        }
        this.columnKeys.remove(comparable);
    }

    public void clear() {
        this.rowKeys.clear();
        this.columnKeys.clear();
        this.rows.clear();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedObjects2D)) {
            return false;
        }
        KeyedObjects2D keyedObjects2D = (KeyedObjects2D)object;
        if (!this.getRowKeys().equals(keyedObjects2D.getRowKeys())) {
            return false;
        }
        if (!this.getColumnKeys().equals(keyedObjects2D.getColumnKeys())) {
            return false;
        }
        int n2 = this.getRowCount();
        if (n2 != keyedObjects2D.getRowCount()) {
            return false;
        }
        int n3 = this.getColumnCount();
        if (n3 != keyedObjects2D.getColumnCount()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                Object object2 = this.getObject(i2, i3);
                Object object3 = keyedObjects2D.getObject(i2, i3);
                if (!(object2 == null ? object3 != null : !object2.equals(object3))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.rowKeys.hashCode();
        n2 = 29 * n2 + this.columnKeys.hashCode();
        n2 = 29 * n2 + this.rows.hashCode();
        return n2;
    }

    public Object clone() {
        KeyedObjects2D keyedObjects2D = (KeyedObjects2D)super.clone();
        keyedObjects2D.columnKeys = new ArrayList(this.columnKeys);
        keyedObjects2D.rowKeys = new ArrayList(this.rowKeys);
        keyedObjects2D.rows = new ArrayList(this.rows.size());
        for (KeyedObjects keyedObjects : this.rows) {
            keyedObjects2D.rows.add(keyedObjects.clone());
        }
        return keyedObjects2D;
    }
}

