/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.KeyedObject;
import org.jfree.data.UnknownKeyException;
import org.jfree.util.PublicCloneable;

public class KeyedObjects
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = 1321582394193530984L;
    private List data = new ArrayList();

    public int getItemCount() {
        return this.data.size();
    }

    public Object getObject(int n2) {
        Object object = null;
        KeyedObject keyedObject = (KeyedObject)this.data.get(n2);
        if (keyedObject != null) {
            object = keyedObject.getObject();
        }
        return object;
    }

    public Comparable getKey(int n2) {
        Comparable comparable = null;
        KeyedObject keyedObject = (KeyedObject)this.data.get(n2);
        if (keyedObject != null) {
            comparable = keyedObject.getKey();
        }
        return comparable;
    }

    public int getIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        int n2 = 0;
        for (KeyedObject keyedObject : this.data) {
            if (keyedObject.getKey().equals(comparable)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public List getKeys() {
        ArrayList<Comparable> arrayList = new ArrayList<Comparable>();
        for (KeyedObject keyedObject : this.data) {
            arrayList.add(keyedObject.getKey());
        }
        return arrayList;
    }

    public Object getObject(Comparable comparable) {
        int n2 = this.getIndex(comparable);
        if (n2 < 0) {
            throw new UnknownKeyException("The key (" + comparable + ") is not recognised.");
        }
        return this.getObject(n2);
    }

    public void addObject(Comparable comparable, Object object) {
        this.setObject(comparable, object);
    }

    public void setObject(Comparable comparable, Object object) {
        int n2 = this.getIndex(comparable);
        if (n2 >= 0) {
            KeyedObject keyedObject = (KeyedObject)this.data.get(n2);
            keyedObject.setObject(object);
        } else {
            KeyedObject keyedObject = new KeyedObject(comparable, object);
            this.data.add(keyedObject);
        }
    }

    public void insertValue(int n2, Comparable comparable, Object object) {
        if (n2 < 0 || n2 > this.data.size()) {
            throw new IllegalArgumentException("'position' out of bounds.");
        }
        ParamChecks.nullNotPermitted(comparable, "key");
        int n3 = this.getIndex(comparable);
        if (n3 >= 0) {
            this.data.remove(n3);
        }
        KeyedObject keyedObject = new KeyedObject(comparable, object);
        if (n2 <= this.data.size()) {
            this.data.add(n2, keyedObject);
        } else {
            this.data.add(keyedObject);
        }
    }

    public void removeValue(int n2) {
        this.data.remove(n2);
    }

    public void removeValue(Comparable comparable) {
        int n2 = this.getIndex(comparable);
        if (n2 < 0) {
            throw new UnknownKeyException("The key (" + comparable.toString() + ") is not recognised.");
        }
        this.removeValue(n2);
    }

    public void clear() {
        this.data.clear();
    }

    @Override
    public Object clone() {
        KeyedObjects keyedObjects = (KeyedObjects)super.clone();
        keyedObjects.data = new ArrayList();
        for (KeyedObject keyedObject : this.data) {
            keyedObjects.data.add(keyedObject.clone());
        }
        return keyedObjects;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedObjects)) {
            return false;
        }
        KeyedObjects keyedObjects = (KeyedObjects)object;
        int n2 = this.getItemCount();
        if (n2 != keyedObjects.getItemCount()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i2);
            if (!comparable2.equals(comparable = keyedObjects.getKey(i2))) {
                return false;
            }
            Object object2 = this.getObject(i2);
            Object object3 = keyedObjects.getObject(i2);
            if (!(object2 == null ? object3 != null : !object2.equals(object3))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }
}

