/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues2D;
import org.jfree.data.UnknownKeyException;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class DefaultKeyedValues2D
implements Serializable,
Cloneable,
KeyedValues2D,
PublicCloneable {
    private static final long serialVersionUID = -5514169970951994748L;
    private List rowKeys = new ArrayList();
    private List columnKeys = new ArrayList();
    private List rows = new ArrayList();
    private boolean sortRowKeys;

    public DefaultKeyedValues2D() {
        this(false);
    }

    public DefaultKeyedValues2D(boolean bl2) {
        this.sortRowKeys = bl2;
    }

    @Override
    public int getRowCount() {
        return this.rowKeys.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnKeys.size();
    }

    @Override
    public Number getValue(int n2, int n3) {
        Comparable comparable;
        int n4;
        Number number = null;
        DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n2);
        if (defaultKeyedValues != null && (n4 = defaultKeyedValues.getIndex(comparable = (Comparable)this.columnKeys.get(n3))) >= 0) {
            number = defaultKeyedValues.getValue(n4);
        }
        return number;
    }

    @Override
    public Comparable getRowKey(int n2) {
        return (Comparable)this.rowKeys.get(n2);
    }

    @Override
    public int getRowIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        if (this.sortRowKeys) {
            return Collections.binarySearch(this.rowKeys, comparable);
        }
        return this.rowKeys.indexOf(comparable);
    }

    @Override
    public List getRowKeys() {
        return Collections.unmodifiableList(this.rowKeys);
    }

    @Override
    public Comparable getColumnKey(int n2) {
        return (Comparable)this.columnKeys.get(n2);
    }

    @Override
    public int getColumnIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        return this.columnKeys.indexOf(comparable);
    }

    @Override
    public List getColumnKeys() {
        return Collections.unmodifiableList(this.columnKeys);
    }

    @Override
    public Number getValue(Comparable comparable, Comparable comparable2) {
        ParamChecks.nullNotPermitted(comparable, "rowKey");
        ParamChecks.nullNotPermitted(comparable2, "columnKey");
        if (!this.columnKeys.contains(comparable2)) {
            throw new UnknownKeyException("Unrecognised columnKey: " + comparable2);
        }
        int n2 = this.getRowIndex(comparable);
        if (n2 >= 0) {
            DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n2);
            int n3 = defaultKeyedValues.getIndex(comparable2);
            return n3 >= 0 ? (Number)defaultKeyedValues.getValue(n3) : (Number)null;
        }
        throw new UnknownKeyException("Unrecognised rowKey: " + comparable);
    }

    public void addValue(Number number, Comparable comparable, Comparable comparable2) {
        this.setValue(number, comparable, comparable2);
    }

    public void setValue(Number number, Comparable comparable, Comparable comparable2) {
        DefaultKeyedValues defaultKeyedValues;
        int n2 = this.getRowIndex(comparable);
        if (n2 >= 0) {
            defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n2);
        } else {
            defaultKeyedValues = new DefaultKeyedValues();
            if (this.sortRowKeys) {
                n2 = -n2 - 1;
                this.rowKeys.add(n2, comparable);
                this.rows.add(n2, defaultKeyedValues);
            } else {
                this.rowKeys.add(comparable);
                this.rows.add(defaultKeyedValues);
            }
        }
        defaultKeyedValues.setValue(comparable2, number);
        int n3 = this.columnKeys.indexOf(comparable2);
        if (n3 < 0) {
            this.columnKeys.add(comparable2);
        }
    }

    public void removeValue(Comparable comparable, Comparable comparable2) {
        int n2;
        int n3;
        this.setValue(null, comparable, comparable2);
        boolean bl2 = true;
        int n4 = this.getRowIndex(comparable);
        DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n4);
        int n5 = defaultKeyedValues.getItemCount();
        for (n3 = 0; n3 < n5; ++n3) {
            if (defaultKeyedValues.getValue(n3) == null) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            this.rowKeys.remove(n4);
            this.rows.remove(n4);
        }
        bl2 = true;
        n5 = this.rows.size();
        for (n3 = 0; n3 < n5; ++n3) {
            defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n3);
            n2 = defaultKeyedValues.getIndex(comparable2);
            if (n2 < 0 || defaultKeyedValues.getValue(n2) == null) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            n5 = this.rows.size();
            for (n3 = 0; n3 < n5; ++n3) {
                defaultKeyedValues = (DefaultKeyedValues)this.rows.get(n3);
                n2 = defaultKeyedValues.getIndex(comparable2);
                if (n2 < 0) continue;
                defaultKeyedValues.removeValue(n2);
            }
            this.columnKeys.remove(comparable2);
        }
    }

    public void removeRow(int n2) {
        this.rowKeys.remove(n2);
        this.rows.remove(n2);
    }

    public void removeRow(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "rowKey");
        int n2 = this.getRowIndex(comparable);
        if (n2 < 0) {
            throw new UnknownKeyException("Unknown key: " + comparable);
        }
        this.removeRow(n2);
    }

    public void removeColumn(int n2) {
        Comparable comparable = this.getColumnKey(n2);
        this.removeColumn(comparable);
    }

    public void removeColumn(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "columnKey");
        if (!this.columnKeys.contains(comparable)) {
            throw new UnknownKeyException("Unknown key: " + comparable);
        }
        for (DefaultKeyedValues defaultKeyedValues : this.rows) {
            int n2 = defaultKeyedValues.getIndex(comparable);
            if (n2 < 0) continue;
            defaultKeyedValues.removeValue(comparable);
        }
        this.columnKeys.remove(comparable);
    }

    public void clear() {
        this.rowKeys.clear();
        this.columnKeys.clear();
        this.rows.clear();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedValues2D)) {
            return false;
        }
        KeyedValues2D keyedValues2D = (KeyedValues2D)object;
        if (!this.getRowKeys().equals(keyedValues2D.getRowKeys())) {
            return false;
        }
        if (!this.getColumnKeys().equals(keyedValues2D.getColumnKeys())) {
            return false;
        }
        int n2 = this.getRowCount();
        if (n2 != keyedValues2D.getRowCount()) {
            return false;
        }
        int n3 = this.getColumnCount();
        if (n3 != keyedValues2D.getColumnCount()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                Number number = this.getValue(i2, i3);
                Number number2 = keyedValues2D.getValue(i2, i3);
                if (!(number == null ? number2 != null : !number.equals(number2))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int n2 = this.rowKeys.hashCode();
        n2 = 29 * n2 + this.columnKeys.hashCode();
        n2 = 29 * n2 + this.rows.hashCode();
        return n2;
    }

    @Override
    public Object clone() {
        DefaultKeyedValues2D defaultKeyedValues2D = (DefaultKeyedValues2D)super.clone();
        defaultKeyedValues2D.columnKeys = new ArrayList(this.columnKeys);
        defaultKeyedValues2D.rowKeys = new ArrayList(this.rowKeys);
        defaultKeyedValues2D.rows = (List)ObjectUtilities.deepClone(this.rows);
        return defaultKeyedValues2D;
    }
}

