/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DefaultKeyedValue;
import org.jfree.data.KeyedValueComparator;
import org.jfree.data.KeyedValueComparatorType;
import org.jfree.data.KeyedValues;
import org.jfree.data.UnknownKeyException;
import org.jfree.util.PublicCloneable;
import org.jfree.util.SortOrder;

public class DefaultKeyedValues
implements Serializable,
Cloneable,
KeyedValues,
PublicCloneable {
    private static final long serialVersionUID = 8468154364608194797L;
    private ArrayList keys = new ArrayList();
    private ArrayList values = new ArrayList();
    private HashMap indexMap = new HashMap();

    @Override
    public int getItemCount() {
        return this.indexMap.size();
    }

    @Override
    public Number getValue(int n2) {
        return (Number)this.values.get(n2);
    }

    @Override
    public Comparable getKey(int n2) {
        return (Comparable)this.keys.get(n2);
    }

    @Override
    public int getIndex(Comparable comparable) {
        ParamChecks.nullNotPermitted(comparable, "key");
        Integer n2 = (Integer)this.indexMap.get(comparable);
        if (n2 == null) {
            return -1;
        }
        return n2;
    }

    @Override
    public List getKeys() {
        return (List)this.keys.clone();
    }

    @Override
    public Number getValue(Comparable comparable) {
        int n2 = this.getIndex(comparable);
        if (n2 < 0) {
            throw new UnknownKeyException("Key not found: " + comparable);
        }
        return this.getValue(n2);
    }

    public void addValue(Comparable comparable, double d2) {
        this.addValue(comparable, new Double(d2));
    }

    public void addValue(Comparable comparable, Number number) {
        this.setValue(comparable, number);
    }

    public void setValue(Comparable comparable, double d2) {
        this.setValue(comparable, new Double(d2));
    }

    public void setValue(Comparable comparable, Number number) {
        ParamChecks.nullNotPermitted(comparable, "key");
        int n2 = this.getIndex(comparable);
        if (n2 >= 0) {
            this.keys.set(n2, comparable);
            this.values.set(n2, number);
        } else {
            this.keys.add(comparable);
            this.values.add(number);
            this.indexMap.put(comparable, new Integer(this.keys.size() - 1));
        }
    }

    public void insertValue(int n2, Comparable comparable, double d2) {
        this.insertValue(n2, comparable, new Double(d2));
    }

    public void insertValue(int n2, Comparable comparable, Number number) {
        if (n2 < 0 || n2 > this.getItemCount()) {
            throw new IllegalArgumentException("'position' out of bounds.");
        }
        ParamChecks.nullNotPermitted(comparable, "key");
        int n3 = this.getIndex(comparable);
        if (n3 == n2) {
            this.keys.set(n3, comparable);
            this.values.set(n3, number);
        } else {
            if (n3 >= 0) {
                this.keys.remove(n3);
                this.values.remove(n3);
            }
            this.keys.add(n2, comparable);
            this.values.add(n2, number);
            this.rebuildIndex();
        }
    }

    private void rebuildIndex() {
        this.indexMap.clear();
        for (int i2 = 0; i2 < this.keys.size(); ++i2) {
            Object e2 = this.keys.get(i2);
            this.indexMap.put(e2, new Integer(i2));
        }
    }

    public void removeValue(int n2) {
        this.keys.remove(n2);
        this.values.remove(n2);
        this.rebuildIndex();
    }

    public void removeValue(Comparable comparable) {
        int n2 = this.getIndex(comparable);
        if (n2 < 0) {
            throw new UnknownKeyException("The key (" + comparable + ") is not recognised.");
        }
        this.removeValue(n2);
    }

    public void clear() {
        this.keys.clear();
        this.values.clear();
        this.indexMap.clear();
    }

    public void sortByKeys(SortOrder sortOrder) {
        int n2 = this.keys.size();
        DefaultKeyedValue[] defaultKeyedValueArray = new DefaultKeyedValue[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            defaultKeyedValueArray[i2] = new DefaultKeyedValue((Comparable)this.keys.get(i2), (Number)this.values.get(i2));
        }
        KeyedValueComparator keyedValueComparator = new KeyedValueComparator(KeyedValueComparatorType.BY_KEY, sortOrder);
        Arrays.sort(defaultKeyedValueArray, keyedValueComparator);
        this.clear();
        for (int i3 = 0; i3 < defaultKeyedValueArray.length; ++i3) {
            DefaultKeyedValue defaultKeyedValue = defaultKeyedValueArray[i3];
            this.addValue(defaultKeyedValue.getKey(), defaultKeyedValue.getValue());
        }
    }

    public void sortByValues(SortOrder sortOrder) {
        int n2 = this.keys.size();
        DefaultKeyedValue[] defaultKeyedValueArray = new DefaultKeyedValue[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            defaultKeyedValueArray[i2] = new DefaultKeyedValue((Comparable)this.keys.get(i2), (Number)this.values.get(i2));
        }
        KeyedValueComparator keyedValueComparator = new KeyedValueComparator(KeyedValueComparatorType.BY_VALUE, sortOrder);
        Arrays.sort(defaultKeyedValueArray, keyedValueComparator);
        this.clear();
        for (int i3 = 0; i3 < defaultKeyedValueArray.length; ++i3) {
            DefaultKeyedValue defaultKeyedValue = defaultKeyedValueArray[i3];
            this.addValue(defaultKeyedValue.getKey(), defaultKeyedValue.getValue());
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof KeyedValues)) {
            return false;
        }
        KeyedValues keyedValues = (KeyedValues)object;
        int n2 = this.getItemCount();
        if (n2 != keyedValues.getItemCount()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Comparable comparable;
            Comparable comparable2 = this.getKey(i2);
            if (!comparable2.equals(comparable = keyedValues.getKey(i2))) {
                return false;
            }
            Number number = this.getValue(i2);
            Number number2 = keyedValues.getValue(i2);
            if (!(number == null ? number2 != null : !number.equals(number2))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.keys != null ? this.keys.hashCode() : 0;
    }

    @Override
    public Object clone() {
        DefaultKeyedValues defaultKeyedValues = (DefaultKeyedValues)super.clone();
        defaultKeyedValues.keys = (ArrayList)this.keys.clone();
        defaultKeyedValues.values = (ArrayList)this.values.clone();
        defaultKeyedValues.indexMap = (HashMap)this.indexMap.clone();
        return defaultKeyedValues;
    }
}

