/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.util.Arrays;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.Values2D;

public abstract class DataUtilities {
    public static boolean equal(double[][] dArray, double[][] dArray2) {
        if (dArray == null) {
            return dArray2 == null;
        }
        if (dArray2 == null) {
            return false;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (Arrays.equals(dArray[i2], dArray2[i2])) continue;
            return false;
        }
        return true;
    }

    public static double[][] clone(double[][] dArray) {
        ParamChecks.nullNotPermitted(dArray, "source");
        double[][] dArrayArray = new double[dArray.length][];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            if (dArray[i2] == null) continue;
            double[] dArray2 = new double[dArray[i2].length];
            System.arraycopy(dArray[i2], 0, dArray2, 0, dArray[i2].length);
            dArrayArray[i2] = dArray2;
        }
        return dArrayArray;
    }

    public static double calculateColumnTotal(Values2D values2D, int n2) {
        ParamChecks.nullNotPermitted(values2D, "data");
        double d2 = 0.0;
        int n3 = values2D.getRowCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            Number number = values2D.getValue(i2, n2);
            if (number == null) continue;
            d2 += number.doubleValue();
        }
        return d2;
    }

    public static double calculateColumnTotal(Values2D values2D, int n2, int[] nArray) {
        ParamChecks.nullNotPermitted(values2D, "data");
        double d2 = 0.0;
        int n3 = values2D.getRowCount();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Number number;
            int n4 = nArray[i2];
            if (n4 >= n3 || (number = values2D.getValue(n4, n2)) == null) continue;
            d2 += number.doubleValue();
        }
        return d2;
    }

    public static double calculateRowTotal(Values2D values2D, int n2) {
        ParamChecks.nullNotPermitted(values2D, "data");
        double d2 = 0.0;
        int n3 = values2D.getColumnCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            Number number = values2D.getValue(n2, i2);
            if (number == null) continue;
            d2 += number.doubleValue();
        }
        return d2;
    }

    public static double calculateRowTotal(Values2D values2D, int n2, int[] nArray) {
        ParamChecks.nullNotPermitted(values2D, "data");
        double d2 = 0.0;
        int n3 = values2D.getColumnCount();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            Number number;
            int n4 = nArray[i2];
            if (n4 >= n3 || (number = values2D.getValue(n2, n4)) == null) continue;
            d2 += number.doubleValue();
        }
        return d2;
    }

    public static Number[] createNumberArray(double[] dArray) {
        ParamChecks.nullNotPermitted(dArray, "data");
        Number[] numberArray = new Number[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            numberArray[i2] = new Double(dArray[i2]);
        }
        return numberArray;
    }

    public static Number[][] createNumberArray2D(double[][] dArray) {
        ParamChecks.nullNotPermitted(dArray, "data");
        int n2 = dArray.length;
        Number[][] numberArray = new Number[n2][];
        for (int i2 = 0; i2 < n2; ++i2) {
            numberArray[i2] = DataUtilities.createNumberArray(dArray[i2]);
        }
        return numberArray;
    }

    public static KeyedValues getCumulativePercentages(KeyedValues keyedValues) {
        ParamChecks.nullNotPermitted(keyedValues, "data");
        DefaultKeyedValues defaultKeyedValues = new DefaultKeyedValues();
        double d2 = 0.0;
        for (int i2 = 0; i2 < keyedValues.getItemCount(); ++i2) {
            Number number = keyedValues.getValue(i2);
            if (number == null) continue;
            d2 += number.doubleValue();
        }
        double d3 = 0.0;
        for (int i3 = 0; i3 < keyedValues.getItemCount(); ++i3) {
            Number number = keyedValues.getValue(i3);
            if (number != null) {
                d3 += number.doubleValue();
            }
            defaultKeyedValues.addValue(keyedValues.getKey(i3), new Double(d3 / d2));
        }
        return defaultKeyedValues;
    }
}

