/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.ComparableObjectItem;
import org.jfree.data.general.Series;
import org.jfree.data.general.SeriesException;
import org.jfree.util.ObjectUtilities;

public class ComparableObjectSeries
extends Series
implements Serializable,
Cloneable {
    protected List data;
    private int maximumItemCount = Integer.MAX_VALUE;
    private boolean autoSort;
    private boolean allowDuplicateXValues;

    public ComparableObjectSeries(Comparable comparable) {
        this(comparable, true, true);
    }

    public ComparableObjectSeries(Comparable comparable, boolean bl2, boolean bl3) {
        super(comparable);
        this.data = new ArrayList();
        this.autoSort = bl2;
        this.allowDuplicateXValues = bl3;
    }

    public boolean getAutoSort() {
        return this.autoSort;
    }

    public boolean getAllowDuplicateXValues() {
        return this.allowDuplicateXValues;
    }

    @Override
    public int getItemCount() {
        return this.data.size();
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n2) {
        this.maximumItemCount = n2;
        boolean bl2 = false;
        while (this.data.size() > n2) {
            this.data.remove(0);
            bl2 = true;
        }
        if (bl2) {
            this.fireSeriesChanged();
        }
    }

    protected void add(Comparable comparable, Object object) {
        this.add(comparable, object, true);
    }

    protected void add(Comparable comparable, Object object, boolean bl2) {
        ComparableObjectItem comparableObjectItem = new ComparableObjectItem(comparable, object);
        this.add(comparableObjectItem, bl2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void add(ComparableObjectItem comparableObjectItem, boolean bl2) {
        ParamChecks.nullNotPermitted(comparableObjectItem, "item");
        if (this.autoSort) {
            int n2 = Collections.binarySearch(this.data, comparableObjectItem);
            if (n2 < 0) {
                this.data.add(-n2 - 1, comparableObjectItem);
            } else {
                if (!this.allowDuplicateXValues) throw new SeriesException("X-value already exists.");
                int n3 = this.data.size();
                while (n2 < n3 && comparableObjectItem.compareTo(this.data.get(n2)) == 0) {
                    ++n2;
                }
                if (n2 < this.data.size()) {
                    this.data.add(n2, comparableObjectItem);
                } else {
                    this.data.add(comparableObjectItem);
                }
            }
        } else {
            int n4;
            if (!this.allowDuplicateXValues && (n4 = this.indexOf(comparableObjectItem.getComparable())) >= 0) {
                throw new SeriesException("X-value already exists.");
            }
            this.data.add(comparableObjectItem);
        }
        if (this.getItemCount() > this.maximumItemCount) {
            this.data.remove(0);
        }
        if (!bl2) return;
        this.fireSeriesChanged();
    }

    public int indexOf(Comparable comparable) {
        if (this.autoSort) {
            return Collections.binarySearch(this.data, new ComparableObjectItem(comparable, null));
        }
        for (int i2 = 0; i2 < this.data.size(); ++i2) {
            ComparableObjectItem comparableObjectItem = (ComparableObjectItem)this.data.get(i2);
            if (!comparableObjectItem.getComparable().equals(comparable)) continue;
            return i2;
        }
        return -1;
    }

    protected void update(Comparable comparable, Object object) {
        int n2 = this.indexOf(comparable);
        if (n2 < 0) {
            throw new SeriesException("No observation for x = " + comparable);
        }
        ComparableObjectItem comparableObjectItem = this.getDataItem(n2);
        comparableObjectItem.setObject(object);
        this.fireSeriesChanged();
    }

    protected void updateByIndex(int n2, Object object) {
        ComparableObjectItem comparableObjectItem = this.getDataItem(n2);
        comparableObjectItem.setObject(object);
        this.fireSeriesChanged();
    }

    protected ComparableObjectItem getDataItem(int n2) {
        return (ComparableObjectItem)this.data.get(n2);
    }

    protected void delete(int n2, int n3) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.data.remove(n2);
        }
        this.fireSeriesChanged();
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.fireSeriesChanged();
        }
    }

    protected ComparableObjectItem remove(int n2) {
        ComparableObjectItem comparableObjectItem = (ComparableObjectItem)this.data.remove(n2);
        this.fireSeriesChanged();
        return comparableObjectItem;
    }

    public ComparableObjectItem remove(Comparable comparable) {
        return this.remove(this.indexOf(comparable));
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ComparableObjectSeries)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ComparableObjectSeries comparableObjectSeries = (ComparableObjectSeries)object;
        if (this.maximumItemCount != comparableObjectSeries.maximumItemCount) {
            return false;
        }
        if (this.autoSort != comparableObjectSeries.autoSort) {
            return false;
        }
        if (this.allowDuplicateXValues != comparableObjectSeries.allowDuplicateXValues) {
            return false;
        }
        return ObjectUtilities.equal(this.data, comparableObjectSeries.data);
    }

    @Override
    public int hashCode() {
        ComparableObjectItem comparableObjectItem;
        int n2 = super.hashCode();
        int n3 = this.getItemCount();
        if (n3 > 0) {
            comparableObjectItem = this.getDataItem(0);
            n2 = 29 * n2 + comparableObjectItem.hashCode();
        }
        if (n3 > 1) {
            comparableObjectItem = this.getDataItem(n3 - 1);
            n2 = 29 * n2 + comparableObjectItem.hashCode();
        }
        if (n3 > 2) {
            comparableObjectItem = this.getDataItem(n3 / 2);
            n2 = 29 * n2 + comparableObjectItem.hashCode();
        }
        n2 = 29 * n2 + this.maximumItemCount;
        n2 = 29 * n2 + (this.autoSort ? 1 : 0);
        n2 = 29 * n2 + (this.allowDuplicateXValues ? 1 : 0);
        return n2;
    }
}

