/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.jfree.chart.util.ParamChecks;
import org.jfree.ui.TextAnchor;

public class TextUtils {
    public static Rectangle2D drawAlignedString(String string, Graphics2D graphics2D, float f2, float f3, TextAnchor textAnchor) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        float[] fArray = TextUtils.deriveTextBoundsAnchorOffsets(graphics2D, string, textAnchor, double_);
        ((Rectangle2D)double_).setRect(f2 + fArray[0], f3 + fArray[1] + fArray[2], ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight());
        graphics2D.drawString(string, f2 + fArray[0], f3 + fArray[1]);
        return double_;
    }

    public static Rectangle2D calcAlignedStringBounds(String string, Graphics2D graphics2D, float f2, float f3, TextAnchor textAnchor) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        float[] fArray = TextUtils.deriveTextBoundsAnchorOffsets(graphics2D, string, textAnchor, double_);
        ((Rectangle2D)double_).setRect(f2 + fArray[0], f3 + fArray[1] + fArray[2], ((RectangularShape)double_).getWidth(), ((RectangularShape)double_).getHeight());
        return double_;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D graphics2D, String string, TextAnchor textAnchor) {
        float[] fArray = new float[2];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        Rectangle2D rectangle2D = TextUtils.getTextBounds(string, fontMetrics);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        float f2 = lineMetrics.getAscent();
        float f3 = f2 / 2.0f;
        float f4 = lineMetrics.getDescent();
        float f5 = lineMetrics.getLeading();
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (textAnchor.isHorizontalCenter()) {
            f6 = (float)(-rectangle2D.getWidth()) / 2.0f;
        } else if (textAnchor.isRight()) {
            f6 = (float)(-rectangle2D.getWidth());
        }
        if (textAnchor.isTop()) {
            f7 = -f4 - f5 + (float)rectangle2D.getHeight();
        } else if (textAnchor.isHalfAscent()) {
            f7 = f3;
        } else if (textAnchor.isVerticalCenter()) {
            f7 = -f4 - f5 + (float)(rectangle2D.getHeight() / 2.0);
        } else if (textAnchor.isBaseline()) {
            f7 = 0.0f;
        } else if (textAnchor.isBottom()) {
            f7 = -lineMetrics.getDescent() - lineMetrics.getLeading();
        }
        fArray[0] = f6;
        fArray[1] = f7;
        return fArray;
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D graphics2D, String string, TextAnchor textAnchor, Rectangle2D rectangle2D) {
        float[] fArray = new float[3];
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = graphics2D.getFont();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        Rectangle2D rectangle2D2 = TextUtils.getTextBounds(string, fontMetrics);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        float f2 = lineMetrics.getAscent();
        fArray[2] = -f2;
        float f3 = f2 / 2.0f;
        float f4 = lineMetrics.getDescent();
        float f5 = lineMetrics.getLeading();
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (textAnchor.isHorizontalCenter()) {
            f6 = (float)(-rectangle2D2.getWidth()) / 2.0f;
        } else if (textAnchor.isRight()) {
            f6 = (float)(-rectangle2D2.getWidth());
        }
        if (textAnchor.isTop()) {
            f7 = -f4 - f5 + (float)rectangle2D2.getHeight();
        } else if (textAnchor.isHalfAscent()) {
            f7 = f3;
        } else if (textAnchor.isHorizontalCenter()) {
            f7 = -f4 - f5 + (float)(rectangle2D2.getHeight() / 2.0);
        } else if (textAnchor.isBaseline()) {
            f7 = 0.0f;
        } else if (textAnchor.isBottom()) {
            f7 = -lineMetrics.getDescent() - lineMetrics.getLeading();
        }
        if (rectangle2D != null) {
            rectangle2D.setRect(rectangle2D2);
        }
        fArray[0] = f6;
        fArray[1] = f7;
        return fArray;
    }

    public static Rectangle2D getTextBounds(String string, FontMetrics fontMetrics) {
        return TextUtils.getTextBounds(string, 0.0, 0.0, fontMetrics);
    }

    public static Rectangle2D getTextBounds(String string, double d2, double d3, FontMetrics fontMetrics) {
        ParamChecks.nullNotPermitted(string, "text");
        ParamChecks.nullNotPermitted(fontMetrics, "fm");
        double d4 = fontMetrics.stringWidth(string);
        double d5 = fontMetrics.getHeight();
        return new Rectangle2D.Double(d2, d3 - (double)fontMetrics.getAscent(), d4, d5);
    }
}

