/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import org.jfree.chart.util.ParamChecks;

public class RelativeDateFormat
extends DateFormat {
    private long baseMillis;
    private boolean showZeroDays;
    private boolean showZeroHours;
    private NumberFormat dayFormatter;
    private String positivePrefix;
    private String daySuffix;
    private NumberFormat hourFormatter;
    private String hourSuffix;
    private NumberFormat minuteFormatter;
    private String minuteSuffix;
    private NumberFormat secondFormatter;
    private String secondSuffix;
    private static final long MILLISECONDS_IN_ONE_HOUR = 3600000L;
    private static final long MILLISECONDS_IN_ONE_DAY = 86400000L;

    public RelativeDateFormat() {
        this(0L);
    }

    public RelativeDateFormat(Date date) {
        this(date.getTime());
    }

    public RelativeDateFormat(long l2) {
        this.baseMillis = l2;
        this.showZeroDays = false;
        this.showZeroHours = true;
        this.positivePrefix = "";
        this.dayFormatter = NumberFormat.getNumberInstance();
        this.daySuffix = "d";
        this.hourFormatter = NumberFormat.getNumberInstance();
        this.hourSuffix = "h";
        this.minuteFormatter = NumberFormat.getNumberInstance();
        this.minuteSuffix = "m";
        this.secondFormatter = NumberFormat.getNumberInstance();
        this.secondFormatter.setMaximumFractionDigits(3);
        this.secondFormatter.setMinimumFractionDigits(3);
        this.secondSuffix = "s";
        this.calendar = new GregorianCalendar();
        this.numberFormat = new DecimalFormat("0");
    }

    public long getBaseMillis() {
        return this.baseMillis;
    }

    public void setBaseMillis(long l2) {
        this.baseMillis = l2;
    }

    public boolean getShowZeroDays() {
        return this.showZeroDays;
    }

    public void setShowZeroDays(boolean bl2) {
        this.showZeroDays = bl2;
    }

    public boolean getShowZeroHours() {
        return this.showZeroHours;
    }

    public void setShowZeroHours(boolean bl2) {
        this.showZeroHours = bl2;
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        ParamChecks.nullNotPermitted(string, "prefix");
        this.positivePrefix = string;
    }

    public void setDayFormatter(NumberFormat numberFormat) {
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        this.dayFormatter = numberFormat;
    }

    public String getDaySuffix() {
        return this.daySuffix;
    }

    public void setDaySuffix(String string) {
        ParamChecks.nullNotPermitted(string, "suffix");
        this.daySuffix = string;
    }

    public void setHourFormatter(NumberFormat numberFormat) {
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        this.hourFormatter = numberFormat;
    }

    public String getHourSuffix() {
        return this.hourSuffix;
    }

    public void setHourSuffix(String string) {
        ParamChecks.nullNotPermitted(string, "suffix");
        this.hourSuffix = string;
    }

    public void setMinuteFormatter(NumberFormat numberFormat) {
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        this.minuteFormatter = numberFormat;
    }

    public String getMinuteSuffix() {
        return this.minuteSuffix;
    }

    public void setMinuteSuffix(String string) {
        ParamChecks.nullNotPermitted(string, "suffix");
        this.minuteSuffix = string;
    }

    public String getSecondSuffix() {
        return this.secondSuffix;
    }

    public void setSecondSuffix(String string) {
        ParamChecks.nullNotPermitted(string, "suffix");
        this.secondSuffix = string;
    }

    public void setSecondFormatter(NumberFormat numberFormat) {
        ParamChecks.nullNotPermitted(numberFormat, "formatter");
        this.secondFormatter = numberFormat;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        String string;
        long l2 = date.getTime();
        long l3 = l2 - this.baseMillis;
        if (l3 < 0L) {
            l3 *= -1L;
            string = "-";
        } else {
            string = this.positivePrefix;
        }
        long l4 = l3 / 86400000L;
        long l5 = (l3 -= l4 * 86400000L) / 3600000L;
        long l6 = (l3 -= l5 * 3600000L) / 60000L;
        double d2 = (double)(l3 -= l6 * 60000L) / 1000.0;
        stringBuffer.append(string);
        if (l4 != 0L || this.showZeroDays) {
            stringBuffer.append(this.dayFormatter.format(l4)).append(this.getDaySuffix());
        }
        if (l5 != 0L || this.showZeroHours) {
            stringBuffer.append(this.hourFormatter.format(l5)).append(this.getHourSuffix());
        }
        stringBuffer.append(this.minuteFormatter.format(l6)).append(this.getMinuteSuffix());
        stringBuffer.append(this.secondFormatter.format(d2)).append(this.getSecondSuffix());
        return stringBuffer;
    }

    @Override
    public Date parse(String string, ParsePosition parsePosition) {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RelativeDateFormat)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RelativeDateFormat relativeDateFormat = (RelativeDateFormat)object;
        if (this.baseMillis != relativeDateFormat.baseMillis) {
            return false;
        }
        if (this.showZeroDays != relativeDateFormat.showZeroDays) {
            return false;
        }
        if (this.showZeroHours != relativeDateFormat.showZeroHours) {
            return false;
        }
        if (!this.positivePrefix.equals(relativeDateFormat.positivePrefix)) {
            return false;
        }
        if (!this.daySuffix.equals(relativeDateFormat.daySuffix)) {
            return false;
        }
        if (!this.hourSuffix.equals(relativeDateFormat.hourSuffix)) {
            return false;
        }
        if (!this.minuteSuffix.equals(relativeDateFormat.minuteSuffix)) {
            return false;
        }
        if (!this.secondSuffix.equals(relativeDateFormat.secondSuffix)) {
            return false;
        }
        if (!this.dayFormatter.equals(relativeDateFormat.dayFormatter)) {
            return false;
        }
        if (!this.hourFormatter.equals(relativeDateFormat.hourFormatter)) {
            return false;
        }
        if (!this.minuteFormatter.equals(relativeDateFormat.minuteFormatter)) {
            return false;
        }
        return this.secondFormatter.equals(relativeDateFormat.secondFormatter);
    }

    @Override
    public int hashCode() {
        int n2 = 193;
        n2 = 37 * n2 + (int)(this.baseMillis ^ this.baseMillis >>> 32);
        n2 = 37 * n2 + this.positivePrefix.hashCode();
        n2 = 37 * n2 + this.daySuffix.hashCode();
        n2 = 37 * n2 + this.hourSuffix.hashCode();
        n2 = 37 * n2 + this.minuteSuffix.hashCode();
        n2 = 37 * n2 + this.secondSuffix.hashCode();
        n2 = 37 * n2 + this.secondFormatter.hashCode();
        return n2;
    }

    @Override
    public Object clone() {
        RelativeDateFormat relativeDateFormat = (RelativeDateFormat)super.clone();
        relativeDateFormat.dayFormatter = (NumberFormat)this.dayFormatter.clone();
        relativeDateFormat.secondFormatter = (NumberFormat)this.secondFormatter.clone();
        return relativeDateFormat;
    }
}

