/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class PaintAlpha {
    private static final double FACTOR = 0.7;
    private static boolean legacyAlpha = false;

    public static boolean setLegacyAlpha(boolean bl2) {
        boolean bl3 = legacyAlpha;
        legacyAlpha = bl2;
        return bl3;
    }

    public static Paint darker(Paint paint) {
        if (paint instanceof Color) {
            return PaintAlpha.darker((Color)paint);
        }
        if (legacyAlpha) {
            return paint;
        }
        if (paint instanceof GradientPaint) {
            return PaintAlpha.darker((GradientPaint)paint);
        }
        if (paint instanceof LinearGradientPaint) {
            return PaintAlpha.darkerLinearGradientPaint((LinearGradientPaint)paint);
        }
        if (paint instanceof RadialGradientPaint) {
            return PaintAlpha.darkerRadialGradientPaint((RadialGradientPaint)paint);
        }
        if (paint instanceof TexturePaint) {
            try {
                return PaintAlpha.darkerTexturePaint((TexturePaint)paint);
            }
            catch (Exception exception) {
                return paint;
            }
        }
        return paint;
    }

    private static Color darker(Color color) {
        return new Color((int)((double)color.getRed() * 0.7), (int)((double)color.getGreen() * 0.7), (int)((double)color.getBlue() * 0.7), color.getAlpha());
    }

    private static GradientPaint darker(GradientPaint gradientPaint) {
        return new GradientPaint(gradientPaint.getPoint1(), PaintAlpha.darker(gradientPaint.getColor1()), gradientPaint.getPoint2(), PaintAlpha.darker(gradientPaint.getColor2()), gradientPaint.isCyclic());
    }

    private static Paint darkerLinearGradientPaint(LinearGradientPaint linearGradientPaint) {
        Color[] colorArray = linearGradientPaint.getColors();
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            colorArray[i2] = PaintAlpha.darker(colorArray[i2]);
        }
        return new LinearGradientPaint(linearGradientPaint.getStartPoint(), linearGradientPaint.getEndPoint(), linearGradientPaint.getFractions(), colorArray, linearGradientPaint.getCycleMethod(), linearGradientPaint.getColorSpace(), linearGradientPaint.getTransform());
    }

    private static Paint darkerRadialGradientPaint(RadialGradientPaint radialGradientPaint) {
        Color[] colorArray = radialGradientPaint.getColors();
        for (int i2 = 0; i2 < colorArray.length; ++i2) {
            colorArray[i2] = PaintAlpha.darker(colorArray[i2]);
        }
        return new RadialGradientPaint(radialGradientPaint.getCenterPoint(), radialGradientPaint.getRadius(), radialGradientPaint.getFocusPoint(), radialGradientPaint.getFractions(), colorArray, radialGradientPaint.getCycleMethod(), radialGradientPaint.getColorSpace(), radialGradientPaint.getTransform());
    }

    private static TexturePaint darkerTexturePaint(TexturePaint texturePaint) {
        if (texturePaint.getImage().getColorModel().isAlphaPremultiplied()) {
            // empty if block
        }
        BufferedImage bufferedImage = PaintAlpha.cloneImage(texturePaint.getImage());
        WritableRaster writableRaster = bufferedImage.copyData(null);
        int n2 = writableRaster.getMinX();
        int n3 = writableRaster.getMinY();
        int n4 = writableRaster.getMinY() + writableRaster.getHeight();
        int n5 = writableRaster.getWidth();
        int[] nArray = new int[n5 * bufferedImage.getSampleModel().getNumBands()];
        if (bufferedImage.getColorModel() instanceof IndexColorModel) {
            int[] nArray2 = new int[4];
            for (int i2 = n3; i2 < n4; ++i2) {
                nArray = writableRaster.getPixels(n2, i2, n5, 1, nArray);
                for (int i3 = 0; i3 < nArray.length; ++i3) {
                    nArray2 = bufferedImage.getColorModel().getComponents(nArray[i3], nArray2, 0);
                    nArray2[0] = (int)((double)nArray2[0] * 0.7);
                    nArray2[1] = (int)((double)nArray2[1] * 0.7);
                    nArray2[2] = (int)((double)nArray2[2] * 0.7);
                    nArray[i3] = bufferedImage.getColorModel().getDataElement(nArray2, 0);
                }
                writableRaster.setPixels(n2, i2, n5, 1, nArray);
            }
            bufferedImage.setData(writableRaster);
            return new TexturePaint(bufferedImage, texturePaint.getAnchorRect());
        }
        if (bufferedImage.getSampleModel().getNumBands() == 4) {
            for (int i4 = n3; i4 < n4; ++i4) {
                nArray = writableRaster.getPixels(n2, i4, n5, 1, nArray);
                for (int i5 = 0; i5 < nArray.length; ++i5) {
                    nArray[i5] = (int)((double)nArray[i5++] * 0.7);
                    nArray[i5] = (int)((double)nArray[i5++] * 0.7);
                    nArray[i5] = (int)((double)nArray[i5++] * 0.7);
                }
                writableRaster.setPixels(n2, i4, n5, 1, nArray);
            }
            bufferedImage.setData(writableRaster);
            return new TexturePaint(bufferedImage, texturePaint.getAnchorRect());
        }
        for (int i6 = n3; i6 < n4; ++i6) {
            nArray = writableRaster.getPixels(n2, i6, n5, 1, nArray);
            for (int i7 = 0; i7 < nArray.length; ++i7) {
                nArray[i7] = (int)((double)nArray[i7] * 0.7);
            }
            writableRaster.setPixels(n2, i6, n5, 1, nArray);
        }
        bufferedImage.setData(writableRaster);
        return new TexturePaint(bufferedImage, texturePaint.getAnchorRect());
    }

    public static BufferedImage cloneImage(BufferedImage bufferedImage) {
        WritableRaster writableRaster = bufferedImage.getRaster();
        WritableRaster writableRaster2 = writableRaster.createCompatibleWritableRaster();
        writableRaster2.setRect(writableRaster);
        Hashtable<String, Object> hashtable = null;
        String[] stringArray = bufferedImage.getPropertyNames();
        if (stringArray != null) {
            hashtable = new Hashtable<String, Object>();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                hashtable.put(stringArray[i2], bufferedImage.getProperty(stringArray[i2]));
            }
        }
        return new BufferedImage(bufferedImage.getColorModel(), writableRaster2, bufferedImage.isAlphaPremultiplied(), hashtable);
    }
}

