/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import org.jfree.chart.util.ParamChecks;

public class LogFormat
extends NumberFormat {
    private double base;
    private double baseLog;
    private String baseLabel;
    private String powerLabel;
    private boolean showBase;
    private NumberFormat formatter = new DecimalFormat("0.0#");

    public LogFormat() {
        this(10.0, "10", true);
    }

    public LogFormat(double d2, String string, boolean bl2) {
        this(d2, string, "^", bl2);
    }

    public LogFormat(double d2, String string, String string2, boolean bl2) {
        ParamChecks.nullNotPermitted(string, "baseLabel");
        ParamChecks.nullNotPermitted(string2, "powerLabel");
        this.base = d2;
        this.baseLog = Math.log(this.base);
        this.baseLabel = string;
        this.showBase = bl2;
        this.powerLabel = string2;
    }

    public NumberFormat getExponentFormat() {
        return (NumberFormat)this.formatter.clone();
    }

    public void setExponentFormat(NumberFormat numberFormat) {
        ParamChecks.nullNotPermitted(numberFormat, "format");
        this.formatter = numberFormat;
    }

    private double calculateLog(double d2) {
        return Math.log(d2) / this.baseLog;
    }

    @Override
    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.showBase) {
            stringBuffer2.append(this.baseLabel);
            stringBuffer2.append(this.powerLabel);
        }
        stringBuffer2.append(this.formatter.format(this.calculateLog(d2)));
        return stringBuffer2;
    }

    @Override
    public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this.showBase) {
            stringBuffer2.append(this.baseLabel);
            stringBuffer2.append(this.powerLabel);
        }
        stringBuffer2.append(this.formatter.format(this.calculateLog(l2)));
        return stringBuffer2;
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LogFormat)) {
            return false;
        }
        LogFormat logFormat = (LogFormat)object;
        if (this.base != logFormat.base) {
            return false;
        }
        if (!this.baseLabel.equals(logFormat.baseLabel)) {
            return false;
        }
        if (this.baseLog != logFormat.baseLog) {
            return false;
        }
        if (this.showBase != logFormat.showBase) {
            return false;
        }
        if (!this.formatter.equals(logFormat.formatter)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        LogFormat logFormat = (LogFormat)super.clone();
        logFormat.formatter = (NumberFormat)this.formatter.clone();
        return logFormat;
    }
}

