/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.util.ParamChecks;

public class LineUtilities {
    public static boolean clipLine(Line2D line2D, Rectangle2D rectangle2D) {
        double d2 = line2D.getX1();
        double d3 = line2D.getY1();
        double d4 = line2D.getX2();
        double d5 = line2D.getY2();
        double d6 = rectangle2D.getMinX();
        double d7 = rectangle2D.getMaxX();
        double d8 = rectangle2D.getMinY();
        double d9 = rectangle2D.getMaxY();
        int n2 = rectangle2D.outcode(d2, d3);
        int n3 = rectangle2D.outcode(d4, d5);
        while ((n2 | n3) != 0) {
            if ((n2 & n3) != 0) {
                return false;
            }
            double d10 = d4 - d2;
            double d11 = d5 - d3;
            if (n2 != 0) {
                if ((n2 & 1) == 1 && d10 != 0.0) {
                    d3 += (d6 - d2) * d11 / d10;
                    d2 = d6;
                } else if ((n2 & 4) == 4 && d10 != 0.0) {
                    d3 += (d7 - d2) * d11 / d10;
                    d2 = d7;
                } else if ((n2 & 8) == 8 && d11 != 0.0) {
                    d2 += (d9 - d3) * d10 / d11;
                    d3 = d9;
                } else if ((n2 & 2) == 2 && d11 != 0.0) {
                    d2 += (d8 - d3) * d10 / d11;
                    d3 = d8;
                }
                n2 = rectangle2D.outcode(d2, d3);
                continue;
            }
            if (n3 == 0) continue;
            if ((n3 & 1) == 1 && d10 != 0.0) {
                d5 += (d6 - d4) * d11 / d10;
                d4 = d6;
            } else if ((n3 & 4) == 4 && d10 != 0.0) {
                d5 += (d7 - d4) * d11 / d10;
                d4 = d7;
            } else if ((n3 & 8) == 8 && d11 != 0.0) {
                d4 += (d9 - d5) * d10 / d11;
                d5 = d9;
            } else if ((n3 & 2) == 2 && d11 != 0.0) {
                d4 += (d8 - d5) * d10 / d11;
                d5 = d8;
            }
            n3 = rectangle2D.outcode(d4, d5);
        }
        line2D.setLine(d2, d3, d4, d5);
        return true;
    }

    public static Line2D extendLine(Line2D line2D, double d2, double d3) {
        ParamChecks.nullNotPermitted(line2D, "line");
        double d4 = line2D.getX1();
        double d5 = line2D.getX2();
        double d6 = d5 - d4;
        double d7 = line2D.getY1();
        double d8 = line2D.getY2();
        double d9 = d8 - d7;
        return new Line2D.Double(d4 -= d2 * d6, d7 -= d2 * d9, d5 += d3 * d6, d8 += d3 * d9);
    }
}

