/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.imageio.ImageIO;
import org.jfree.chart.util.ParamChecks;
import org.jfree.ui.Drawable;

public class ExportUtils {
    public static boolean isJFreeSVGAvailable() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("org.jfree.graphics2d.svg.SVGGraphics2D");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz != null;
    }

    public static boolean isOrsonPDFAvailable() {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.orsonpdf.PDFDocument");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz != null;
    }

    public static void writeAsSVG(Drawable drawable, int n2, int n3, File file) {
        if (!ExportUtils.isJFreeSVGAvailable()) {
            throw new IllegalStateException("JFreeSVG is not present on the classpath.");
        }
        ParamChecks.nullNotPermitted(drawable, "drawable");
        ParamChecks.nullNotPermitted(file, "file");
        try {
            Class<?> clazz = Class.forName("org.jfree.graphics2d.svg.SVGGraphics2D");
            Constructor<?> constructor = clazz.getConstructor(Integer.TYPE, Integer.TYPE);
            Graphics2D graphics2D = (Graphics2D)constructor.newInstance(n2, n3);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n2, n3);
            drawable.draw(graphics2D, double_);
            Class<?> clazz2 = Class.forName("org.jfree.graphics2d.svg.SVGUtils");
            Method method = clazz.getMethod("getSVGElement", null);
            String string = (String)method.invoke((Object)graphics2D, (Object[])null);
            Method method2 = clazz2.getMethod("writeToSVG", File.class, String.class);
            method2.invoke(clazz2, file, string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    public static final void writeAsPDF(Drawable drawable, int n2, int n3, File file) {
        if (!ExportUtils.isOrsonPDFAvailable()) {
            throw new IllegalStateException("OrsonPDF is not present on the classpath.");
        }
        ParamChecks.nullNotPermitted(drawable, "drawable");
        ParamChecks.nullNotPermitted(file, "file");
        try {
            Class<?> clazz = Class.forName("com.orsonpdf.PDFDocument");
            Object obj = clazz.newInstance();
            Method method = clazz.getMethod("createPage", Rectangle2D.class);
            Rectangle rectangle = new Rectangle(n2, n3);
            Object object = method.invoke(obj, rectangle);
            Method method2 = object.getClass().getMethod("getGraphics2D", new Class[0]);
            Graphics2D graphics2D = (Graphics2D)method2.invoke(object, new Object[0]);
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, n2, n3);
            drawable.draw(graphics2D, double_);
            Method method3 = clazz.getMethod("writeToFile", File.class);
            method3.invoke(obj, file);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAsPNG(Drawable drawable, int n2, int n3, File file) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        drawable.draw(graphics2D, new Rectangle(n2, n3));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", bufferedOutputStream);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeAsJPEG(Drawable drawable, int n2, int n3, File file) {
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        drawable.draw(graphics2D, new Rectangle(n2, n3));
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", bufferedOutputStream);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }
}

