/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.util.ParamChecks;
import org.jfree.chart.util.ShadowGenerator;

public class DefaultShadowGenerator
implements Serializable,
ShadowGenerator {
    private static final long serialVersionUID = 2732993885591386064L;
    private int shadowSize;
    private Color shadowColor;
    private float shadowOpacity;
    private double angle;
    private int distance;

    public DefaultShadowGenerator() {
        this(5, Color.black, 0.5f, 5, -0.7853981633974483);
    }

    public DefaultShadowGenerator(int n2, Color color, float f2, int n3, double d2) {
        ParamChecks.nullNotPermitted(color, "color");
        this.shadowSize = n2;
        this.shadowColor = color;
        this.shadowOpacity = f2;
        this.distance = n3;
        this.angle = d2;
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public float getShadowOpacity() {
        return this.shadowOpacity;
    }

    public int getDistance() {
        return this.distance;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public int calculateOffsetX() {
        return (int)(Math.cos(this.angle) * (double)this.distance) - this.shadowSize;
    }

    @Override
    public int calculateOffsetY() {
        return -((int)(Math.sin(this.angle) * (double)this.distance)) - this.shadowSize;
    }

    @Override
    public BufferedImage createDropShadow(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth() + this.shadowSize * 2, bufferedImage.getHeight() + this.shadowSize * 2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, this.shadowSize, this.shadowSize);
        graphics2D.dispose();
        this.applyShadow(bufferedImage2);
        return bufferedImage2;
    }

    protected void applyShadow(BufferedImage bufferedImage) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = bufferedImage.getWidth();
        int n7 = bufferedImage.getHeight();
        int n8 = this.shadowSize - 1 >> 1;
        int n9 = this.shadowSize - n8;
        int n10 = n8;
        int n11 = n6 - n9;
        int n12 = n8;
        int n13 = n7 - n9;
        int n14 = this.shadowColor.getRGB() & 0xFFFFFF;
        int[] nArray = new int[this.shadowSize];
        int[] nArray2 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
        int n15 = n9 * n6;
        float f2 = this.shadowOpacity / (float)this.shadowSize;
        int n16 = 0;
        int n17 = 0;
        while (n16 < n7) {
            n5 = 0;
            n4 = 0;
            n3 = 0;
            while (n3 < this.shadowSize) {
                nArray[n3] = n2 = nArray2[n17] >>> 24;
                n5 += n2;
                ++n3;
                ++n17;
            }
            n17 -= n9;
            n3 = n10;
            while (n3 < n11) {
                n2 = (int)((float)n5 * f2);
                nArray2[n17] = n2 << 24 | n14;
                n5 -= nArray[n4];
                nArray[n4] = n2 = nArray2[n17 + n9] >>> 24;
                n5 += n2;
                if (++n4 >= this.shadowSize) {
                    n4 -= this.shadowSize;
                }
                ++n3;
                ++n17;
            }
            n17 = ++n16 * n6;
        }
        n16 = 0;
        n17 = 0;
        while (n16 < n6) {
            n5 = 0;
            n4 = 0;
            n3 = 0;
            while (n3 < this.shadowSize) {
                nArray[n3] = n2 = nArray2[n17] >>> 24;
                n5 += n2;
                ++n3;
                n17 += n6;
            }
            n17 -= n15;
            n3 = n12;
            while (n3 < n13) {
                n2 = (int)((float)n5 * f2);
                nArray2[n17] = n2 << 24 | n14;
                n5 -= nArray[n4];
                nArray[n4] = n2 = nArray2[n17 + n15] >>> 24;
                n5 += n2;
                if (++n4 >= this.shadowSize) {
                    n4 -= this.shadowSize;
                }
                ++n3;
                n17 += n6;
            }
            n17 = ++n16;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof DefaultShadowGenerator)) {
            return false;
        }
        DefaultShadowGenerator defaultShadowGenerator = (DefaultShadowGenerator)object;
        if (this.shadowSize != defaultShadowGenerator.shadowSize) {
            return false;
        }
        if (!this.shadowColor.equals(defaultShadowGenerator.shadowColor)) {
            return false;
        }
        if (this.shadowOpacity != defaultShadowGenerator.shadowOpacity) {
            return false;
        }
        if (this.distance != defaultShadowGenerator.distance) {
            return false;
        }
        return this.angle == defaultShadowGenerator.angle;
    }

    public int hashCode() {
        int n2 = HashUtilities.hashCode(17, this.shadowSize);
        n2 = HashUtilities.hashCode(n2, this.shadowColor);
        n2 = HashUtilities.hashCode(n2, this.shadowOpacity);
        n2 = HashUtilities.hashCode(n2, this.distance);
        n2 = HashUtilities.hashCode(n2, this.angle);
        return n2;
    }
}

