/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.util.ParamChecks;
import org.jfree.util.ObjectUtilities;

public class CloneUtils {
    public static List<?> cloneList(List<?> list) {
        ParamChecks.nullNotPermitted(list, "source");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object obj : list) {
            if (obj != null) {
                try {
                    arrayList.add(ObjectUtilities.clone(obj));
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new RuntimeException(cloneNotSupportedException);
                }
            }
            arrayList.add(null);
        }
        return arrayList;
    }

    public static Map cloneMapValues(Map map) {
        ParamChecks.nullNotPermitted(map, "source");
        HashMap hashMap = new HashMap();
        for (Object k2 : map.keySet()) {
            Object v2 = map.get(k2);
            if (v2 != null) {
                try {
                    hashMap.put(k2, ObjectUtilities.clone(v2));
                    continue;
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    throw new RuntimeException(cloneNotSupportedException);
                }
            }
            hashMap.put(k2, null);
        }
        return hashMap;
    }
}

