/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.util;

import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import org.jfree.chart.util.ParamChecks;
import org.jfree.ui.TextAnchor;

public class AttrStringUtils {
    private AttrStringUtils() {
    }

    public static Rectangle2D getTextBounds(AttributedString attributedString, Graphics2D graphics2D) {
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        return textLayout.getBounds();
    }

    public static void drawRotatedString(AttributedString attributedString, Graphics2D graphics2D, double d2, float f2, float f3) {
        AttrStringUtils.drawRotatedString(attributedString, graphics2D, f2, f3, d2, f2, f3);
    }

    public static void drawRotatedString(AttributedString attributedString, Graphics2D graphics2D, float f2, float f3, double d2, float f4, float f5) {
        ParamChecks.nullNotPermitted(attributedString, "text");
        AffineTransform affineTransform = graphics2D.getTransform();
        AffineTransform affineTransform2 = AffineTransform.getRotateInstance(d2, f4, f5);
        graphics2D.transform(affineTransform2);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        textLayout.draw(graphics2D, f2, f3);
        graphics2D.setTransform(affineTransform);
    }

    public static void drawRotatedString(AttributedString attributedString, Graphics2D graphics2D, float f2, float f3, TextAnchor textAnchor, double d2, float f4, float f5) {
        ParamChecks.nullNotPermitted(attributedString, "text");
        float[] fArray = AttrStringUtils.deriveTextBoundsAnchorOffsets(graphics2D, attributedString, textAnchor, null);
        AttrStringUtils.drawRotatedString(attributedString, graphics2D, f2 + fArray[0], f3 + fArray[1], d2, f4, f5);
    }

    public static void drawRotatedString(AttributedString attributedString, Graphics2D graphics2D, float f2, float f3, TextAnchor textAnchor, double d2, TextAnchor textAnchor2) {
        ParamChecks.nullNotPermitted(attributedString, "text");
        float[] fArray = AttrStringUtils.deriveTextBoundsAnchorOffsets(graphics2D, attributedString, textAnchor, null);
        float[] fArray2 = AttrStringUtils.deriveRotationAnchorOffsets(graphics2D, attributedString, textAnchor2);
        AttrStringUtils.drawRotatedString(attributedString, graphics2D, f2 + fArray[0], f3 + fArray[1], d2, f2 + fArray[0] + fArray2[0], f3 + fArray[1] + fArray2[1]);
    }

    private static float[] deriveTextBoundsAnchorOffsets(Graphics2D graphics2D, AttributedString attributedString, TextAnchor textAnchor, Rectangle2D rectangle2D) {
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        Rectangle2D rectangle2D2 = textLayout.getBounds();
        float[] fArray = new float[3];
        float f2 = textLayout.getAscent();
        fArray[2] = -f2;
        float f3 = f2 / 2.0f;
        float f4 = textLayout.getDescent();
        float f5 = textLayout.getLeading();
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (AttrStringUtils.isHorizontalCenter(textAnchor)) {
            f6 = (float)(-rectangle2D2.getWidth()) / 2.0f;
        } else if (AttrStringUtils.isHorizontalRight(textAnchor)) {
            f6 = (float)(-rectangle2D2.getWidth());
        }
        if (AttrStringUtils.isTop(textAnchor)) {
            f7 = (float)rectangle2D2.getHeight();
        } else if (AttrStringUtils.isHalfAscent(textAnchor)) {
            f7 = f3;
        } else if (AttrStringUtils.isHalfHeight(textAnchor)) {
            f7 = -f4 - f5 + (float)(rectangle2D2.getHeight() / 2.0);
        } else if (AttrStringUtils.isBaseline(textAnchor)) {
            f7 = 0.0f;
        } else if (AttrStringUtils.isBottom(textAnchor)) {
            f7 = -f4 - f5;
        }
        if (rectangle2D != null) {
            rectangle2D.setRect(rectangle2D2);
        }
        fArray[0] = f6;
        fArray[1] = f7;
        return fArray;
    }

    private static float[] deriveRotationAnchorOffsets(Graphics2D graphics2D, AttributedString attributedString, TextAnchor textAnchor) {
        float[] fArray = new float[2];
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D.getFontRenderContext());
        Rectangle2D rectangle2D = textLayout.getBounds();
        float f2 = textLayout.getAscent();
        float f3 = f2 / 2.0f;
        float f4 = textLayout.getDescent();
        float f5 = textLayout.getLeading();
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (AttrStringUtils.isHorizontalLeft(textAnchor)) {
            f6 = 0.0f;
        } else if (AttrStringUtils.isHorizontalCenter(textAnchor)) {
            f6 = (float)rectangle2D.getWidth() / 2.0f;
        } else if (AttrStringUtils.isHorizontalRight(textAnchor)) {
            f6 = (float)rectangle2D.getWidth();
        }
        if (AttrStringUtils.isTop(textAnchor)) {
            f7 = f4 + f5 - (float)rectangle2D.getHeight();
        } else if (AttrStringUtils.isHalfHeight(textAnchor)) {
            f7 = f4 + f5 - (float)(rectangle2D.getHeight() / 2.0);
        } else if (AttrStringUtils.isHalfAscent(textAnchor)) {
            f7 = -f3;
        } else if (AttrStringUtils.isBaseline(textAnchor)) {
            f7 = 0.0f;
        } else if (AttrStringUtils.isBottom(textAnchor)) {
            f7 = f4 + f5;
        }
        fArray[0] = f6;
        fArray[1] = f7;
        return fArray;
    }

    private static boolean isTop(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.TOP_LEFT) || textAnchor.equals(TextAnchor.TOP_CENTER) || textAnchor.equals(TextAnchor.TOP_RIGHT);
    }

    private static boolean isBaseline(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.BASELINE_LEFT) || textAnchor.equals(TextAnchor.BASELINE_CENTER) || textAnchor.equals(TextAnchor.BASELINE_RIGHT);
    }

    private static boolean isHalfAscent(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.HALF_ASCENT_LEFT) || textAnchor.equals(TextAnchor.HALF_ASCENT_CENTER) || textAnchor.equals(TextAnchor.HALF_ASCENT_RIGHT);
    }

    private static boolean isHalfHeight(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.CENTER_LEFT) || textAnchor.equals(TextAnchor.CENTER) || textAnchor.equals(TextAnchor.CENTER_RIGHT);
    }

    private static boolean isBottom(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.BOTTOM_LEFT) || textAnchor.equals(TextAnchor.BOTTOM_CENTER) || textAnchor.equals(TextAnchor.BOTTOM_RIGHT);
    }

    private static boolean isHorizontalLeft(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.TOP_LEFT) || textAnchor.equals(TextAnchor.CENTER_LEFT) || textAnchor.equals(TextAnchor.HALF_ASCENT_LEFT) || textAnchor.equals(TextAnchor.BASELINE_LEFT) || textAnchor.equals(TextAnchor.BOTTOM_LEFT);
    }

    private static boolean isHorizontalCenter(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.TOP_CENTER) || textAnchor.equals(TextAnchor.CENTER) || textAnchor.equals(TextAnchor.HALF_ASCENT_CENTER) || textAnchor.equals(TextAnchor.BASELINE_CENTER) || textAnchor.equals(TextAnchor.BOTTOM_CENTER);
    }

    private static boolean isHorizontalRight(TextAnchor textAnchor) {
        return textAnchor.equals(TextAnchor.TOP_RIGHT) || textAnchor.equals(TextAnchor.CENTER_RIGHT) || textAnchor.equals(TextAnchor.HALF_ASCENT_RIGHT) || textAnchor.equals(TextAnchor.BASELINE_RIGHT) || textAnchor.equals(TextAnchor.BOTTOM_RIGHT);
    }
}

