/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Date;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;

public class TimeSeriesURLGenerator
implements Serializable,
XYURLGenerator {
    private static final long serialVersionUID = -9122773175671182445L;
    private DateFormat dateFormat = DateFormat.getInstance();
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String itemParameterName = "item";

    public TimeSeriesURLGenerator() {
    }

    public TimeSeriesURLGenerator(DateFormat dateFormat, String string, String string2, String string3) {
        ParamChecks.nullNotPermitted(dateFormat, "dateFormat");
        ParamChecks.nullNotPermitted(string, "prefix");
        ParamChecks.nullNotPermitted(string2, "seriesParameterName");
        ParamChecks.nullNotPermitted(string3, "itemParameterName");
        this.dateFormat = (DateFormat)dateFormat.clone();
        this.prefix = string;
        this.seriesParameterName = string2;
        this.itemParameterName = string3;
    }

    public DateFormat getDateFormat() {
        return (DateFormat)this.dateFormat.clone();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSeriesParameterName() {
        return this.seriesParameterName;
    }

    public String getItemParameterName() {
        return this.itemParameterName;
    }

    @Override
    public String generateURL(XYDataset xYDataset, int n2, int n3) {
        String string = this.prefix;
        boolean bl2 = !string.contains("?");
        Comparable comparable = xYDataset.getSeriesKey(n2);
        if (comparable != null) {
            string = string + (bl2 ? "?" : "&amp;");
            try {
                string = string + this.seriesParameterName + "=" + URLEncoder.encode(comparable.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
            bl2 = false;
        }
        long l2 = (long)xYDataset.getXValue(n2, n3);
        String string2 = this.dateFormat.format(new Date(l2));
        string = string + (bl2 ? "?" : "&amp;");
        try {
            string = string + this.itemParameterName + "=" + URLEncoder.encode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimeSeriesURLGenerator)) {
            return false;
        }
        TimeSeriesURLGenerator timeSeriesURLGenerator = (TimeSeriesURLGenerator)object;
        if (!this.dateFormat.equals(timeSeriesURLGenerator.dateFormat)) {
            return false;
        }
        if (!this.itemParameterName.equals(timeSeriesURLGenerator.itemParameterName)) {
            return false;
        }
        if (!this.prefix.equals(timeSeriesURLGenerator.prefix)) {
            return false;
        }
        return this.seriesParameterName.equals(timeSeriesURLGenerator.seriesParameterName);
    }
}

