/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.ObjectUtilities;

public class StandardXYURLGenerator
implements Serializable,
XYURLGenerator {
    private static final long serialVersionUID = -1771624523496595382L;
    public static final String DEFAULT_PREFIX = "index.html";
    public static final String DEFAULT_SERIES_PARAMETER = "series";
    public static final String DEFAULT_ITEM_PARAMETER = "item";
    private String prefix;
    private String seriesParameterName;
    private String itemParameterName;

    public StandardXYURLGenerator() {
        this(DEFAULT_PREFIX, DEFAULT_SERIES_PARAMETER, DEFAULT_ITEM_PARAMETER);
    }

    public StandardXYURLGenerator(String string) {
        this(string, DEFAULT_SERIES_PARAMETER, DEFAULT_ITEM_PARAMETER);
    }

    public StandardXYURLGenerator(String string, String string2, String string3) {
        ParamChecks.nullNotPermitted(string, "prefix");
        ParamChecks.nullNotPermitted(string2, "seriesParameterName");
        ParamChecks.nullNotPermitted(string3, "itemParameterName");
        this.prefix = string;
        this.seriesParameterName = string2;
        this.itemParameterName = string3;
    }

    @Override
    public String generateURL(XYDataset xYDataset, int n2, int n3) {
        String string = this.prefix;
        boolean bl2 = string.indexOf("?") == -1;
        string = string + (bl2 ? "?" : "&amp;");
        string = string + this.seriesParameterName + "=" + n2 + "&amp;" + this.itemParameterName + "=" + n3;
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardXYURLGenerator)) {
            return false;
        }
        StandardXYURLGenerator standardXYURLGenerator = (StandardXYURLGenerator)object;
        if (!ObjectUtilities.equal(standardXYURLGenerator.prefix, this.prefix)) {
            return false;
        }
        if (!ObjectUtilities.equal(standardXYURLGenerator.seriesParameterName, this.seriesParameterName)) {
            return false;
        }
        return ObjectUtilities.equal(standardXYURLGenerator.itemParameterName, this.itemParameterName);
    }
}

