/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jfree.chart.urls.PieURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.general.PieDataset;
import org.jfree.util.ObjectUtilities;

public class StandardPieURLGenerator
implements Serializable,
PieURLGenerator {
    private static final long serialVersionUID = 1626966402065883419L;
    private String prefix = "index.html";
    private String categoryParamName = "category";
    private String indexParamName = "pieIndex";

    public StandardPieURLGenerator() {
        this("index.html");
    }

    public StandardPieURLGenerator(String string) {
        this(string, "category");
    }

    public StandardPieURLGenerator(String string, String string2) {
        this(string, string2, "pieIndex");
    }

    public StandardPieURLGenerator(String string, String string2, String string3) {
        ParamChecks.nullNotPermitted(string, "prefix");
        ParamChecks.nullNotPermitted(string2, "categoryParamName");
        this.prefix = string;
        this.categoryParamName = string2;
        this.indexParamName = string3;
    }

    @Override
    public String generateURL(PieDataset pieDataset, Comparable comparable, int n2) {
        String string = this.prefix;
        try {
            string = string.contains("?") ? string + "&amp;" + this.categoryParamName + "=" + URLEncoder.encode(comparable.toString(), "UTF-8") : string + "?" + this.categoryParamName + "=" + URLEncoder.encode(comparable.toString(), "UTF-8");
            if (this.indexParamName != null) {
                string = string + "&amp;" + this.indexParamName + "=" + n2;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return string;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardPieURLGenerator)) {
            return false;
        }
        StandardPieURLGenerator standardPieURLGenerator = (StandardPieURLGenerator)object;
        if (!this.prefix.equals(standardPieURLGenerator.prefix)) {
            return false;
        }
        if (!this.categoryParamName.equals(standardPieURLGenerator.categoryParamName)) {
            return false;
        }
        return ObjectUtilities.equal(this.indexParamName, standardPieURLGenerator.indexParamName);
    }
}

