/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.urls;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.category.CategoryDataset;
import org.jfree.util.ObjectUtilities;

public class StandardCategoryURLGenerator
implements Serializable,
Cloneable,
CategoryURLGenerator {
    private static final long serialVersionUID = 2276668053074881909L;
    private String prefix = "index.html";
    private String seriesParameterName = "series";
    private String categoryParameterName = "category";

    public StandardCategoryURLGenerator() {
    }

    public StandardCategoryURLGenerator(String string) {
        ParamChecks.nullNotPermitted(string, "prefix");
        this.prefix = string;
    }

    public StandardCategoryURLGenerator(String string, String string2, String string3) {
        ParamChecks.nullNotPermitted(string, "prefix");
        ParamChecks.nullNotPermitted(string2, "seriesParameterName");
        ParamChecks.nullNotPermitted(string3, "categoryParameterName");
        this.prefix = string;
        this.seriesParameterName = string2;
        this.categoryParameterName = string3;
    }

    @Override
    public String generateURL(CategoryDataset categoryDataset, int n2, int n3) {
        String string = this.prefix;
        Comparable comparable = categoryDataset.getRowKey(n2);
        Comparable comparable2 = categoryDataset.getColumnKey(n3);
        boolean bl2 = !string.contains("?");
        string = string + (bl2 ? "?" : "&amp;");
        try {
            string = string + this.seriesParameterName + "=" + URLEncoder.encode(comparable.toString(), "UTF-8");
            string = string + "&amp;" + this.categoryParameterName + "=" + URLEncoder.encode(comparable2.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
        return string;
    }

    public Object clone() {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StandardCategoryURLGenerator)) {
            return false;
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = (StandardCategoryURLGenerator)object;
        if (!ObjectUtilities.equal(this.prefix, standardCategoryURLGenerator.prefix)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.seriesParameterName, standardCategoryURLGenerator.seriesParameterName)) {
            return false;
        }
        return ObjectUtilities.equal(this.categoryParameterName, standardCategoryURLGenerator.categoryParameterName);
    }

    public int hashCode() {
        int n2 = this.prefix != null ? this.prefix.hashCode() : 0;
        n2 = 29 * n2 + (this.seriesParameterName != null ? this.seriesParameterName.hashCode() : 0);
        n2 = 29 * n2 + (this.categoryParameterName != null ? this.categoryParameterName.hashCode() : 0);
        return n2;
    }
}

