/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.block.BlockResult;
import org.jfree.chart.block.EntityBlockParams;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.chart.entity.TitleEntity;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.title.Title;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextBlockAnchor;
import org.jfree.text.TextUtilities;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.Size2D;
import org.jfree.ui.VerticalAlignment;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class TextTitle
extends Title
implements Serializable,
Cloneable,
PublicCloneable {
    private static final long serialVersionUID = 8372008692127477443L;
    public static final Font DEFAULT_FONT = new Font("SansSerif", 1, 12);
    public static final Paint DEFAULT_TEXT_PAINT = Color.black;
    private String text;
    private Font font;
    private HorizontalAlignment textAlignment;
    private transient Paint paint;
    private transient Paint backgroundPaint;
    private String toolTipText;
    private String urlText;
    private TextBlock content;
    private boolean expandToFitSpace = false;
    private int maximumLinesToDisplay = Integer.MAX_VALUE;

    public TextTitle() {
        this("");
    }

    public TextTitle(String string) {
        this(string, DEFAULT_FONT, DEFAULT_TEXT_PAINT, Title.DEFAULT_POSITION, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_PADDING);
    }

    public TextTitle(String string, Font font) {
        this(string, font, DEFAULT_TEXT_PAINT, Title.DEFAULT_POSITION, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_PADDING);
    }

    public TextTitle(String string, Font font, Paint paint, RectangleEdge rectangleEdge, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, RectangleInsets rectangleInsets) {
        super(rectangleEdge, horizontalAlignment, verticalAlignment, rectangleInsets);
        if (string == null) {
            throw new NullPointerException("Null 'text' argument.");
        }
        if (font == null) {
            throw new NullPointerException("Null 'font' argument.");
        }
        if (paint == null) {
            throw new NullPointerException("Null 'paint' argument.");
        }
        this.text = string;
        this.font = font;
        this.paint = paint;
        this.textAlignment = horizontalAlignment;
        this.backgroundPaint = null;
        this.content = null;
        this.toolTipText = null;
        this.urlText = null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        ParamChecks.nullNotPermitted(string, "text");
        if (!this.text.equals(string)) {
            this.text = string;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public HorizontalAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(HorizontalAlignment horizontalAlignment) {
        ParamChecks.nullNotPermitted(horizontalAlignment, "alignment");
        this.textAlignment = horizontalAlignment;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        ParamChecks.nullNotPermitted(font, "font");
        if (!this.font.equals(font)) {
            this.font = font;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public void setPaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        if (!this.paint.equals(paint)) {
            this.paint = paint;
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setToolTipText(String string) {
        this.toolTipText = string;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public String getURLText() {
        return this.urlText;
    }

    public void setURLText(String string) {
        this.urlText = string;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public boolean getExpandToFitSpace() {
        return this.expandToFitSpace;
    }

    public void setExpandToFitSpace(boolean bl2) {
        this.expandToFitSpace = bl2;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public int getMaximumLinesToDisplay() {
        return this.maximumLinesToDisplay;
    }

    public void setMaximumLinesToDisplay(int n2) {
        this.maximumLinesToDisplay = n2;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    @Override
    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = this.toContentConstraint(rectangleConstraint);
        LengthConstraintType lengthConstraintType = rectangleConstraint2.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint2.getHeightConstraintType();
        Size2D size2D = null;
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                size2D = this.arrangeNN(graphics2D);
            } else {
                if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                size2D = this.arrangeRN(graphics2D, rectangleConstraint2.getWidthRange());
            } else if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                size2D = this.arrangeRR(graphics2D, rectangleConstraint2.getWidthRange(), rectangleConstraint2.getHeightRange());
            } else if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                size2D = this.arrangeFN(graphics2D, rectangleConstraint2.getWidth());
            } else {
                if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        }
        assert (size2D != null);
        return new Size2D(this.calculateTotalWidth(size2D.getWidth()), this.calculateTotalHeight(size2D.getHeight()));
    }

    protected Size2D arrangeNN(Graphics2D graphics2D) {
        Range range = new Range(0.0, 3.4028234663852886E38);
        return this.arrangeRR(graphics2D, range, range);
    }

    protected Size2D arrangeFN(Graphics2D graphics2D, double d2) {
        RectangleEdge rectangleEdge = this.getPosition();
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            float f2 = (float)d2;
            graphics2D.setFont(this.font);
            this.content = TextUtilities.createTextBlock(this.text, this.font, this.paint, f2, this.maximumLinesToDisplay, new G2TextMeasurer(graphics2D));
            this.content.setLineAlignment(this.textAlignment);
            Size2D size2D = this.content.calculateDimensions(graphics2D);
            if (this.expandToFitSpace) {
                return new Size2D(f2, size2D.getHeight());
            }
            return size2D;
        }
        if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            float f3 = Float.MAX_VALUE;
            graphics2D.setFont(this.font);
            this.content = TextUtilities.createTextBlock(this.text, this.font, this.paint, f3, this.maximumLinesToDisplay, new G2TextMeasurer(graphics2D));
            this.content.setLineAlignment(this.textAlignment);
            Size2D size2D = this.content.calculateDimensions(graphics2D);
            if (this.expandToFitSpace) {
                return new Size2D(size2D.getHeight(), f3);
            }
            return new Size2D(size2D.height, size2D.width);
        }
        throw new RuntimeException("Unrecognised exception.");
    }

    protected Size2D arrangeRN(Graphics2D graphics2D, Range range) {
        Size2D size2D = this.arrangeNN(graphics2D);
        if (range.contains(size2D.getWidth())) {
            return size2D;
        }
        double d2 = range.constrain(size2D.getWidth());
        return this.arrangeFN(graphics2D, d2);
    }

    protected Size2D arrangeRR(Graphics2D graphics2D, Range range, Range range2) {
        RectangleEdge rectangleEdge = this.getPosition();
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            float f2 = (float)range.getUpperBound();
            graphics2D.setFont(this.font);
            this.content = TextUtilities.createTextBlock(this.text, this.font, this.paint, f2, this.maximumLinesToDisplay, new G2TextMeasurer(graphics2D));
            this.content.setLineAlignment(this.textAlignment);
            Size2D size2D = this.content.calculateDimensions(graphics2D);
            if (this.expandToFitSpace) {
                return new Size2D(f2, size2D.getHeight());
            }
            return size2D;
        }
        if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            float f3 = (float)range2.getUpperBound();
            graphics2D.setFont(this.font);
            this.content = TextUtilities.createTextBlock(this.text, this.font, this.paint, f3, this.maximumLinesToDisplay, new G2TextMeasurer(graphics2D));
            this.content.setLineAlignment(this.textAlignment);
            Size2D size2D = this.content.calculateDimensions(graphics2D);
            if (this.expandToFitSpace) {
                return new Size2D(size2D.getHeight(), f3);
            }
            return new Size2D(size2D.height, size2D.width);
        }
        throw new RuntimeException("Unrecognised exception.");
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.draw(graphics2D, rectangle2D, null);
    }

    @Override
    public Object draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Object object) {
        Object object2;
        if (this.content == null) {
            return null;
        }
        rectangle2D = this.trimMargin(rectangle2D);
        this.drawBorder(graphics2D, rectangle2D);
        if (this.text.equals("")) {
            return null;
        }
        TitleEntity titleEntity = null;
        if (object instanceof EntityBlockParams && (object2 = (EntityBlockParams)object).getGenerateEntities()) {
            titleEntity = new TitleEntity(rectangle2D, this, this.toolTipText, this.urlText);
        }
        rectangle2D = this.trimBorder(rectangle2D);
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
        }
        rectangle2D = this.trimPadding(rectangle2D);
        object2 = this.getPosition();
        if (object2 == RectangleEdge.TOP || object2 == RectangleEdge.BOTTOM) {
            this.drawHorizontal(graphics2D, rectangle2D);
        } else if (object2 == RectangleEdge.LEFT || object2 == RectangleEdge.RIGHT) {
            this.drawVertical(graphics2D, rectangle2D);
        }
        BlockResult blockResult = new BlockResult();
        if (titleEntity != null) {
            StandardEntityCollection standardEntityCollection = new StandardEntityCollection();
            standardEntityCollection.add(titleEntity);
            blockResult.setEntityCollection(standardEntityCollection);
        }
        return blockResult;
    }

    protected void drawHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        graphics2D.setFont(this.font);
        graphics2D.setPaint(this.paint);
        TextBlockAnchor textBlockAnchor = null;
        float f2 = 0.0f;
        HorizontalAlignment horizontalAlignment = this.getHorizontalAlignment();
        if (horizontalAlignment == HorizontalAlignment.LEFT) {
            f2 = (float)rectangle2D2.getX();
            textBlockAnchor = TextBlockAnchor.TOP_LEFT;
        } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            f2 = (float)rectangle2D2.getMaxX();
            textBlockAnchor = TextBlockAnchor.TOP_RIGHT;
        } else if (horizontalAlignment == HorizontalAlignment.CENTER) {
            f2 = (float)rectangle2D2.getCenterX();
            textBlockAnchor = TextBlockAnchor.TOP_CENTER;
        }
        float f3 = 0.0f;
        RectangleEdge rectangleEdge = this.getPosition();
        if (rectangleEdge == RectangleEdge.TOP) {
            f3 = (float)rectangle2D2.getY();
        } else if (rectangleEdge == RectangleEdge.BOTTOM) {
            f3 = (float)rectangle2D2.getMaxY();
            if (horizontalAlignment == HorizontalAlignment.LEFT) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_LEFT;
            } else if (horizontalAlignment == HorizontalAlignment.CENTER) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_CENTER;
            } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_RIGHT;
            }
        }
        this.content.draw(graphics2D, f2, f3, textBlockAnchor);
    }

    protected void drawVertical(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        graphics2D.setFont(this.font);
        graphics2D.setPaint(this.paint);
        TextBlockAnchor textBlockAnchor = null;
        float f2 = 0.0f;
        VerticalAlignment verticalAlignment = this.getVerticalAlignment();
        if (verticalAlignment == VerticalAlignment.TOP) {
            f2 = (float)rectangle2D2.getY();
            textBlockAnchor = TextBlockAnchor.TOP_RIGHT;
        } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
            f2 = (float)rectangle2D2.getMaxY();
            textBlockAnchor = TextBlockAnchor.TOP_LEFT;
        } else if (verticalAlignment == VerticalAlignment.CENTER) {
            f2 = (float)rectangle2D2.getCenterY();
            textBlockAnchor = TextBlockAnchor.TOP_CENTER;
        }
        float f3 = 0.0f;
        RectangleEdge rectangleEdge = this.getPosition();
        if (rectangleEdge == RectangleEdge.LEFT) {
            f3 = (float)rectangle2D2.getX();
        } else if (rectangleEdge == RectangleEdge.RIGHT) {
            f3 = (float)rectangle2D2.getMaxX();
            if (verticalAlignment == VerticalAlignment.TOP) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_RIGHT;
            } else if (verticalAlignment == VerticalAlignment.CENTER) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_CENTER;
            } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
                textBlockAnchor = TextBlockAnchor.BOTTOM_LEFT;
            }
        }
        this.content.draw(graphics2D, f3, f2, textBlockAnchor, f3, f2, -1.5707963267948966);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextTitle)) {
            return false;
        }
        TextTitle textTitle = (TextTitle)object;
        if (!ObjectUtilities.equal(this.text, textTitle.text)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.font, textTitle.font)) {
            return false;
        }
        if (!PaintUtilities.equal(this.paint, textTitle.paint)) {
            return false;
        }
        if (this.textAlignment != textTitle.textAlignment) {
            return false;
        }
        if (!PaintUtilities.equal(this.backgroundPaint, textTitle.backgroundPaint)) {
            return false;
        }
        if (this.maximumLinesToDisplay != textTitle.maximumLinesToDisplay) {
            return false;
        }
        if (this.expandToFitSpace != textTitle.expandToFitSpace) {
            return false;
        }
        if (!ObjectUtilities.equal(this.toolTipText, textTitle.toolTipText)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.urlText, textTitle.urlText)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n2 = super.hashCode();
        n2 = 29 * n2 + (this.text != null ? this.text.hashCode() : 0);
        n2 = 29 * n2 + (this.font != null ? this.font.hashCode() : 0);
        n2 = 29 * n2 + (this.paint != null ? this.paint.hashCode() : 0);
        n2 = 29 * n2 + (this.backgroundPaint != null ? this.backgroundPaint.hashCode() : 0);
        return n2;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.paint, objectOutputStream);
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.paint = SerialUtilities.readPaint(objectInputStream);
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

