/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.block.LengthConstraintType;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.event.AxisChangeListener;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.title.Title;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;

public class PaintScaleLegend
extends Title
implements AxisChangeListener,
PublicCloneable {
    static final long serialVersionUID = -1365146490993227503L;
    private PaintScale scale;
    private ValueAxis axis;
    private AxisLocation axisLocation;
    private double axisOffset;
    private double stripWidth;
    private boolean stripOutlineVisible;
    private transient Paint stripOutlinePaint;
    private transient Stroke stripOutlineStroke;
    private transient Paint backgroundPaint;
    private int subdivisions;

    public PaintScaleLegend(PaintScale paintScale, ValueAxis valueAxis) {
        ParamChecks.nullNotPermitted(valueAxis, "axis");
        this.scale = paintScale;
        this.axis = valueAxis;
        this.axis.addChangeListener(this);
        this.axisLocation = AxisLocation.BOTTOM_OR_LEFT;
        this.axisOffset = 0.0;
        this.axis.setRange(paintScale.getLowerBound(), paintScale.getUpperBound());
        this.stripWidth = 15.0;
        this.stripOutlineVisible = true;
        this.stripOutlinePaint = Color.gray;
        this.stripOutlineStroke = new BasicStroke(0.5f);
        this.backgroundPaint = Color.white;
        this.subdivisions = 100;
    }

    public PaintScale getScale() {
        return this.scale;
    }

    public void setScale(PaintScale paintScale) {
        ParamChecks.nullNotPermitted(paintScale, "scale");
        this.scale = paintScale;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public ValueAxis getAxis() {
        return this.axis;
    }

    public void setAxis(ValueAxis valueAxis) {
        ParamChecks.nullNotPermitted(valueAxis, "axis");
        this.axis.removeChangeListener(this);
        this.axis = valueAxis;
        this.axis.addChangeListener(this);
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public AxisLocation getAxisLocation() {
        return this.axisLocation;
    }

    public void setAxisLocation(AxisLocation axisLocation) {
        ParamChecks.nullNotPermitted(axisLocation, "location");
        this.axisLocation = axisLocation;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public double getAxisOffset() {
        return this.axisOffset;
    }

    public void setAxisOffset(double d2) {
        this.axisOffset = d2;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public double getStripWidth() {
        return this.stripWidth;
    }

    public void setStripWidth(double d2) {
        this.stripWidth = d2;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public boolean isStripOutlineVisible() {
        return this.stripOutlineVisible;
    }

    public void setStripOutlineVisible(boolean bl2) {
        this.stripOutlineVisible = bl2;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public Paint getStripOutlinePaint() {
        return this.stripOutlinePaint;
    }

    public void setStripOutlinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.stripOutlinePaint = paint;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public Stroke getStripOutlineStroke() {
        return this.stripOutlineStroke;
    }

    public void setStripOutlineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.stripOutlineStroke = stroke;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public int getSubdivisionCount() {
        return this.subdivisions;
    }

    public void setSubdivisionCount(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Requires 'count' > 0.");
        }
        this.subdivisions = n2;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    @Override
    public void axisChanged(AxisChangeEvent axisChangeEvent) {
        if (this.axis == axisChangeEvent.getAxis()) {
            this.notifyListeners(new TitleChangeEvent(this));
        }
    }

    @Override
    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        RectangleConstraint rectangleConstraint2 = this.toContentConstraint(rectangleConstraint);
        LengthConstraintType lengthConstraintType = rectangleConstraint2.getWidthConstraintType();
        LengthConstraintType lengthConstraintType2 = rectangleConstraint2.getHeightConstraintType();
        Size2D size2D = null;
        if (lengthConstraintType == LengthConstraintType.NONE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                size2D = new Size2D(this.getWidth(), this.getHeight());
            } else {
                if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                    throw new RuntimeException("Not yet implemented.");
                }
                if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                    throw new RuntimeException("Not yet implemented.");
                }
            }
        } else if (lengthConstraintType == LengthConstraintType.RANGE) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                size2D = this.arrangeRR(graphics2D, rectangleConstraint2.getWidthRange(), rectangleConstraint2.getHeightRange());
            } else if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
        } else if (lengthConstraintType == LengthConstraintType.FIXED) {
            if (lengthConstraintType2 == LengthConstraintType.NONE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.RANGE) {
                throw new RuntimeException("Not yet implemented.");
            }
            if (lengthConstraintType2 == LengthConstraintType.FIXED) {
                throw new RuntimeException("Not yet implemented.");
            }
        }
        assert (size2D != null);
        return new Size2D(this.calculateTotalWidth(size2D.getWidth()), this.calculateTotalHeight(size2D.getHeight()));
    }

    protected Size2D arrangeRR(Graphics2D graphics2D, Range range, Range range2) {
        RectangleEdge rectangleEdge = this.getPosition();
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            float f2 = (float)range.getUpperBound();
            AxisSpace axisSpace = this.axis.reserveSpace(graphics2D, null, new Rectangle2D.Double(0.0, 0.0, f2, 100.0), RectangleEdge.BOTTOM, null);
            return new Size2D(f2, this.stripWidth + this.axisOffset + axisSpace.getTop() + axisSpace.getBottom());
        }
        if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            float f3 = (float)range2.getUpperBound();
            AxisSpace axisSpace = this.axis.reserveSpace(graphics2D, null, new Rectangle2D.Double(0.0, 0.0, 100.0, f3), RectangleEdge.RIGHT, null);
            return new Size2D(this.stripWidth + this.axisOffset + axisSpace.getLeft() + axisSpace.getRight(), f3);
        }
        throw new RuntimeException("Unrecognised position.");
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.draw(graphics2D, rectangle2D, null);
    }

    @Override
    public Object draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Object object) {
        Rectangle2D rectangle2D2 = (Rectangle2D)rectangle2D.clone();
        rectangle2D2 = this.trimMargin(rectangle2D2);
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D2);
        }
        this.getFrame().draw(graphics2D, rectangle2D2);
        this.getFrame().getInsets().trim(rectangle2D2);
        rectangle2D2 = this.trimPadding(rectangle2D2);
        double d2 = this.axis.getLowerBound();
        double d3 = this.axis.getRange().getLength() / (double)this.subdivisions;
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        if (RectangleEdge.isTopOrBottom(this.getPosition())) {
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.axisLocation, PlotOrientation.HORIZONTAL);
            if (rectangleEdge == RectangleEdge.TOP) {
                for (int i2 = 0; i2 < this.subdivisions; ++i2) {
                    double d4 = d2 + (double)i2 * d3;
                    Paint paint = this.scale.getPaint(d4);
                    double d5 = this.axis.valueToJava2D(d4, rectangle2D2, RectangleEdge.TOP);
                    double d6 = this.axis.valueToJava2D(d4 + d3, rectangle2D2, RectangleEdge.TOP);
                    double d7 = Math.abs(d6 - d5) + 1.0;
                    ((Rectangle2D)double_).setRect(Math.min(d5, d6), rectangle2D2.getMaxY() - this.stripWidth, d7, this.stripWidth);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(double_);
                }
                if (this.isStripOutlineVisible()) {
                    graphics2D.setPaint(this.stripOutlinePaint);
                    graphics2D.setStroke(this.stripOutlineStroke);
                    graphics2D.draw(new Rectangle2D.Double(rectangle2D2.getMinX(), rectangle2D2.getMaxY() - this.stripWidth, rectangle2D2.getWidth(), this.stripWidth));
                }
                this.axis.draw(graphics2D, rectangle2D2.getMaxY() - this.stripWidth - this.axisOffset, rectangle2D2, rectangle2D2, RectangleEdge.TOP, null);
            } else if (rectangleEdge == RectangleEdge.BOTTOM) {
                for (int i3 = 0; i3 < this.subdivisions; ++i3) {
                    double d8 = d2 + (double)i3 * d3;
                    Paint paint = this.scale.getPaint(d8);
                    double d9 = this.axis.valueToJava2D(d8, rectangle2D2, RectangleEdge.BOTTOM);
                    double d10 = this.axis.valueToJava2D(d8 + d3, rectangle2D2, RectangleEdge.BOTTOM);
                    double d11 = Math.abs(d10 - d9) + 1.0;
                    ((Rectangle2D)double_).setRect(Math.min(d9, d10), rectangle2D2.getMinY(), d11, this.stripWidth);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(double_);
                }
                if (this.isStripOutlineVisible()) {
                    graphics2D.setPaint(this.stripOutlinePaint);
                    graphics2D.setStroke(this.stripOutlineStroke);
                    graphics2D.draw(new Rectangle2D.Double(rectangle2D2.getMinX(), rectangle2D2.getMinY(), rectangle2D2.getWidth(), this.stripWidth));
                }
                this.axis.draw(graphics2D, rectangle2D2.getMinY() + this.stripWidth + this.axisOffset, rectangle2D2, rectangle2D2, RectangleEdge.BOTTOM, null);
            }
        } else {
            RectangleEdge rectangleEdge = Plot.resolveRangeAxisLocation(this.axisLocation, PlotOrientation.VERTICAL);
            if (rectangleEdge == RectangleEdge.LEFT) {
                for (int i4 = 0; i4 < this.subdivisions; ++i4) {
                    double d12 = d2 + (double)i4 * d3;
                    Paint paint = this.scale.getPaint(d12);
                    double d13 = this.axis.valueToJava2D(d12, rectangle2D2, RectangleEdge.LEFT);
                    double d14 = this.axis.valueToJava2D(d12 + d3, rectangle2D2, RectangleEdge.LEFT);
                    double d15 = Math.abs(d14 - d13) + 1.0;
                    ((Rectangle2D)double_).setRect(rectangle2D2.getMaxX() - this.stripWidth, Math.min(d13, d14), this.stripWidth, d15);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(double_);
                }
                if (this.isStripOutlineVisible()) {
                    graphics2D.setPaint(this.stripOutlinePaint);
                    graphics2D.setStroke(this.stripOutlineStroke);
                    graphics2D.draw(new Rectangle2D.Double(rectangle2D2.getMaxX() - this.stripWidth, rectangle2D2.getMinY(), this.stripWidth, rectangle2D2.getHeight()));
                }
                this.axis.draw(graphics2D, rectangle2D2.getMaxX() - this.stripWidth - this.axisOffset, rectangle2D2, rectangle2D2, RectangleEdge.LEFT, null);
            } else if (rectangleEdge == RectangleEdge.RIGHT) {
                for (int i5 = 0; i5 < this.subdivisions; ++i5) {
                    double d16 = d2 + (double)i5 * d3;
                    Paint paint = this.scale.getPaint(d16);
                    double d17 = this.axis.valueToJava2D(d16, rectangle2D2, RectangleEdge.LEFT);
                    double d18 = this.axis.valueToJava2D(d16 + d3, rectangle2D2, RectangleEdge.LEFT);
                    double d19 = Math.abs(d18 - d17) + 1.0;
                    ((Rectangle2D)double_).setRect(rectangle2D2.getMinX(), Math.min(d17, d18), this.stripWidth, d19);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(double_);
                }
                if (this.isStripOutlineVisible()) {
                    graphics2D.setPaint(this.stripOutlinePaint);
                    graphics2D.setStroke(this.stripOutlineStroke);
                    graphics2D.draw(new Rectangle2D.Double(rectangle2D2.getMinX(), rectangle2D2.getMinY(), this.stripWidth, rectangle2D2.getHeight()));
                }
                this.axis.draw(graphics2D, rectangle2D2.getMinX() + this.stripWidth + this.axisOffset, rectangle2D2, rectangle2D2, RectangleEdge.RIGHT, null);
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof PaintScaleLegend)) {
            return false;
        }
        PaintScaleLegend paintScaleLegend = (PaintScaleLegend)object;
        if (!this.scale.equals(paintScaleLegend.scale)) {
            return false;
        }
        if (!this.axis.equals(paintScaleLegend.axis)) {
            return false;
        }
        if (!this.axisLocation.equals(paintScaleLegend.axisLocation)) {
            return false;
        }
        if (this.axisOffset != paintScaleLegend.axisOffset) {
            return false;
        }
        if (this.stripWidth != paintScaleLegend.stripWidth) {
            return false;
        }
        if (this.stripOutlineVisible != paintScaleLegend.stripOutlineVisible) {
            return false;
        }
        if (!PaintUtilities.equal(this.stripOutlinePaint, paintScaleLegend.stripOutlinePaint)) {
            return false;
        }
        if (!this.stripOutlineStroke.equals(paintScaleLegend.stripOutlineStroke)) {
            return false;
        }
        if (!PaintUtilities.equal(this.backgroundPaint, paintScaleLegend.backgroundPaint)) {
            return false;
        }
        if (this.subdivisions != paintScaleLegend.subdivisions) {
            return false;
        }
        return super.equals(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.backgroundPaint, objectOutputStream);
        SerialUtilities.writePaint(this.stripOutlinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.stripOutlineStroke, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.backgroundPaint = SerialUtilities.readPaint(objectInputStream);
        this.stripOutlinePaint = SerialUtilities.readPaint(objectInputStream);
        this.stripOutlineStroke = SerialUtilities.readStroke(objectInputStream);
    }
}

