/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.block.RectangleConstraint;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.title.Title;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.Size2D;
import org.jfree.ui.VerticalAlignment;
import org.jfree.util.ObjectUtilities;

public class ImageTitle
extends Title {
    private Image image;

    public ImageTitle(Image image) {
        this(image, image.getHeight(null), image.getWidth(null), Title.DEFAULT_POSITION, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_PADDING);
    }

    public ImageTitle(Image image, RectangleEdge rectangleEdge, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this(image, image.getHeight(null), image.getWidth(null), rectangleEdge, horizontalAlignment, verticalAlignment, Title.DEFAULT_PADDING);
    }

    public ImageTitle(Image image, int n2, int n3, RectangleEdge rectangleEdge, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, RectangleInsets rectangleInsets) {
        super(rectangleEdge, horizontalAlignment, verticalAlignment, rectangleInsets);
        if (image == null) {
            throw new NullPointerException("Null 'image' argument.");
        }
        this.image = image;
        this.setHeight(n2);
        this.setWidth(n3);
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException("Null 'image' argument.");
        }
        this.image = image;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    @Override
    public Size2D arrange(Graphics2D graphics2D, RectangleConstraint rectangleConstraint) {
        Size2D size2D = new Size2D(this.image.getWidth(null), this.image.getHeight(null));
        return new Size2D(this.calculateTotalWidth(size2D.getWidth()), this.calculateTotalHeight(size2D.getHeight()));
    }

    @Override
    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        RectangleEdge rectangleEdge = this.getPosition();
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            this.drawHorizontal(graphics2D, rectangle2D);
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            this.drawVertical(graphics2D, rectangle2D);
        } else {
            throw new RuntimeException("Invalid title position.");
        }
    }

    protected Size2D drawHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        RectangleInsets rectangleInsets = this.getPadding();
        double d4 = rectangleInsets.calculateTopOutset(d3);
        double d5 = rectangleInsets.calculateBottomOutset(d3);
        double d6 = rectangleInsets.calculateLeftOutset(d2);
        double d7 = rectangleInsets.calculateRightOutset(d2);
        double d8 = this.getPosition() == RectangleEdge.TOP ? rectangle2D.getY() + d4 : rectangle2D.getY() + rectangle2D.getHeight() - d5 - d3;
        HorizontalAlignment horizontalAlignment = this.getHorizontalAlignment();
        double d9 = 0.0;
        if (horizontalAlignment == HorizontalAlignment.CENTER) {
            d9 = rectangle2D.getX() + d6 + rectangle2D.getWidth() / 2.0 - d2 / 2.0;
        } else if (horizontalAlignment == HorizontalAlignment.LEFT) {
            d9 = rectangle2D.getX() + d6;
        } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            d9 = rectangle2D.getX() + rectangle2D.getWidth() - d7 - d2;
        }
        graphics2D.drawImage(this.image, (int)d9, (int)d8, (int)d2, (int)d3, null);
        return new Size2D(rectangle2D.getWidth() + d6 + d7, d3 + d4 + d5);
    }

    protected Size2D drawVertical(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = this.getWidth();
        double d7 = this.getHeight();
        RectangleInsets rectangleInsets = this.getPadding();
        if (rectangleInsets != null) {
            d2 = rectangleInsets.calculateTopOutset(d7);
            d3 = rectangleInsets.calculateBottomOutset(d7);
            d4 = rectangleInsets.calculateLeftOutset(d6);
            d5 = rectangleInsets.calculateRightOutset(d6);
        }
        double d8 = this.getPosition() == RectangleEdge.LEFT ? rectangle2D.getX() + d4 : rectangle2D.getMaxX() - d5 - d6;
        VerticalAlignment verticalAlignment = this.getVerticalAlignment();
        double d9 = 0.0;
        if (verticalAlignment == VerticalAlignment.CENTER) {
            d9 = rectangle2D.getMinY() + d2 + rectangle2D.getHeight() / 2.0 - d7 / 2.0;
        } else if (verticalAlignment == VerticalAlignment.TOP) {
            d9 = rectangle2D.getMinY() + d2;
        } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
            d9 = rectangle2D.getMaxY() - d3 - d7;
        }
        graphics2D.drawImage(this.image, (int)d8, (int)d9, (int)d6, (int)d7, null);
        return new Size2D(rectangle2D.getWidth() + d4 + d5, d7 + d2 + d3);
    }

    @Override
    public Object draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Object object) {
        this.draw(graphics2D, rectangle2D);
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ImageTitle)) {
            return false;
        }
        ImageTitle imageTitle = (ImageTitle)object;
        if (!ObjectUtilities.equal(this.image, imageTitle.image)) {
            return false;
        }
        return super.equals(object);
    }
}

