/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.HashUtilities;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYStepRenderer
extends XYLineAndShapeRenderer
implements Serializable,
Cloneable,
XYItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = -8918141928884796108L;
    private double stepPoint = 1.0;

    public XYStepRenderer() {
        this(null, null);
    }

    public XYStepRenderer(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.setBaseToolTipGenerator(xYToolTipGenerator);
        this.setURLGenerator(xYURLGenerator);
        this.setBaseShapesVisible(false);
    }

    public double getStepPoint() {
        return this.stepPoint;
    }

    public void setStepPoint(double d2) {
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("Requires stepPoint in [0.0;1.0]");
        }
        this.stepPoint = d2;
        this.fireChangeEvent();
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        double d2;
        double d3;
        double d4;
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        Paint paint = this.getItemPaint(n2, n3);
        Stroke stroke = this.getItemStroke(n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        double d5 = xYDataset.getXValue(n2, n3);
        double d6 = xYDataset.getYValue(n2, n3);
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d7 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
        double d8 = d4 = Double.isNaN(d6) ? Double.NaN : valueAxis2.valueToJava2D(d6, rectangle2D, rectangleEdge2);
        if (n4 == 0 && n3 > 0) {
            double d9;
            double d10;
            d3 = xYDataset.getXValue(n2, n3 - 1);
            d2 = xYDataset.getYValue(n2, n3 - 1);
            double d11 = valueAxis.valueToJava2D(d3, rectangle2D, rectangleEdge);
            double d12 = d10 = Double.isNaN(d2) ? Double.NaN : valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge2);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                if (d10 == d4) {
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d10, d11, d4, d7);
                } else {
                    d9 = d11 + this.getStepPoint() * (d7 - d11);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d10, d11, d10, d9);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d10, d9, d4, d9);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d4, d9, d4, d7);
                }
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                if (d10 == d4) {
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d11, d10, d7, d4);
                } else {
                    d9 = d11 + this.getStepPoint() * (d7 - d11);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d11, d10, d9, d10);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d9, d10, d9, d4);
                    this.drawLine(graphics2D, xYItemRendererState.workingLine, d9, d4, d7, d4);
                }
            }
            int n5 = xYPlot.getDomainAxisIndex(valueAxis);
            int n6 = xYPlot.getRangeAxisIndex(valueAxis2);
            this.updateCrosshairValues(crosshairState, d5, d6, n5, n6, d7, d4, plotOrientation);
            EntityCollection entityCollection = xYItemRendererState.getEntityCollection();
            if (entityCollection != null) {
                this.addEntity(entityCollection, null, xYDataset, n2, n3, d7, d4);
            }
        }
        if (n4 == 1 && this.isItemLabelVisible(n2, n3)) {
            d3 = d7;
            d2 = d4;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                d3 = d4;
                d2 = d7;
            }
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n2, n3, d3, d2, d6 < 0.0);
        }
    }

    private void drawLine(Graphics2D graphics2D, Line2D line2D, double d2, double d3, double d4, double d5) {
        if (Double.isNaN(d2) || Double.isNaN(d4) || Double.isNaN(d3) || Double.isNaN(d5)) {
            return;
        }
        line2D.setLine(d2, d3, d4, d5);
        graphics2D.draw(line2D);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYLineAndShapeRenderer)) {
            return false;
        }
        XYStepRenderer xYStepRenderer = (XYStepRenderer)object;
        if (this.stepPoint != xYStepRenderer.stepPoint) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return HashUtilities.hashCode(super.hashCode(), this.stepPoint);
    }

    @Override
    public Object clone() {
        return super.clone();
    }
}

