/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.util.ObjectUtilities;

public class XYSplineRenderer
extends XYLineAndShapeRenderer {
    private int precision;
    private FillType fillType;
    private GradientPaintTransformer gradientPaintTransformer;

    public XYSplineRenderer() {
        this(5, FillType.NONE);
    }

    public XYSplineRenderer(int n2) {
        this(n2, FillType.NONE);
    }

    public XYSplineRenderer(int n2, FillType fillType) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Requires precision > 0.");
        }
        ParamChecks.nullNotPermitted((Object)fillType, "fillType");
        this.precision = n2;
        this.fillType = fillType;
        this.gradientPaintTransformer = new StandardGradientPaintTransformer();
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("Requires p > 0.");
        }
        this.precision = n2;
        this.fireChangeEvent();
    }

    public FillType getFillType() {
        return this.fillType;
    }

    public void setFillType(FillType fillType) {
        this.fillType = fillType;
        this.fireChangeEvent();
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gradientPaintTransformer) {
        this.gradientPaintTransformer = gradientPaintTransformer;
        this.fireChangeEvent();
    }

    @Override
    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        this.setDrawSeriesLineAsPath(true);
        XYSplineState xYSplineState = new XYSplineState(plotRenderingInfo);
        xYSplineState.setProcessVisibleItemsOnly(false);
        return xYSplineState;
    }

    @Override
    protected void drawPrimaryLineAsPath(XYItemRendererState xYItemRendererState, Graphics2D graphics2D, XYPlot xYPlot, XYDataset xYDataset, int n2, int n3, int n4, ValueAxis valueAxis, ValueAxis valueAxis2, Rectangle2D rectangle2D) {
        Point2D.Float float_;
        XYSplineState xYSplineState = (XYSplineState)xYItemRendererState;
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d2 = xYDataset.getXValue(n3, n4);
        double d3 = xYDataset.getYValue(n3, n4);
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d5 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        if (!Double.isNaN(d4) && !Double.isNaN(d5)) {
            Point2D.Float float_2 = float_ = xYPlot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float((float)d5, (float)d4) : new Point2D.Float((float)d4, (float)d5);
            if (!xYSplineState.points.contains(float_)) {
                xYSplineState.points.add(float_);
            }
        }
        if (n4 == xYDataset.getItemCount(n3) - 1) {
            if (xYSplineState.points.size() > 1) {
                Object object;
                float f2;
                float f3;
                if (this.fillType == FillType.TO_ZERO) {
                    f3 = (float)valueAxis.valueToJava2D(0.0, rectangle2D, rectangleEdge2);
                    f2 = (float)valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge2);
                    float_ = xYPlot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(f2, f3) : new Point2D.Float(f3, f2);
                } else if (this.fillType == FillType.TO_LOWER_BOUND) {
                    f3 = (float)valueAxis.valueToJava2D(valueAxis.getLowerBound(), rectangle2D, rectangleEdge);
                    f2 = (float)valueAxis2.valueToJava2D(valueAxis2.getLowerBound(), rectangle2D, rectangleEdge2);
                    float_ = xYPlot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(f2, f3) : new Point2D.Float(f3, f2);
                } else {
                    f3 = (float)valueAxis.valueToJava2D(valueAxis.getUpperBound(), rectangle2D, rectangleEdge);
                    f2 = (float)valueAxis2.valueToJava2D(valueAxis2.getUpperBound(), rectangle2D, rectangleEdge2);
                    float_ = xYPlot.getOrientation() == PlotOrientation.HORIZONTAL ? new Point2D.Float(f2, f3) : new Point2D.Float(f3, f2);
                }
                Point2D point2D = xYSplineState.points.get(0);
                xYSplineState.seriesPath.moveTo(point2D.getX(), point2D.getY());
                if (this.fillType != FillType.NONE) {
                    if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                        xYSplineState.fillArea.moveTo(((Point2D)float_).getX(), point2D.getY());
                    } else {
                        xYSplineState.fillArea.moveTo(point2D.getX(), ((Point2D)float_).getY());
                    }
                    xYSplineState.fillArea.lineTo(point2D.getX(), point2D.getY());
                }
                if (xYSplineState.points.size() == 2) {
                    Point2D point2D2 = xYSplineState.points.get(1);
                    if (this.fillType != FillType.NONE) {
                        xYSplineState.fillArea.lineTo(point2D2.getX(), point2D2.getY());
                        xYSplineState.fillArea.lineTo(point2D2.getX(), ((Point2D)float_).getY());
                        xYSplineState.fillArea.closePath();
                    }
                    xYSplineState.seriesPath.lineTo(point2D2.getX(), point2D2.getY());
                } else {
                    int n5;
                    Object object2;
                    int n6;
                    int n7 = xYSplineState.points.size();
                    object = new float[n7];
                    float[] fArray = new float[n7];
                    float[] fArray2 = new float[n7];
                    float[] fArray3 = new float[n7];
                    for (n6 = 0; n6 < n7; ++n6) {
                        object2 = (Point2D.Float)xYSplineState.points.get(n6);
                        fArray[n6] = ((Point2D.Float)object2).x;
                        object[n6] = ((Point2D.Float)object2).y;
                    }
                    for (n6 = 1; n6 <= n7 - 1; ++n6) {
                        fArray3[n6] = fArray[n6] - fArray[n6 - 1];
                    }
                    float[] fArray4 = new float[n7 - 1];
                    object2 = new float[n7 - 1];
                    float[] fArray5 = new float[n7 - 1];
                    for (n5 = 1; n5 <= n7 - 2; ++n5) {
                        object2[n5] = (fArray3[n5] + fArray3[n5 + 1]) / 3.0f;
                        fArray5[n5] = fArray3[n5 + 1] / 6.0f;
                        fArray4[n5] = fArray3[n5] / 6.0f;
                        fArray2[n5] = (object[n5 + 1] - object[n5]) / fArray3[n5 + 1] - (object[n5] - object[n5 - 1]) / fArray3[n5];
                    }
                    this.solveTridiag(fArray4, (float[])object2, fArray5, fArray2, n7 - 2);
                    float f4 = fArray[0];
                    float f5 = object[0];
                    for (n5 = 1; n5 <= n7 - 1; ++n5) {
                        for (int i2 = 1; i2 <= this.precision; ++i2) {
                            float f6 = fArray3[n5] * (float)i2 / (float)this.precision;
                            float f7 = fArray3[n5] - f6;
                            float f8 = ((-fArray2[n5 - 1] / 6.0f * (f7 + fArray3[n5]) * f6 + object[n5 - 1]) * f7 + (-fArray2[n5] / 6.0f * (f6 + fArray3[n5]) * f7 + object[n5]) * f6) / fArray3[n5];
                            float f9 = fArray[n5 - 1] + f6;
                            xYSplineState.seriesPath.lineTo(f9, f8);
                            if (this.fillType == FillType.NONE) continue;
                            xYSplineState.fillArea.lineTo(f9, f8);
                        }
                    }
                }
                if (this.fillType != FillType.NONE) {
                    if (xYPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                        xYSplineState.fillArea.lineTo(((Point2D)float_).getX(), xYSplineState.points.get(xYSplineState.points.size() - 1).getY());
                    } else {
                        xYSplineState.fillArea.lineTo(xYSplineState.points.get(xYSplineState.points.size() - 1).getX(), ((Point2D)float_).getY());
                    }
                    xYSplineState.fillArea.closePath();
                }
                if (this.fillType != FillType.NONE) {
                    Paint paint = this.getSeriesFillPaint(n3);
                    if (this.gradientPaintTransformer != null && paint instanceof GradientPaint) {
                        object = this.gradientPaintTransformer.transform((GradientPaint)paint, xYSplineState.fillArea);
                        graphics2D.setPaint((Paint)object);
                    } else {
                        graphics2D.setPaint(paint);
                    }
                    graphics2D.fill(xYSplineState.fillArea);
                    xYSplineState.fillArea.reset();
                }
                this.drawFirstPassShape(graphics2D, n2, n3, n4, xYSplineState.seriesPath);
            }
            xYSplineState.points = new ArrayList<Point2D>();
        }
    }

    private void solveTridiag(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, int n2) {
        int n3;
        for (n3 = 2; n3 <= n2; ++n3) {
            int n4 = n3;
            fArray[n4] = fArray[n4] / fArray2[n3 - 1];
            int n5 = n3;
            fArray2[n5] = fArray2[n5] - fArray[n3] * fArray3[n3 - 1];
            int n6 = n3;
            fArray4[n6] = fArray4[n6] - fArray[n3] * fArray4[n3 - 1];
        }
        int n7 = n2;
        fArray4[n7] = fArray4[n7] / fArray2[n2];
        for (n3 = n2 - 1; n3 >= 1; --n3) {
            fArray4[n3] = (fArray4[n3] - fArray3[n3] * fArray4[n3 + 1]) / fArray2[n3];
        }
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYSplineRenderer)) {
            return false;
        }
        XYSplineRenderer xYSplineRenderer = (XYSplineRenderer)object;
        if (this.precision != xYSplineRenderer.precision) {
            return false;
        }
        if (this.fillType != xYSplineRenderer.fillType) {
            return false;
        }
        if (!ObjectUtilities.equal(this.gradientPaintTransformer, xYSplineRenderer.gradientPaintTransformer)) {
            return false;
        }
        return super.equals(object);
    }

    public static class XYSplineState
    extends XYLineAndShapeRenderer.State {
        public GeneralPath fillArea = new GeneralPath();
        public List<Point2D> points = new ArrayList<Point2D>();

        public XYSplineState(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }
    }

    public static enum FillType {
        NONE,
        TO_ZERO,
        TO_LOWER_BOUND,
        TO_UPPER_BOUND;

    }
}

