/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.LookupPaintScale;
import org.jfree.chart.renderer.PaintScale;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYShapeRenderer
extends AbstractXYItemRenderer
implements Serializable,
Cloneable,
XYItemRenderer {
    private static final long serialVersionUID = 8320552104211173221L;
    private PaintScale paintScale = new LookupPaintScale();
    private boolean drawOutlines = false;
    private boolean useOutlinePaint = true;
    private boolean useFillPaint = false;
    private boolean guideLinesVisible = false;
    private transient Paint guideLinePaint = Color.darkGray;
    private transient Stroke guideLineStroke = new BasicStroke();

    public XYShapeRenderer() {
        this.setBaseShape(new Ellipse2D.Double(-5.0, -5.0, 10.0, 10.0));
        this.setAutoPopulateSeriesShape(false);
    }

    public PaintScale getPaintScale() {
        return this.paintScale;
    }

    public void setPaintScale(PaintScale paintScale) {
        ParamChecks.nullNotPermitted(paintScale, "scale");
        this.paintScale = paintScale;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDrawOutlines() {
        return this.drawOutlines;
    }

    public void setDrawOutlines(boolean bl2) {
        this.drawOutlines = bl2;
        this.fireChangeEvent();
    }

    public boolean getUseFillPaint() {
        return this.useFillPaint;
    }

    public void setUseFillPaint(boolean bl2) {
        this.useFillPaint = bl2;
        this.fireChangeEvent();
    }

    public boolean getUseOutlinePaint() {
        return this.useOutlinePaint;
    }

    public void setUseOutlinePaint(boolean bl2) {
        this.useOutlinePaint = bl2;
        this.fireChangeEvent();
    }

    public boolean isGuideLinesVisible() {
        return this.guideLinesVisible;
    }

    public void setGuideLinesVisible(boolean bl2) {
        this.guideLinesVisible = bl2;
        this.fireChangeEvent();
    }

    public Paint getGuideLinePaint() {
        return this.guideLinePaint;
    }

    public void setGuideLinePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.guideLinePaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getGuideLineStroke() {
        return this.guideLineStroke;
    }

    public void setGuideLineStroke(Stroke stroke) {
        ParamChecks.nullNotPermitted(stroke, "stroke");
        this.guideLineStroke = stroke;
        this.fireChangeEvent();
    }

    @Override
    public Range findDomainBounds(XYDataset xYDataset) {
        if (xYDataset == null) {
            return null;
        }
        Range range = DatasetUtilities.findDomainBounds(xYDataset, false);
        if (range == null) {
            return null;
        }
        double d2 = 0.0;
        return new Range(range.getLowerBound() + d2, range.getUpperBound() + d2);
    }

    @Override
    public Range findRangeBounds(XYDataset xYDataset) {
        if (xYDataset == null) {
            return null;
        }
        Range range = DatasetUtilities.findRangeBounds(xYDataset, false);
        if (range == null) {
            return null;
        }
        double d2 = 0.0;
        return new Range(range.getLowerBound() + d2, range.getUpperBound() + d2);
    }

    public Range findZBounds(XYZDataset xYZDataset) {
        if (xYZDataset != null) {
            return DatasetUtilities.findZBounds(xYZDataset);
        }
        return null;
    }

    @Override
    public int getPassCount() {
        return 2;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        if (Double.isNaN(d2) || Double.isNaN(d3)) {
            return;
        }
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        double d5 = valueAxis2.valueToJava2D(d3, rectangle2D, xYPlot.getRangeAxisEdge());
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (n4 == 0 && this.guideLinesVisible) {
            graphics2D.setStroke(this.guideLineStroke);
            graphics2D.setPaint(this.guideLinePaint);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                graphics2D.draw(new Line2D.Double(d5, rectangle2D.getMinY(), d5, rectangle2D.getMaxY()));
                graphics2D.draw(new Line2D.Double(rectangle2D.getMinX(), d4, rectangle2D.getMaxX(), d4));
            } else {
                graphics2D.draw(new Line2D.Double(d4, rectangle2D.getMinY(), d4, rectangle2D.getMaxY()));
                graphics2D.draw(new Line2D.Double(rectangle2D.getMinX(), d5, rectangle2D.getMaxX(), d5));
            }
        } else if (n4 == 1) {
            Shape shape = this.getItemShape(n2, n3);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d5, d4);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                shape = ShapeUtilities.createTranslatedShape(shape, d4, d5);
            }
            Shape shape2 = shape;
            if (shape.intersects(rectangle2D)) {
                graphics2D.setPaint(this.getPaint(xYDataset, n2, n3));
                graphics2D.fill(shape);
                if (this.drawOutlines) {
                    if (this.getUseOutlinePaint()) {
                        graphics2D.setPaint(this.getItemOutlinePaint(n2, n3));
                    } else {
                        graphics2D.setPaint(this.getItemPaint(n2, n3));
                    }
                    graphics2D.setStroke(this.getItemOutlineStroke(n2, n3));
                    graphics2D.draw(shape);
                }
            }
            if (entityCollection != null) {
                this.addEntity(entityCollection, shape2, xYDataset, n2, n3, d4, d5);
            }
        }
    }

    protected Paint getPaint(XYDataset xYDataset, int n2, int n3) {
        Paint paint;
        if (xYDataset instanceof XYZDataset) {
            double d2 = ((XYZDataset)xYDataset).getZValue(n2, n3);
            paint = this.paintScale.getPaint(d2);
        } else {
            paint = this.useFillPaint ? this.getItemFillPaint(n2, n3) : this.getItemPaint(n2, n3);
        }
        return paint;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYShapeRenderer)) {
            return false;
        }
        XYShapeRenderer xYShapeRenderer = (XYShapeRenderer)object;
        if (!this.paintScale.equals(xYShapeRenderer.paintScale)) {
            return false;
        }
        if (this.drawOutlines != xYShapeRenderer.drawOutlines) {
            return false;
        }
        if (this.useOutlinePaint != xYShapeRenderer.useOutlinePaint) {
            return false;
        }
        if (this.useFillPaint != xYShapeRenderer.useFillPaint) {
            return false;
        }
        if (this.guideLinesVisible != xYShapeRenderer.guideLinesVisible) {
            return false;
        }
        if (!this.guideLinePaint.equals(xYShapeRenderer.guideLinePaint)) {
            return false;
        }
        if (!this.guideLineStroke.equals(xYShapeRenderer.guideLineStroke)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        XYShapeRenderer xYShapeRenderer = (XYShapeRenderer)super.clone();
        if (this.paintScale instanceof PublicCloneable) {
            PublicCloneable publicCloneable = (PublicCloneable)((Object)this.paintScale);
            xYShapeRenderer.paintScale = (PaintScale)publicCloneable.clone();
        }
        return xYShapeRenderer;
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.guideLinePaint = SerialUtilities.readPaint(objectInputStream);
        this.guideLineStroke = SerialUtilities.readStroke(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.guideLinePaint, objectOutputStream);
        SerialUtilities.writeStroke(this.guideLineStroke, objectOutputStream);
    }
}

