/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PaintUtilities;

public class XYErrorRenderer
extends XYLineAndShapeRenderer {
    static final long serialVersionUID = 5162283570955172424L;
    private boolean drawXError = true;
    private boolean drawYError = true;
    private double capLength = 4.0;
    private transient Paint errorPaint = null;
    private transient Stroke errorStroke = null;

    public XYErrorRenderer() {
        super(false, true);
    }

    public boolean getDrawXError() {
        return this.drawXError;
    }

    public void setDrawXError(boolean bl2) {
        if (this.drawXError != bl2) {
            this.drawXError = bl2;
            this.fireChangeEvent();
        }
    }

    public boolean getDrawYError() {
        return this.drawYError;
    }

    public void setDrawYError(boolean bl2) {
        if (this.drawYError != bl2) {
            this.drawYError = bl2;
            this.fireChangeEvent();
        }
    }

    public double getCapLength() {
        return this.capLength;
    }

    public void setCapLength(double d2) {
        this.capLength = d2;
        this.fireChangeEvent();
    }

    public Paint getErrorPaint() {
        return this.errorPaint;
    }

    public void setErrorPaint(Paint paint) {
        this.errorPaint = paint;
        this.fireChangeEvent();
    }

    public Stroke getErrorStroke() {
        return this.errorStroke;
    }

    public void setErrorStroke(Stroke stroke) {
        this.errorStroke = stroke;
        this.fireChangeEvent();
    }

    @Override
    public Range findDomainBounds(XYDataset xYDataset) {
        return this.findDomainBounds(xYDataset, true);
    }

    @Override
    public Range findRangeBounds(XYDataset xYDataset) {
        return this.findRangeBounds(xYDataset, true);
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        if (n4 == 0 && xYDataset instanceof IntervalXYDataset && this.getItemVisible(n2, n3)) {
            Line2D.Double double_;
            Line2D.Double double_2;
            Line2D.Double double_3;
            double d2;
            double d3;
            double d4;
            double d5;
            RectangleEdge rectangleEdge;
            double d6;
            double d7;
            double d8;
            IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (this.drawXError) {
                d8 = intervalXYDataset.getStartXValue(n2, n3);
                d7 = intervalXYDataset.getEndXValue(n2, n3);
                d6 = intervalXYDataset.getYValue(n2, n3);
                rectangleEdge = xYPlot.getDomainAxisEdge();
                d5 = valueAxis.valueToJava2D(d8, rectangle2D, rectangleEdge);
                d4 = valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge);
                d3 = valueAxis2.valueToJava2D(d6, rectangle2D, xYPlot.getRangeAxisEdge());
                d2 = this.capLength / 2.0;
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    double_3 = new Line2D.Double(d5, d3, d4, d3);
                    double_2 = new Line2D.Double(d5, d3 - d2, d5, d3 + d2);
                    double_ = new Line2D.Double(d4, d3 - d2, d4, d3 + d2);
                } else {
                    double_3 = new Line2D.Double(d3, d5, d3, d4);
                    double_2 = new Line2D.Double(d3 - d2, d5, d3 + d2, d5);
                    double_ = new Line2D.Double(d3 - d2, d4, d3 + d2, d4);
                }
                if (this.errorPaint != null) {
                    graphics2D.setPaint(this.errorPaint);
                } else {
                    graphics2D.setPaint(this.getItemPaint(n2, n3));
                }
                if (this.errorStroke != null) {
                    graphics2D.setStroke(this.errorStroke);
                } else {
                    graphics2D.setStroke(this.getItemStroke(n2, n3));
                }
                graphics2D.draw(double_3);
                graphics2D.draw(double_2);
                graphics2D.draw(double_);
            }
            if (this.drawYError) {
                d8 = intervalXYDataset.getStartYValue(n2, n3);
                d7 = intervalXYDataset.getEndYValue(n2, n3);
                d6 = intervalXYDataset.getXValue(n2, n3);
                rectangleEdge = xYPlot.getRangeAxisEdge();
                d5 = valueAxis2.valueToJava2D(d8, rectangle2D, rectangleEdge);
                d4 = valueAxis2.valueToJava2D(d7, rectangle2D, rectangleEdge);
                d3 = valueAxis.valueToJava2D(d6, rectangle2D, xYPlot.getDomainAxisEdge());
                d2 = this.capLength / 2.0;
                if (plotOrientation == PlotOrientation.VERTICAL) {
                    double_3 = new Line2D.Double(d3, d5, d3, d4);
                    double_2 = new Line2D.Double(d3 - d2, d5, d3 + d2, d5);
                    double_ = new Line2D.Double(d3 - d2, d4, d3 + d2, d4);
                } else {
                    double_3 = new Line2D.Double(d5, d3, d4, d3);
                    double_2 = new Line2D.Double(d5, d3 - d2, d5, d3 + d2);
                    double_ = new Line2D.Double(d4, d3 - d2, d4, d3 + d2);
                }
                if (this.errorPaint != null) {
                    graphics2D.setPaint(this.errorPaint);
                } else {
                    graphics2D.setPaint(this.getItemPaint(n2, n3));
                }
                if (this.errorStroke != null) {
                    graphics2D.setStroke(this.errorStroke);
                } else {
                    graphics2D.setStroke(this.getItemStroke(n2, n3));
                }
                graphics2D.draw(double_3);
                graphics2D.draw(double_2);
                graphics2D.draw(double_);
            }
        }
        super.drawItem(graphics2D, xYItemRendererState, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n2, n3, crosshairState, n4);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYErrorRenderer)) {
            return false;
        }
        XYErrorRenderer xYErrorRenderer = (XYErrorRenderer)object;
        if (this.drawXError != xYErrorRenderer.drawXError) {
            return false;
        }
        if (this.drawYError != xYErrorRenderer.drawYError) {
            return false;
        }
        if (this.capLength != xYErrorRenderer.capLength) {
            return false;
        }
        if (!PaintUtilities.equal(this.errorPaint, xYErrorRenderer.errorPaint)) {
            return false;
        }
        if (!ObjectUtilities.equal(this.errorStroke, xYErrorRenderer.errorStroke)) {
            return false;
        }
        return super.equals(object);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.errorPaint = SerialUtilities.readPaint(objectInputStream);
        this.errorStroke = SerialUtilities.readStroke(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.errorPaint, objectOutputStream);
        SerialUtilities.writeStroke(this.errorStroke, objectOutputStream);
    }
}

