/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYDotRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = -2764344339073566425L;
    private int dotWidth = 1;
    private int dotHeight = 1;
    private transient Shape legendShape = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);

    public int getDotWidth() {
        return this.dotWidth;
    }

    public void setDotWidth(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Requires w > 0.");
        }
        this.dotWidth = n2;
        this.fireChangeEvent();
    }

    public int getDotHeight() {
        return this.dotHeight;
    }

    public void setDotHeight(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Requires h > 0.");
        }
        this.dotHeight = n2;
        this.fireChangeEvent();
    }

    public Shape getLegendShape() {
        return this.legendShape;
    }

    public void setLegendShape(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "shape");
        this.legendShape = shape;
        this.fireChangeEvent();
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        if (!this.getItemVisible(n2, n3)) {
            return;
        }
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        double d4 = (double)(this.dotWidth - 1) / 2.0;
        double d5 = (double)(this.dotHeight - 1) / 2.0;
        if (!Double.isNaN(d3)) {
            RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
            double d6 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge) - d4;
            double d7 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2) - d5;
            graphics2D.setPaint(this.getItemPaint(n2, n3));
            PlotOrientation plotOrientation = xYPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                graphics2D.fillRect((int)d7, (int)d6, this.dotHeight, this.dotWidth);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                graphics2D.fillRect((int)d6, (int)d7, this.dotWidth, this.dotHeight);
            }
            int n5 = xYPlot.getDomainAxisIndex(valueAxis);
            int n6 = xYPlot.getRangeAxisIndex(valueAxis2);
            this.updateCrosshairValues(crosshairState, d2, d3, n5, n6, d6, d7, plotOrientation);
        }
    }

    @Override
    public LegendItem getLegendItem(int n2, int n3) {
        XYPlot xYPlot = this.getPlot();
        if (xYPlot == null) {
            return null;
        }
        XYDataset xYDataset = xYPlot.getDataset(n2);
        if (xYDataset == null) {
            return null;
        }
        LegendItem legendItem = null;
        if (this.getItemVisible(n3, 0)) {
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n3);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n3);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n3);
            }
            Paint paint = this.lookupSeriesPaint(n3);
            legendItem = new LegendItem(string, string2, string3, string4, this.getLegendShape(), paint);
            legendItem.setLabelFont(this.lookupLegendTextFont(n3));
            Paint paint2 = this.lookupLegendTextPaint(n3);
            if (paint2 != null) {
                legendItem.setLabelPaint(paint2);
            }
            legendItem.setSeriesKey(xYDataset.getSeriesKey(n3));
            legendItem.setSeriesIndex(n3);
            legendItem.setDataset(xYDataset);
            legendItem.setDatasetIndex(n2);
        }
        return legendItem;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYDotRenderer)) {
            return false;
        }
        XYDotRenderer xYDotRenderer = (XYDotRenderer)object;
        if (this.dotWidth != xYDotRenderer.dotWidth) {
            return false;
        }
        if (this.dotHeight != xYDotRenderer.dotHeight) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendShape, xYDotRenderer.legendShape)) {
            return false;
        }
        return super.equals(object);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.legendShape = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendShape, objectOutputStream);
    }
}

