/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.LinkedList;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.chart.util.ParamChecks;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PaintUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYDifferenceRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
PublicCloneable {
    private static final long serialVersionUID = -8447915602375584857L;
    private transient Paint positivePaint;
    private transient Paint negativePaint;
    private boolean shapesVisible;
    private transient Shape legendLine;
    private boolean roundXCoordinates;

    public XYDifferenceRenderer() {
        this(Color.green, Color.red, false);
    }

    public XYDifferenceRenderer(Paint paint, Paint paint2, boolean bl2) {
        ParamChecks.nullNotPermitted(paint, "positivePaint");
        ParamChecks.nullNotPermitted(paint2, "negativePaint");
        this.positivePaint = paint;
        this.negativePaint = paint2;
        this.shapesVisible = bl2;
        this.legendLine = new Line2D.Double(-7.0, 0.0, 7.0, 0.0);
        this.roundXCoordinates = false;
    }

    public Paint getPositivePaint() {
        return this.positivePaint;
    }

    public void setPositivePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.positivePaint = paint;
        this.fireChangeEvent();
    }

    public Paint getNegativePaint() {
        return this.negativePaint;
    }

    public void setNegativePaint(Paint paint) {
        ParamChecks.nullNotPermitted(paint, "paint");
        this.negativePaint = paint;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getShapesVisible() {
        return this.shapesVisible;
    }

    public void setShapesVisible(boolean bl2) {
        this.shapesVisible = bl2;
        this.fireChangeEvent();
    }

    public Shape getLegendLine() {
        return this.legendLine;
    }

    public void setLegendLine(Shape shape) {
        ParamChecks.nullNotPermitted(shape, "line");
        this.legendLine = shape;
        this.fireChangeEvent();
    }

    public boolean getRoundXCoordinates() {
        return this.roundXCoordinates;
    }

    public void setRoundXCoordinates(boolean bl2) {
        this.roundXCoordinates = bl2;
        this.fireChangeEvent();
    }

    @Override
    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYItemRendererState xYItemRendererState = super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, plotRenderingInfo);
        xYItemRendererState.setProcessVisibleItemsOnly(false);
        return xYItemRendererState;
    }

    @Override
    public int getPassCount() {
        return 2;
    }

    @Override
    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState, int n4) {
        if (n4 == 0) {
            this.drawItemPass0(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n2, n3, crosshairState);
        } else if (n4 == 1) {
            this.drawItemPass1(graphics2D, rectangle2D, plotRenderingInfo, xYPlot, valueAxis, valueAxis2, xYDataset, n2, n3, crosshairState);
        }
    }

    protected void drawItemPass0(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState) {
        boolean bl2;
        boolean bl3;
        if (0 != n2 || 0 != n3) {
            return;
        }
        boolean bl4 = bl3 = 1 == xYDataset.getSeriesCount();
        if (this.isEitherSeriesDegenerate(xYDataset, bl3)) {
            return;
        }
        if (!bl3 && this.areSeriesDisjoint(xYDataset)) {
            return;
        }
        LinkedList<Double> linkedList = new LinkedList<Double>();
        LinkedList<Double> linkedList2 = new LinkedList<Double>();
        LinkedList<Double> linkedList3 = new LinkedList<Double>();
        LinkedList<Double> linkedList4 = new LinkedList<Double>();
        LinkedList<Double> linkedList5 = new LinkedList<Double>();
        LinkedList<Double> linkedList6 = new LinkedList<Double>();
        int n4 = 0;
        int n5 = xYDataset.getItemCount(0);
        Double d2 = null;
        Double d3 = null;
        Double d4 = null;
        Double d5 = null;
        double d6 = Double.NEGATIVE_INFINITY;
        double d7 = Double.POSITIVE_INFINITY;
        int n6 = 0;
        int n7 = 0;
        Double d8 = null;
        Double d9 = null;
        Double d10 = null;
        Double d11 = null;
        double d12 = Double.NEGATIVE_INFINITY;
        double d13 = Double.POSITIVE_INFINITY;
        if (bl3) {
            n6 = 0;
            n7 = 2;
            d8 = new Double(xYDataset.getXValue(0, 0));
            d9 = new Double(xYDataset.getXValue(0, n5 - 1));
            d10 = new Double(0.0);
            d11 = new Double(0.0);
            d12 = 0.0;
            d13 = 0.0;
            linkedList3.add(d8);
            linkedList4.add(d10);
        } else {
            n7 = xYDataset.getItemCount(1);
        }
        boolean bl5 = false;
        boolean bl6 = true;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = true;
        boolean bl11 = false;
        boolean bl12 = false;
        boolean bl13 = false;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        double d20 = 0.0;
        double d21 = 0.0;
        boolean bl14 = false;
        while (!bl14) {
            double d22;
            d14 = xYDataset.getXValue(0, n4);
            d15 = xYDataset.getYValue(0, n4);
            d16 = xYDataset.getXValue(0, n4 + 1);
            d17 = xYDataset.getYValue(0, n4 + 1);
            d2 = new Double(d14);
            d4 = new Double(d15);
            d3 = new Double(d16);
            d5 = new Double(d17);
            if (bl3) {
                d18 = d8;
                d19 = d10;
                d20 = d9;
                d21 = d11;
            } else {
                d18 = xYDataset.getXValue(1, n6);
                d19 = xYDataset.getYValue(1, n6);
                d20 = xYDataset.getXValue(1, n6 + 1);
                d21 = xYDataset.getYValue(1, n6 + 1);
                d8 = new Double(d18);
                d10 = new Double(d19);
                d9 = new Double(d20);
                d11 = new Double(d21);
            }
            if (d16 <= d18) {
                ++n4;
                bl8 = true;
                continue;
            }
            if (d20 <= d14) {
                ++n6;
                bl12 = true;
                continue;
            }
            if (d18 < d14 && d14 < d20) {
                d22 = (d21 - d19) / (d20 - d18);
                d8 = d2;
                d10 = new Double(d22 * d14 + (d19 - d22 * d18));
                linkedList3.add(d8);
                linkedList4.add(d10);
            }
            if (d14 < d18 && d18 < d16) {
                d22 = (d17 - d15) / (d16 - d14);
                d2 = d8;
                d4 = new Double(d22 * d18 + (d15 - d22 * d14));
                linkedList.add(d2);
                linkedList2.add(d4);
            }
            d6 = d4;
            d7 = d4;
            d12 = d10;
            d13 = d10;
            bl14 = true;
        }
        while (!bl5 && !bl9) {
            double d23;
            if (!bl5 && !bl8 && bl6) {
                d14 = xYDataset.getXValue(0, n4);
                d15 = xYDataset.getYValue(0, n4);
                d2 = new Double(d14);
                d4 = new Double(d15);
                if (!bl7) {
                    linkedList.add(d2);
                    linkedList2.add(d4);
                }
                d6 = Math.max(d6, d15);
                d7 = Math.min(d7, d15);
                d16 = xYDataset.getXValue(0, n4 + 1);
                d17 = xYDataset.getYValue(0, n4 + 1);
                d3 = new Double(d16);
                d5 = new Double(d17);
            }
            if (!bl3 && !bl9 && !bl12 && bl10) {
                d18 = xYDataset.getXValue(1, n6);
                d19 = xYDataset.getYValue(1, n6);
                d8 = new Double(d18);
                d10 = new Double(d19);
                if (!bl11) {
                    linkedList3.add(d8);
                    linkedList4.add(d10);
                }
                d12 = Math.max(d12, d19);
                d13 = Math.min(d13, d19);
                d20 = xYDataset.getXValue(1, n6 + 1);
                d21 = xYDataset.getYValue(1, n6 + 1);
                d9 = new Double(d20);
                d11 = new Double(d21);
            }
            bl8 = false;
            bl12 = false;
            Double d24 = null;
            Double d25 = null;
            boolean bl15 = false;
            bl7 = false;
            bl11 = false;
            if (d16 == d20 && d17 == d21) {
                if (d14 == d18 && d15 == d19) {
                    bl13 = true;
                } else {
                    d24 = new Double(d16);
                    d25 = new Double(d17);
                    bl15 = true;
                    bl7 = true;
                    bl11 = true;
                }
            } else {
                boolean bl16;
                d23 = (d21 - d19) * (d16 - d14) - (d20 - d18) * (d17 - d15);
                double d26 = d15 - d19;
                double d27 = d14 - d18;
                double d28 = (d20 - d18) * d26 - (d21 - d19) * d27;
                double d29 = (d16 - d14) * d26 - (d17 - d15) * d27;
                if (0.0 == d28 && 0.0 == d29 && 0.0 == d23) {
                    bl13 = true;
                } else if (bl13) {
                    linkedList.clear();
                    linkedList2.clear();
                    linkedList3.clear();
                    linkedList4.clear();
                    linkedList5.clear();
                    linkedList6.clear();
                    bl13 = false;
                    boolean bl17 = d18 <= d14 && d14 <= d20;
                    linkedList5.add(bl17 ? d2 : d8);
                    linkedList6.add(bl17 ? d4 : d10);
                }
                double d30 = d28 / d23;
                double d31 = d29 / d23;
                boolean bl18 = bl16 = d14 == d16 && d18 == d20 && d16 == d20;
                if (0.0 < d30 && d30 <= 1.0 && 0.0 < d31 && d31 <= 1.0 || bl16) {
                    double d32;
                    double d33;
                    if (bl16) {
                        bl13 = false;
                        d33 = d16;
                        d32 = d20;
                    } else {
                        d33 = d14 + d30 * (d16 - d14);
                        d32 = d15 + d30 * (d17 - d15);
                    }
                    d24 = new Double(d33);
                    d25 = new Double(d32);
                    bl15 = true;
                    bl7 = d33 == d16 && d32 == d17;
                    bl11 = d33 == d20 && d32 == d21;
                    d2 = d24;
                    d4 = d25;
                    d8 = d24;
                    d10 = d25;
                }
            }
            if (bl15) {
                linkedList5.addAll(linkedList);
                linkedList6.addAll(linkedList2);
                linkedList5.add(d24);
                linkedList6.add(d25);
                Collections.reverse(linkedList3);
                Collections.reverse(linkedList4);
                linkedList5.addAll(linkedList3);
                linkedList6.addAll(linkedList4);
                bl2 = d12 <= d6 && d13 <= d7;
                this.createPolygon(graphics2D, rectangle2D, xYPlot, valueAxis, valueAxis2, bl2, linkedList5, linkedList6);
                linkedList.clear();
                linkedList2.clear();
                linkedList3.clear();
                linkedList4.clear();
                linkedList5.clear();
                linkedList6.clear();
                d6 = d23 = d25.doubleValue();
                d12 = d23;
                d7 = d23;
                d13 = d23;
                linkedList5.add(d24);
                linkedList6.add(d25);
            }
            if (d16 <= d20) {
                ++n4;
                bl6 = true;
            } else {
                bl6 = false;
            }
            if (d20 <= d16) {
                ++n6;
                bl10 = true;
            } else {
                bl10 = false;
            }
            bl5 = n4 == n5 - 1;
            bl9 = n6 == n7 - 1;
        }
        if (bl5 && d18 < d16 && d16 < d20) {
            double d34 = (d21 - d19) / (d20 - d18);
            d9 = d3;
            d11 = new Double(d34 * d16 + (d19 - d34 * d18));
        }
        if (bl9 && d14 < d20 && d20 < d16) {
            double d35 = (d17 - d15) / (d16 - d14);
            d3 = d9;
            d5 = new Double(d35 * d20 + (d15 - d35 * d14));
        }
        d6 = Math.max(d6, d5);
        d12 = Math.max(d12, d11);
        d7 = Math.min(d7, d5);
        d13 = Math.min(d13, d11);
        linkedList.add(d3);
        linkedList2.add(d5);
        linkedList3.add(d9);
        linkedList4.add(d11);
        linkedList5.addAll(linkedList);
        linkedList6.addAll(linkedList2);
        Collections.reverse(linkedList3);
        Collections.reverse(linkedList4);
        linkedList5.addAll(linkedList3);
        linkedList6.addAll(linkedList4);
        bl2 = d12 <= d6 && d13 <= d7;
        this.createPolygon(graphics2D, rectangle2D, xYPlot, valueAxis, valueAxis2, bl2, linkedList5, linkedList6);
    }

    protected void drawItemPass1(Graphics2D graphics2D, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n2, int n3, CrosshairState crosshairState) {
        Object object;
        Shape shape = null;
        EntityCollection entityCollection = null;
        if (null != plotRenderingInfo) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        Paint paint = this.getItemPaint(n2, n3);
        Stroke stroke = this.getItemStroke(n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        double d2 = xYDataset.getXValue(n2, n3);
        double d3 = xYDataset.getYValue(n2, n3);
        double d4 = valueAxis.valueToJava2D(d2, rectangle2D, rectangleEdge);
        double d5 = valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge2);
        if (this.getShapesVisible()) {
            object = this.getItemShape(n2, n3);
            object = plotOrientation == PlotOrientation.HORIZONTAL ? ShapeUtilities.createTranslatedShape((Shape)object, d5, d4) : ShapeUtilities.createTranslatedShape((Shape)object, d4, d5);
            if (object.intersects(rectangle2D)) {
                graphics2D.setPaint(this.getItemPaint(n2, n3));
                graphics2D.fill((Shape)object);
            }
            shape = object;
        }
        if (null != entityCollection) {
            if (null == shape) {
                shape = new Rectangle2D.Double(d4 - 2.0, d5 - 2.0, 4.0, 4.0);
            }
            object = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n2, n3);
            if (null != xYToolTipGenerator) {
                object = xYToolTipGenerator.generateToolTip(xYDataset, n2, n3);
            }
            String string = null;
            XYURLGenerator xYURLGenerator = this.getURLGenerator();
            if (null != xYURLGenerator) {
                string = xYURLGenerator.generateURL(xYDataset, n2, n3);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(shape, xYDataset, n2, n3, (String)object, string);
            entityCollection.add(xYItemEntity);
        }
        if (this.isItemLabelVisible(n2, n3)) {
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n2, n3, d4, d5, d5 < 0.0);
        }
        int n4 = xYPlot.getDomainAxisIndex(valueAxis);
        int n5 = xYPlot.getRangeAxisIndex(valueAxis2);
        this.updateCrosshairValues(crosshairState, d2, d3, n4, n5, d4, d5, plotOrientation);
        if (0 == n3) {
            return;
        }
        double d6 = valueAxis.valueToJava2D(xYDataset.getXValue(n2, n3 - 1), rectangle2D, rectangleEdge);
        double d7 = valueAxis2.valueToJava2D(xYDataset.getYValue(n2, n3 - 1), rectangle2D, rectangleEdge2);
        Line2D.Double double_ = null;
        if (PlotOrientation.HORIZONTAL == plotOrientation) {
            double_ = new Line2D.Double(d5, d4, d7, d6);
        } else if (PlotOrientation.VERTICAL == plotOrientation) {
            double_ = new Line2D.Double(d4, d5, d6, d7);
        }
        if (null != double_ && double_.intersects(rectangle2D)) {
            graphics2D.setPaint(this.getItemPaint(n2, n3));
            graphics2D.setStroke(this.getItemStroke(n2, n3));
            graphics2D.draw(double_);
        }
    }

    private boolean isEitherSeriesDegenerate(XYDataset xYDataset, boolean bl2) {
        if (bl2) {
            return xYDataset.getItemCount(0) < 2;
        }
        return xYDataset.getItemCount(0) < 2 || xYDataset.getItemCount(1) < 2;
    }

    private boolean areSeriesDisjoint(XYDataset xYDataset) {
        int n2 = xYDataset.getItemCount(0);
        double d2 = xYDataset.getXValue(0, 0);
        double d3 = xYDataset.getXValue(0, n2 - 1);
        int n3 = xYDataset.getItemCount(1);
        double d4 = xYDataset.getXValue(1, 0);
        double d5 = xYDataset.getXValue(1, n3 - 1);
        return d3 < d4 || d5 < d2;
    }

    private void createPolygon(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, boolean bl2, LinkedList linkedList, LinkedList linkedList2) {
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        RectangleEdge rectangleEdge2 = xYPlot.getRangeAxisEdge();
        Object[] objectArray = linkedList.toArray();
        Object[] objectArray2 = linkedList2.toArray();
        GeneralPath generalPath = new GeneralPath();
        if (PlotOrientation.VERTICAL == plotOrientation) {
            double d2 = valueAxis.valueToJava2D((Double)objectArray[0], rectangle2D, rectangleEdge);
            if (this.roundXCoordinates) {
                d2 = Math.rint(d2);
            }
            double d3 = valueAxis2.valueToJava2D((Double)objectArray2[0], rectangle2D, rectangleEdge2);
            generalPath.moveTo((float)d2, (float)d3);
            for (int i2 = 1; i2 < objectArray.length; ++i2) {
                d2 = valueAxis.valueToJava2D((Double)objectArray[i2], rectangle2D, rectangleEdge);
                if (this.roundXCoordinates) {
                    d2 = Math.rint(d2);
                }
                d3 = valueAxis2.valueToJava2D((Double)objectArray2[i2], rectangle2D, rectangleEdge2);
                generalPath.lineTo((float)d2, (float)d3);
            }
            generalPath.closePath();
        } else {
            double d4 = valueAxis.valueToJava2D((Double)objectArray[0], rectangle2D, rectangleEdge);
            if (this.roundXCoordinates) {
                d4 = Math.rint(d4);
            }
            double d5 = valueAxis2.valueToJava2D((Double)objectArray2[0], rectangle2D, rectangleEdge2);
            generalPath.moveTo((float)d5, (float)d4);
            for (int i3 = 1; i3 < objectArray.length; ++i3) {
                d4 = valueAxis.valueToJava2D((Double)objectArray[i3], rectangle2D, rectangleEdge);
                if (this.roundXCoordinates) {
                    d4 = Math.rint(d4);
                }
                d5 = valueAxis2.valueToJava2D((Double)objectArray2[i3], rectangle2D, rectangleEdge2);
                generalPath.lineTo((float)d5, (float)d4);
            }
            generalPath.closePath();
        }
        if (generalPath.intersects(rectangle2D)) {
            graphics2D.setPaint(bl2 ? this.getPositivePaint() : this.getNegativePaint());
            graphics2D.fill(generalPath);
        }
    }

    @Override
    public LegendItem getLegendItem(int n2, int n3) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n2)) != null && this.getItemVisible(n3, 0)) {
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n3);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n3);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n3);
            }
            Paint paint = this.lookupSeriesPaint(n3);
            Stroke stroke = this.lookupSeriesStroke(n3);
            Shape shape = this.getLegendLine();
            legendItem = new LegendItem(string, string2, string3, string4, shape, stroke, paint);
            legendItem.setLabelFont(this.lookupLegendTextFont(n3));
            Paint paint2 = this.lookupLegendTextPaint(n3);
            if (paint2 != null) {
                legendItem.setLabelPaint(paint2);
            }
            legendItem.setDataset(xYDataset);
            legendItem.setDatasetIndex(n2);
            legendItem.setSeriesKey(xYDataset.getSeriesKey(n3));
            legendItem.setSeriesIndex(n3);
        }
        return legendItem;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYDifferenceRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XYDifferenceRenderer xYDifferenceRenderer = (XYDifferenceRenderer)object;
        if (!PaintUtilities.equal(this.positivePaint, xYDifferenceRenderer.positivePaint)) {
            return false;
        }
        if (!PaintUtilities.equal(this.negativePaint, xYDifferenceRenderer.negativePaint)) {
            return false;
        }
        if (this.shapesVisible != xYDifferenceRenderer.shapesVisible) {
            return false;
        }
        if (!ShapeUtilities.equal(this.legendLine, xYDifferenceRenderer.legendLine)) {
            return false;
        }
        return this.roundXCoordinates == xYDifferenceRenderer.roundXCoordinates;
    }

    @Override
    public Object clone() {
        XYDifferenceRenderer xYDifferenceRenderer = (XYDifferenceRenderer)super.clone();
        xYDifferenceRenderer.legendLine = ShapeUtilities.clone(this.legendLine);
        return xYDifferenceRenderer;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.positivePaint, objectOutputStream);
        SerialUtilities.writePaint(this.negativePaint, objectOutputStream);
        SerialUtilities.writeShape(this.legendLine, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        this.positivePaint = SerialUtilities.readPaint(objectInputStream);
        this.negativePaint = SerialUtilities.readPaint(objectInputStream);
        this.legendLine = SerialUtilities.readShape(objectInputStream);
    }
}

